/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.sqlbuilder.BetweenCondition;
import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomCondition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.NotCondition;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import java.util.Collection;

public class Conditions {
    private Conditions() {
    }

    public static BinaryCondition lessThan(Object value1, Object value2, boolean inclusive) {
        return new BinaryCondition(inclusive ? BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO : BinaryCondition.Op.LESS_THAN, value1, value2);
    }

    public static BinaryCondition lessThan(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.LESS_THAN, value1, value2);
    }

    public static BinaryCondition lessThanOrEq(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, value1, value2);
    }

    public static BinaryCondition greaterThan(Object value1, Object value2, boolean inclusive) {
        return new BinaryCondition(inclusive ? BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO : BinaryCondition.Op.GREATER_THAN, value1, value2);
    }

    public static BinaryCondition greaterThan(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.GREATER_THAN, value1, value2);
    }

    public static BinaryCondition greaterThanOrEq(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, value1, value2);
    }

    public static BinaryCondition equalTo(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.EQUAL_TO, value1, value2);
    }

    public static BinaryCondition notEqualTo(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.NOT_EQUAL_TO, value1, value2);
    }

    public static BinaryCondition like(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.LIKE, value1, value2);
    }

    public static BinaryCondition notLike(Object value1, Object value2) {
        return new BinaryCondition(BinaryCondition.Op.NOT_LIKE, value1, value2);
    }

    public static ComboCondition and() {
        return new ComboCondition(ComboCondition.Op.AND);
    }

    public static ComboCondition and(Condition ... conditions) {
        return Conditions.and((Object[])conditions);
    }

    public static ComboCondition and(Object ... conditions) {
        return new ComboCondition(ComboCondition.Op.AND, conditions);
    }

    public static ComboCondition or() {
        return new ComboCondition(ComboCondition.Op.OR);
    }

    public static ComboCondition or(Condition ... conditions) {
        return Conditions.or((Object[])conditions);
    }

    public static ComboCondition or(Object ... conditions) {
        return new ComboCondition(ComboCondition.Op.OR, conditions);
    }

    public static UnaryCondition isNull(Object value) {
        return new UnaryCondition(UnaryCondition.Op.IS_NULL, value);
    }

    public static UnaryCondition isNotNull(Object value) {
        return new UnaryCondition(UnaryCondition.Op.IS_NOT_NULL, value);
    }

    public static UnaryCondition exists(Object query) {
        return new UnaryCondition(UnaryCondition.Op.EXISTS, query);
    }

    public static UnaryCondition unique(Object query) {
        return new UnaryCondition(UnaryCondition.Op.UNIQUE, query);
    }

    public static NotCondition not(Object condition) {
        return new NotCondition(condition);
    }

    public static InCondition in(Object leftObj, Object ... rightObjs) {
        return new InCondition(leftObj, rightObjs);
    }

    public static InCondition in(Object leftObj, Collection<?> rightObjs) {
        return new InCondition(leftObj, rightObjs);
    }

    public static InCondition notIn(Object leftObj, Object ... rightObjs) {
        return new InCondition(leftObj, rightObjs).setNegate(true);
    }

    public static InCondition notIn(Object leftObj, Collection<?> rightObjs) {
        return new InCondition(leftObj, rightObjs).setNegate(true);
    }

    public static BetweenCondition between(Object obj, Object minObj, Object maxObj) {
        return new BetweenCondition(obj, minObj, maxObj);
    }

    public static BetweenCondition notBetween(Object obj, Object minObj, Object maxObj) {
        return new BetweenCondition(obj, minObj, maxObj).setNegate(true);
    }

    public static CustomCondition customCond(Object condObj) {
        return new CustomCondition(condObj);
    }

    public static Condition emptyCond() {
        return Condition.EMPTY;
    }
}

