/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.BaseCreateQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.DropQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.TypedColumnObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.custom.CustomSyntax;
import com.healthmarketscience.sqlbuilder.custom.HookAnchor;
import com.healthmarketscience.sqlbuilder.custom.HookType;
import com.healthmarketscience.sqlbuilder.custom.oracle.OraTableSpaceClause;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

public class CreateTableQuery
extends BaseCreateQuery<CreateTableQuery> {
    private TableType _tableType;
    protected SqlObjectList<SqlObject> _constraints = SqlObjectList.create();

    public CreateTableQuery(Table table) {
        this(table, false);
    }

    public CreateTableQuery(Table table, boolean includeColumns) {
        this((Object)table);
        if (includeColumns) {
            this._columns.addObjects(Converter.TYPED_COLUMN_TO_OBJ, table.getColumns());
            this._constraints.addObjects(Converter.CUSTOM_TO_CONSTRAINTCLAUSE, table.getConstraints());
        }
    }

    public CreateTableQuery(Object tableStr) {
        super(Converter.toCustomTableSqlObject(tableStr));
    }

    @Override
    public DropQuery getDropQuery() {
        return new DropQuery(DropQuery.Type.TABLE, this._object);
    }

    public CreateTableQuery setTableType(TableType tableType) {
        this._tableType = tableType;
        return this;
    }

    @Override
    public CreateTableQuery addCustomColumns(Object ... typedColumnStrs) {
        this._columns.addObjects(Converter.TYPED_COLUMN_TO_OBJ, typedColumnStrs);
        return this;
    }

    @Deprecated
    public CreateTableQuery addColumn(Column column, ColumnConstraint constraint) {
        return this.addCustomColumn(column, constraint);
    }

    @Deprecated
    public CreateTableQuery addCustomColumn(Object columnStr, ColumnConstraint constraint) {
        SqlObject column = Converter.TYPED_COLUMN_TO_OBJ.convert(columnStr);
        if (column instanceof TypedColumnObject) {
            ((TypedColumnObject)column).addConstraint((Object)constraint);
        } else {
            column = new ConstrainedColumn(column, (Object)constraint);
        }
        this._columns.addObject(column);
        return this;
    }

    @Deprecated
    public CreateTableQuery setColumnConstraint(Column column, ColumnConstraint constraint) {
        return this.addColumnConstraint(column, (Object)constraint);
    }

    public CreateTableQuery addColumnConstraint(Column column, Object constraint) {
        for (SqlObject tmpCol : this._columns) {
            if (!(tmpCol instanceof TypedColumnObject) || ((TypedColumnObject)tmpCol)._column != column) continue;
            ((TypedColumnObject)tmpCol).addConstraint(constraint);
            break;
        }
        return this;
    }

    public CreateTableQuery setColumnDefaultValue(Column column, Object defaultValue) {
        for (SqlObject tmpCol : this._columns) {
            if (!(tmpCol instanceof TypedColumnObject) || ((TypedColumnObject)tmpCol)._column != column) continue;
            ((TypedColumnObject)tmpCol).setDefaultValue(defaultValue);
            break;
        }
        return this;
    }

    public CreateTableQuery setColumnTypeName(Column column, String typeName) {
        for (SqlObject tmpCol : this._columns) {
            if (!(tmpCol instanceof TypedColumnObject) || ((TypedColumnObject)tmpCol)._column != column) continue;
            ((TypedColumnObject)tmpCol).setTypeName(typeName);
            break;
        }
        return this;
    }

    public CreateTableQuery addConstraints(Constraint ... constraints) {
        return this.addCustomConstraints(constraints);
    }

    public CreateTableQuery addCustomConstraints(Object ... constraintStrs) {
        this._constraints.addObjects(Converter.CUSTOM_TO_CONSTRAINTCLAUSE, constraintStrs);
        return this;
    }

    @Deprecated
    public CreateTableQuery setTableSpace(String tableSpace) {
        return this.addCustomization(new OraTableSpaceClause(tableSpace));
    }

    public CreateTableQuery addCustomization(Hook hook, HookType type, Object obj) {
        super.addCustomization(hook, type, obj);
        return this;
    }

    public CreateTableQuery addCustomization(CustomSyntax obj) {
        if (obj != null) {
            obj.apply(this);
        }
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._constraints.collectSchemaObjects(vContext);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (this._columns.isEmpty()) {
            throw new ValidationException("Table has no columns");
        }
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        this.customAppendTo(app, Hook.HEADER);
        app.append("CREATE ");
        if (this._tableType != null) {
            app.append((Object)this._tableType);
        }
        this.customAppendTo(app, Hook.TABLE, "TABLE ").append(this._object).append(" (").append(this._columns);
        if (!this._constraints.isEmpty()) {
            app.append(SqlObjectList.DEFAULT_DELIMITER).append(this._constraints);
        }
        app.append(")");
        this.customAppendTo(app, Hook.TRAILER);
    }

    private static class ConstrainedColumn
    extends SqlObject {
        private SqlObject _column;
        private Object _constraint;

        private ConstrainedColumn(SqlObject column, Object constraint) {
            this._column = column;
            this._constraint = constraint;
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
            this._column.collectSchemaObjects(vContext);
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            app.append(this._column).append(" ").append(this._constraint);
        }
    }

    public static enum TableType {
        GLOBAL_TEMP("GLOBAL TEMPORARY "),
        LOCAL_TEMP("LOCAL TEMPORARY "),
        TEMPORARY("TEMPORARY ");

        private final String _typeClause;

        private TableType(String typeClause) {
            this._typeClause = typeClause;
        }

        public String toString() {
            return this._typeClause;
        }
    }

    @Deprecated
    public static enum ColumnConstraint {
        NOT_NULL("NOT NULL"),
        UNIQUE("UNIQUE"),
        PRIMARY_KEY("PRIMARY KEY");

        private final String _constraintClause;

        private ColumnConstraint(String constraintClause) {
            this._constraintClause = constraintClause;
        }

        public String toString() {
            return this._constraintClause;
        }
    }

    public static enum Hook implements HookAnchor
    {
        HEADER,
        TABLE,
        TRAILER;

    }
}

