/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.ConstraintClause;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.ForeignKeyConstraint;
import java.io.IOException;
import java.util.List;

public class ForeignKeyConstraintClause
extends ConstraintClause {
    protected SqlObject _refTable;
    protected SqlObjectList<SqlObject> _refColumns = SqlObjectList.create();
    protected Object _onDeleteAction;
    protected Object _onUpdateAction;

    public ForeignKeyConstraintClause(ForeignKeyConstraint fkConstraint) {
        this(fkConstraint, fkConstraint.getColumns(), fkConstraint.getReferencedTable(), fkConstraint.getReferencedColumns());
    }

    public ForeignKeyConstraintClause(Object name, Object refTableStr) {
        this(name, null, refTableStr, null);
    }

    protected ForeignKeyConstraintClause(Object name, List<?> columns, Object refTableStr, List<?> refColumnStrs) {
        super(ConstraintClause.Type.FOREIGN_KEY, name, columns);
        this._refTable = Converter.toCustomTableSqlObject(refTableStr);
        this._refColumns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, refColumnStrs);
    }

    @Override
    public ForeignKeyConstraintClause addColumns(Column ... columns) {
        return this.addCustomColumns(columns);
    }

    @Override
    public ForeignKeyConstraintClause addCustomColumns(Object ... columnStrs) {
        super.addCustomColumns(columnStrs);
        return this;
    }

    public ForeignKeyConstraintClause addRefColumns(Column ... columns) {
        return this.addCustomRefColumns(columns);
    }

    public ForeignKeyConstraintClause addCustomRefColumns(Object ... columnStrs) {
        this._refColumns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public ForeignKeyConstraintClause setOnDeleteAction(Object action) {
        this._onDeleteAction = action;
        return this;
    }

    public ForeignKeyConstraintClause setOnUpdateAction(Object action) {
        this._onUpdateAction = action;
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        if (!vContext.isLocalOnly()) {
            ValidationContext refVContext = new ValidationContext(vContext);
            this._refTable.collectSchemaObjects(refVContext);
            this._refColumns.collectSchemaObjects(refVContext);
        }
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        this.preAppendTo(app);
        if (SqlContext.getContext(app).getUseTableConstraints()) {
            app.append(" ").append(this._type.toString(false));
        }
        app.append(" ").append(this._refTable);
        if (!this._refColumns.isEmpty()) {
            app.append(" (").append(this._refColumns).append(")");
        }
        if (this._onDeleteAction != null) {
            app.append(" ON DELETE ").append(this._onDeleteAction);
        }
        if (this._onUpdateAction != null) {
            app.append(" ON UPDATE ").append(this._onUpdateAction);
        }
        this.postAppendTo(app);
    }

    public static enum ReferentialAction {
        CASCADE("CASCADE"),
        RESTRICT("RESTRICT"),
        SET_NULL("SET NULL"),
        SET_DEFAULT("SET DEFAULT"),
        NO_ACTION("NO ACTION");

        private final String _str;

        private ReferentialAction(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }
    }
}

