/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.BaseInsertQuery;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

public class InsertSelectQuery
extends BaseInsertQuery<InsertSelectQuery> {
    private SelectQuery _selectQuery;

    public InsertSelectQuery(Table table) {
        this((Object)table);
    }

    public InsertSelectQuery(Object tableStr) {
        super(Converter.toCustomTableSqlObject(tableStr));
    }

    public InsertSelectQuery setSelectQuery(SelectQuery selectQuery) {
        this._selectQuery = selectQuery;
        return this;
    }

    public InsertSelectQuery addCustomColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public InsertSelectQuery addColumns(Column ... columns) {
        return this.addCustomColumns(columns);
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        vContext.collectNestedQuerySchemaObjects(this._selectQuery);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (this._selectQuery == null) {
            throw new ValidationException("missing select query");
        }
        SqlObjectList<SqlObject> selectColumns = this._selectQuery.getColumns();
        if (this._columns.size() != selectColumns.size() && !this._selectQuery.hasAllColumns()) {
            throw new ValidationException("mismatched columns and select columns for insert, found " + this._columns.size() + " while query has " + selectColumns.size());
        }
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        this.appendPrefixTo(app);
        app.append(this._selectQuery);
    }
}

