/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum ArchiveType implements Api
{
    APK("apk", "apk", ".apk"),
    BIN("bin", "bin", ".bin"),
    CAB("cab", "cab", ".cab"),
    DEB("deb", "deb", ".deb"),
    DMG("dmg", "dmg", ".dmg"),
    MSI("msi", "msi", ".msi"),
    PKG("pkg", "pkg", ".pkg"),
    RPM("rpm", "rpm", ".rpm"),
    SRC_TAR("src.tar.gz", "src_tar", ".src.tar.gz", ".source.tar.gz", ".source.tar.gz"),
    TAR("tar", "tar", ".tar"),
    TAR_GZ("tar.gz", "tar.gz", ".tar.gz"),
    TAR_XZ("tar.xz", "tar.xz", ".tar.xz"),
    TGZ("tgz", "tgz", ".tgz"),
    TAR_Z("tar.Z", "tar.z", ".tar.Z"),
    ZIP("zip", "zip", ".zip"),
    EXE("exe", "exe", ".exe"),
    NONE("-", "", "-"),
    NOT_FOUND("", "", "");

    private final String uiString;
    private final String apiString;
    private final List<String> fileEndings;

    private ArchiveType(String uiString, String apiString, String ... fileEndings) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.fileEndings = List.of(fileEndings);
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public ArchiveType getDefault() {
        return NONE;
    }

    @Override
    public ArchiveType getNotFound() {
        return NOT_FOUND;
    }

    public ArchiveType[] getAll() {
        return ArchiveType.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static ArchiveType fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        return switch (text) {
            case "apk", ".apk", "APK" -> APK;
            case "bin", ".bin", "BIN" -> BIN;
            case "cab", ".cab", "CAB" -> CAB;
            case "deb", ".deb", "DEB" -> DEB;
            case "dmg", ".dmg", "DMG" -> DMG;
            case "exe", ".exe", "EXE" -> EXE;
            case "msi", ".msi", "MSI" -> MSI;
            case "pkg", ".pkg", "PKG" -> PKG;
            case "rpm", ".rpm", "RPM" -> RPM;
            case "src.tar.gz", ".src.tar.gz", "source.tar.gz", "SRC.TAR.GZ", "src_tar", "SRC_TAR" -> SRC_TAR;
            case "tar.Z", ".tar.Z", "TAR.Z", "tar.z" -> TAR_Z;
            case "tar.gz", ".tar.gz", "TAR.GZ" -> TAR_GZ;
            case "tar.xz", ".tar.xz", "TAR.XZ" -> TAR_XZ;
            case "tgz", ".tgz", "TGZ" -> TGZ;
            case "tar", ".tar", "TAR" -> TAR;
            case "zip", ".zip", "ZIP" -> ZIP;
            default -> NOT_FOUND;
        };
    }

    public List<String> getFileEndings() {
        return this.fileEndings;
    }

    public static ArchiveType getFromFileName(String filename) {
        if (null == filename || filename.isEmpty()) {
            return NONE;
        }
        for (ArchiveType archiveType : ArchiveType.values()) {
            for (String ending : archiveType.getFileEndings()) {
                if (!filename.toLowerCase().endsWith(ending)) continue;
                return archiveType;
            }
        }
        return NONE;
    }

    public static List<ArchiveType> getAsList() {
        return Arrays.asList(ArchiveType.values());
    }
}

