/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.LibCType;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OperatingSystem implements Api
{
    ALPINE_LINUX("Alpine Linux", "linux", LibCType.MUSL){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of(LINUX, LINUX_MUSL);
        }
    }
    ,
    LINUX("Linux", "linux", LibCType.GLIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    LINUX_MUSL("Linux Musl", "linux", LibCType.MUSL){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of(LINUX, ALPINE_LINUX);
        }
    }
    ,
    FREE_BSD("FreeBSD", "free_bsd", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    MACOS("Mac OS", "macos", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    WINDOWS("Windows", "windows", LibCType.C_STD_LIB){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    SOLARIS("Solaris", "solaris", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    QNX("QNX", "qnx", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    AIX("AIX", "aix", LibCType.LIBC){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    NONE("-", "", LibCType.NONE){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    }
    ,
    NOT_FOUND("", "", LibCType.NOT_FOUND){

        @Override
        public List<OperatingSystem> getSynonyms() {
            return List.of();
        }
    };

    private final String uiString;
    private final String apiString;
    private final LibCType libCType;

    private OperatingSystem(String uiString, String apiString, LibCType libCType) {
        this.uiString = uiString;
        this.apiString = apiString;
        this.libCType = libCType;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public OperatingSystem getDefault() {
        return NONE;
    }

    @Override
    public OperatingSystem getNotFound() {
        return NOT_FOUND;
    }

    public OperatingSystem[] getAll() {
        return OperatingSystem.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",\n").append("  \"").append("lib_c_type").append("\"").append(":").append("\"").append(this.libCType.getApiString()).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append(",").append("\"").append("lib_c_type").append("\"").append(":").append("\"").append(this.libCType.getApiString()).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public static OperatingSystem fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        return switch (text) {
            case "-linux", "linux", "Linux", "LINUX", "unix", "UNIX", "Unix", "-unix" -> LINUX;
            case "-linux-musl", "-linux_musl", "Linux-Musl", "linux-musl", "Linux_Musl", "LINUX_MUSL", "linux_musl", "alpine", "ALPINE", "Alpine", "alpine-linux", "ALPINE-LINUX", "alpine_linux", "Alpine_Linux", "ALPINE_LINUX", "Alpine Linux", "alpine linux", "ALPINE LINUX" -> ALPINE_LINUX;
            case "free_bsd", "FREE_BSD", "FREE BSD", "free bsd", "freebsd", "FreeBSD", "freeBSD" -> FREE_BSD;
            case "-solaris", "solaris", "SOLARIS", "Solaris" -> SOLARIS;
            case "-qnx", "qnx", "QNX" -> QNX;
            case "-aix", "aix", "AIX" -> AIX;
            case "darwin", "-darwin", "-macosx", "-MACOSX", "MacOS", "Mac OS", "mac_os", "Mac_OS", "mac-os", "Mac-OS", "mac", "MAC", "macos", "MACOS", "osx", "OSX", "macosx", "MACOSX", "Mac OSX", "mac osx" -> MACOS;
            case "-win", "windows", "Windows", "WINDOWS", "win", "Win", "WIN" -> WINDOWS;
            default -> NOT_FOUND;
        };
    }

    public LibCType getLibCType() {
        return this.libCType;
    }

    public static List<OperatingSystem> getAsList() {
        return Arrays.asList(OperatingSystem.values());
    }

    public abstract List<OperatingSystem> getSynonyms();
}

