/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.poi_ww;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import java.util.ArrayList;
import javafx.scene.paint.Color;
import org.mapton.api.MDict;
import org.mapton.api.MPoi;
import org.mapton.api.MPoiManager;
import org.mapton.api.MPoiStyle;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.WWHelper;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.fx.FxHelper;

public class PoiLayerBundle
extends LayerBundle {
    private final RenderableLayer mLayer = new RenderableLayer();
    private final MPoiManager mPoiManager = MPoiManager.getInstance();

    public PoiLayerBundle() {
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(5000L);
    }

    private void init() {
        this.mLayer.setName(MDict.POI.toString());
        this.setCategorySystem((Layer)this.mLayer);
        this.setName(MDict.POI.toString());
        this.attachTopComponentToLayer("PoiTopComponent", (Layer)this.mLayer);
        this.setParentLayer((Layer)this.mLayer);
        this.mLayer.setEnabled(true);
        this.mLayer.setPickEnabled(true);
    }

    private void initListeners() {
        this.mPoiManager.getTimeFilteredItems().addListener(c -> this.repaint());
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            for (MPoi poi : new ArrayList(this.mPoiManager.getTimeFilteredItems())) {
                if (!poi.isDisplayMarker().booleanValue()) continue;
                PointPlacemark placemark = new PointPlacemark(Position.fromDegrees((double)poi.getLatitude(), (double)poi.getLongitude()));
                placemark.setAltitudeMode(1);
                placemark.setEnableLabelPicking(true);
                PointPlacemarkAttributes attrs = new PointPlacemarkAttributes(placemark.getDefaultAttributes());
                MPoiStyle style = poi.getStyle();
                if (style == null) {
                    placemark.setLabelText(poi.getName());
                    attrs.setImageAddress("images/pushpins/plain-white.png");
                    try {
                        attrs.setImageColor(FxHelper.colorToColor((Color)FxHelper.colorFromHexRGBA((String)poi.getColor())));
                    }
                    catch (Exception exception) {}
                } else {
                    String label = style.getLabelText() != null ? style.getLabelText() : poi.getName();
                    placemark.setLabelText(style.isLabelVisible() ? label : null);
                    attrs.setLabelScale(Double.valueOf(style.getLabelScale()));
                    attrs.setImageOffset(WWHelper.offsetFromImageLocation((MPoiStyle.ImageLocation)style.getImageLocation()));
                    if (style.getImageUrl() == null) {
                        attrs.setImageAddress("images/pushpins/plain-white.png");
                    } else {
                        attrs.setImageAddress(style.getImageUrl());
                        attrs.setScale(Double.valueOf(style.getImageScale()));
                        try {
                            attrs.setImageColor(FxHelper.colorToColor((Color)FxHelper.colorFromHexRGBA((String)style.getImageColor())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    attrs.setScale(Double.valueOf(style.getImageScale()));
                }
                placemark.setAttributes(attrs);
                placemark.setHighlightAttributes(WWHelper.createHighlightAttributes((PointPlacemarkAttributes)attrs, (double)1.5));
                placemark.setValue("mapton.runnable.left_click", () -> this.mPoiManager.setSelectedItemAfterReset((Object)poi));
                placemark.setValue("mapton.runnable.left_double_click", () -> Almond.openAndActivateTopComponent((String)((String)this.mLayer.getValue("mapton.layer.fast_open"))));
                this.mLayer.addRenderable((Renderable)placemark);
            }
            this.setDragEnabled(false);
        });
    }
}

