/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx;

import eu.hansolo.toolbox.Helper;
import eu.hansolo.toolbox.Statistics;
import eu.hansolo.toolbox.tuples.Pair;
import eu.hansolo.toolboxfx.geom.Bounds;
import eu.hansolo.toolboxfx.geom.CardinalDirection;
import eu.hansolo.toolboxfx.geom.CatmullRom;
import eu.hansolo.toolboxfx.geom.CornerRadii;
import eu.hansolo.toolboxfx.geom.Dimension;
import eu.hansolo.toolboxfx.geom.Point;
import eu.hansolo.toolboxfx.geom.Position;
import eu.hansolo.toolboxfx.geom.QuickHull;
import eu.hansolo.toolboxfx.geom.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.ColorInput;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.imageio.ImageIO;

public class HelperFX {
    private HelperFX() {
    }

    public static final double nearest(double smaller, double value, double larger) {
        return value - smaller < larger - value ? smaller : larger;
    }

    public static final double[] calcAutoScale(double minValue, double maxValue) {
        return HelperFX.calcAutoScale(minValue, maxValue, 10.0, 10.0);
    }

    public static final double[] calcAutoScale(double minValue, double maxValue, double maxNoOfMajorTicks, double maxNoOfMinorTicks) {
        double niceRange = HelperFX.calcNiceNumber(maxValue - minValue, false);
        double majorTickSpace = HelperFX.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true);
        double niceMinValue = Math.floor(minValue / majorTickSpace) * majorTickSpace;
        double niceMaxValue = Math.ceil(maxValue / majorTickSpace) * majorTickSpace;
        double minorTickSpace = HelperFX.calcNiceNumber(majorTickSpace / (maxNoOfMinorTicks - 1.0), true);
        return new double[]{niceMinValue, niceMaxValue, majorTickSpace, minorTickSpace};
    }

    public static final double snapToTicks(double minValue, double maxValue, double value, int newMinorTickCount, double newMajorTickUnit) {
        double v = value;
        int minorTickCount = Helper.clamp((int)0, (int)10, (int)newMinorTickCount);
        double majorTickUnit = Double.compare(newMajorTickUnit, 0.0) <= 0 ? 0.25 : newMajorTickUnit;
        double tickSpacing = minorTickCount == 0 ? majorTickUnit : majorTickUnit / (double)(Math.max(minorTickCount, 0) + 1);
        int prevTick = (int)((v - minValue) / tickSpacing);
        double prevTickValue = (double)prevTick * tickSpacing + minValue;
        double nextTickValue = (double)(prevTick + 1) * tickSpacing + minValue;
        v = HelperFX.nearest(prevTickValue, v, nextTickValue);
        return Helper.clamp((double)minValue, (double)maxValue, (double)v);
    }

    public static final double calcNiceNumber(double range, boolean round) {
        double exponent = Math.floor(Math.log10(range));
        double fraction = range / Math.pow(10.0, exponent);
        double niceFraction = round ? (Double.compare(fraction, 1.5) < 0 ? 1.0 : (Double.compare(fraction, 3.0) < 0 ? 2.0 : (Double.compare(fraction, 7.0) < 0 ? 5.0 : 10.0))) : (Double.compare(fraction, 1.0) <= 0 ? 1.0 : (Double.compare(fraction, 2.0) <= 0 ? 2.0 : (Double.compare(fraction, 5.0) <= 0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, exponent);
    }

    public static final List<Point> subdividePoints(List<Point> points, int subDevisions) {
        return Arrays.asList(HelperFX.subdividePoints(points.toArray(new Point[0]), subDevisions));
    }

    public static final Point[] subdividePoints(Point[] points, int subDevisions) {
        assert (points != null);
        assert (points.length >= 3);
        int noOfPoints = points.length;
        Point[] subdividedPoints = new Point[(noOfPoints - 1) * subDevisions + 1];
        double increments = 1.0 / (double)subDevisions;
        for (int i = 0; i < noOfPoints - 1; ++i) {
            Point p0 = i == 0 ? points[i] : points[i - 1];
            Point p1 = points[i];
            Point p2 = points[i + 1];
            Point p3 = i + 2 == noOfPoints ? points[i + 1] : points[i + 2];
            CatmullRom<Point> crs = new CatmullRom<Point>(p0, p1, p2, p3);
            for (int j = 0; j <= subDevisions; ++j) {
                subdividedPoints[i * subDevisions + j] = crs.q((double)j * increments);
            }
        }
        return subdividedPoints;
    }

    public static final List<Point> subdividePointsRadial(List<Point> points, int subDevisions) {
        return Arrays.asList(HelperFX.subdividePointsRadial(points.toArray(new Point[0]), subDevisions));
    }

    public static final Point[] subdividePointsRadial(Point[] points, int subDivisions) {
        assert (points != null);
        assert (points.length >= 3);
        int noOfPoints = points.length;
        Point[] subdividedPoints = new Point[(noOfPoints - 1) * subDivisions + 1];
        double increments = 1.0 / (double)subDivisions;
        for (int i = 0; i < noOfPoints - 1; ++i) {
            Point p0 = i == 0 ? points[noOfPoints - 2] : points[i - 1];
            Point p1 = points[i];
            Point p2 = points[i + 1];
            Point p3 = i == noOfPoints - 2 ? points[1] : points[i + 2];
            CatmullRom<Point> crs = new CatmullRom<Point>(p0, p1, p2, p3);
            for (int j = 0; j <= subDivisions; ++j) {
                subdividedPoints[i * subDivisions + j] = crs.q((double)j * increments);
            }
        }
        return subdividedPoints;
    }

    public static final List<Point> subdividePointsLinear(List<Point> points, int subDevisions) {
        return Arrays.asList(HelperFX.subdividePointsLinear(points.toArray(new Point[0]), subDevisions));
    }

    public static final Point[] subdividePointsLinear(Point[] points, int subDivisions) {
        assert (points != null);
        assert (points.length >= 3);
        int noOfPoints = points.length;
        Point[] subdividedPoints = new Point[(noOfPoints - 1) * subDivisions + 1];
        double stepSize = (points[1].getX() - points[0].getX()) / (double)subDivisions;
        for (int i = 0; i < noOfPoints - 1; ++i) {
            for (int j = 0; j <= subDivisions; ++j) {
                subdividedPoints[i * subDivisions + j] = HelperFX.calcIntermediatePoint(points[i], points[i + 1], stepSize * (double)j);
            }
        }
        return subdividedPoints;
    }

    public static final Point calcIntermediatePoint(Point leftPoint, Point rightPoint, double intervalX) {
        double m = (rightPoint.getY() - leftPoint.getY()) / (rightPoint.getX() - leftPoint.getX());
        double x = intervalX;
        double y = m * x;
        return new Point(leftPoint.getX() + x, leftPoint.getY() + y);
    }

    public static final Point calcIntersectionOfTwoLines(Point A, Point B, Point C, Point D) {
        return HelperFX.calcIntersectionOfTwoLines(A.getX(), A.getY(), B.getX(), B.getY(), C.getX(), C.getY(), D.getX(), D.getY());
    }

    public static final Point calcIntersectionOfTwoLines(double X1, double Y1, double X2, double Y2, double X3, double Y3, double X4, double Y4) {
        double a1 = Y2 - Y1;
        double b1 = X1 - X2;
        double c1 = a1 * X1 + b1 * Y1;
        double a2 = Y4 - Y3;
        double b2 = X3 - X4;
        double c2 = a2 * X3 + b2 * Y3;
        double determinant = a1 * b2 - a2 * b1;
        if (determinant == 0.0) {
            return new Point(Double.MAX_VALUE, Double.MAX_VALUE);
        }
        double x = (b2 * c1 - b1 * c2) / determinant;
        double y = (a1 * c2 - a2 * c1) / determinant;
        return new Point(x, y);
    }

    public static final Point calcIntersectionPoint(Point leftPoint, Point rightPoint, double intersectionY) {
        double[] xy = HelperFX.calculateIntersectionPoint(leftPoint.getX(), leftPoint.getY(), rightPoint.getX(), rightPoint.getY(), intersectionY);
        return new Point(xy[0], xy[1]);
    }

    public static final double[] calculateIntersectionPoint(Point leftPoint, Point rightPoint, double intersectionY) {
        return HelperFX.calculateIntersectionPoint(leftPoint.getX(), leftPoint.getY(), rightPoint.getX(), rightPoint.getY(), intersectionY);
    }

    public static final double[] calculateIntersectionPoint(double x1, double y1, double x2, double y2, double intersectionY) {
        double m = (y2 - y1) / (x2 - x1);
        double interSectionX = (intersectionY - y1) / m;
        return new double[]{x1 + interSectionX, intersectionY};
    }

    public static final Point[] smoothSparkLine(List<Double> dataList, double minValue, double maxValue, Rectangle graphBounds, int noOfDatapoints) {
        double high;
        int size = dataList.size();
        Point[] points = new Point[size];
        double low = Statistics.getMin(dataList);
        if (Helper.equals((double)low, (double)(high = Statistics.getMax(dataList)))) {
            low = minValue;
            high = maxValue;
        }
        double range = high - low;
        double minX = graphBounds.getX();
        double maxX = minX + graphBounds.getWidth();
        double minY = graphBounds.getY();
        double maxY = minY + graphBounds.getHeight();
        double stepX = graphBounds.getWidth() / (double)(noOfDatapoints - 1);
        double stepY = graphBounds.getHeight() / range;
        for (int i = 0; i < size; ++i) {
            points[i] = new Point(minX + (double)i * stepX, maxY - Math.abs(low - dataList.get(i)) * stepY);
        }
        return HelperFX.subdividePoints(points, 16);
    }

    public static final boolean isInRectangle(double x, double y, double minX, double minY, double maxX, double maxY) {
        return Double.compare(x, minX) >= 0 && Double.compare(y, minY) >= 0 && Double.compare(x, maxX) <= 0 && Double.compare(y, maxY) <= 0;
    }

    public static final boolean isInCircle(double x, double y, double centerX, double centerY, double radius) {
        double deltaX = centerX - x;
        double deltaY = centerY - y;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY) < radius;
    }

    public static final boolean isInEllipse(double x, double y, double centerX, double centerY, double radiusX, double radiusY) {
        return (double)Double.compare((x - centerX) * (x - centerX) / (radiusX * radiusX) + (y - centerY) * (y - centerY) / (radiusY * radiusY), 1.0) <= 0.0;
    }

    public static final boolean isInPolygon(double x, double y, List<Point> pointsOfPolygon) {
        int noOfPointsInPolygon = pointsOfPolygon.size();
        double[] pointsX = new double[noOfPointsInPolygon];
        double[] pointsY = new double[noOfPointsInPolygon];
        for (int i = 0; i < noOfPointsInPolygon; ++i) {
            Point p = pointsOfPolygon.get(i);
            pointsX[i] = p.getX();
            pointsY[i] = p.getY();
        }
        return HelperFX.isInPolygon(x, y, noOfPointsInPolygon, pointsX, pointsY);
    }

    public static final boolean isInPolygon(double x, double y, int noOfPointsInPolygon, double[] pointsX, double[] pointsY) {
        if (noOfPointsInPolygon != pointsX.length || noOfPointsInPolygon != pointsY.length) {
            return false;
        }
        boolean inside = false;
        int i = 0;
        int j = noOfPointsInPolygon - 1;
        while (i < noOfPointsInPolygon) {
            if (pointsY[i] > y != pointsY[j] > y && x < (pointsX[j] - pointsX[i]) * (y - pointsY[i]) / (pointsY[j] - pointsY[i]) + pointsX[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public static final <T extends Point> boolean isPointInPolygon(T p, List<T> points) {
        boolean inside = false;
        int noOfPoints = points.size();
        double x = p.getX();
        double y = p.getY();
        int i = 0;
        int j = noOfPoints - 1;
        while (i < noOfPoints) {
            if (((Point)points.get(i)).getY() > y != ((Point)points.get(j)).getY() > y && x < (((Point)points.get(j)).getX() - ((Point)points.get(i)).getX()) * (y - ((Point)points.get(i)).getY()) / (((Point)points.get(j)).getY() - ((Point)points.get(i)).getY()) + ((Point)points.get(i)).getX()) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public static final boolean isInSector(double x, double y, double centerX, double centerY, double radius, double startAngle, double segmentAngle) {
        return HelperFX.isInRingSegment(x, y, centerX, centerY, radius, 0.0, startAngle, segmentAngle);
    }

    public static final boolean isInRingSegment(double x, double y, double centerX, double centerY, double outerRadius, double innerRadius, double newStartAngle, double segmentAngle) {
        double angleOffset = 90.0;
        double pointRadius = Math.sqrt((x - centerX) * (x - centerX) + (y - centerY) * (y - centerY));
        double pointAngle = HelperFX.getAngleFromXY(x, y, centerX, centerY, angleOffset);
        double startAngle = angleOffset - newStartAngle;
        double endAngle = startAngle + segmentAngle;
        return Double.compare(pointRadius, innerRadius) >= 0 && Double.compare(pointRadius, outerRadius) <= 0 && Double.compare(pointAngle, startAngle) >= 0 && Double.compare(pointAngle, endAngle) <= 0;
    }

    public static final boolean isPointOnLine(Point p, Point p1, Point p2) {
        return HelperFX.distanceFromPointToLine(p, p1, p2) < 1.0E-6;
    }

    public static final double distanceFromPointToLine(Point p, Point p1, Point p2) {
        double yy;
        double xx;
        double len_sq;
        double D;
        double A = p.getX() - p1.getX();
        double B = p.getY() - p1.getY();
        double C = p2.getX() - p1.getX();
        double dot = A * C + B * (D = p2.getY() - p1.getY());
        double param = dot / (len_sq = C * C + D * D);
        if (param < 0.0 || p1.getX() == p2.getX() && p1.getY() == p2.getY()) {
            xx = p1.getX();
            yy = p1.getY();
        } else if (param > 1.0) {
            xx = p2.getX();
            yy = p2.getY();
        } else {
            xx = p1.getX() + param * C;
            yy = p1.getY() + param * D;
        }
        double dx = p.getX() - xx;
        double dy = p.getY() - yy;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static final <T extends Point> double squareDistance(T p1, T p2) {
        return HelperFX.squareDistance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double squareDistance(double x1, double y1, double x2, double y2) {
        double deltaX = x1 - x2;
        double deltaY = y1 - y2;
        return deltaX * deltaX + deltaY * deltaY;
    }

    public static final double distance(Point p1, Point p2) {
        return HelperFX.distance(p1.x, p1.y, p2.x, p2.y);
    }

    public static final double distance(double p1X, double p1Y, double p2X, double p2Y) {
        return Math.sqrt((p2X - p1X) * (p2X - p1X) + (p2Y - p1Y) * (p2Y - p1Y));
    }

    public static final double euclideanDistance(Point p1, Point p2) {
        return HelperFX.euclideanDistance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double euclideanDistance(double x1, double y1, double x2, double y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return deltaX * deltaX + deltaY * deltaY;
    }

    public static final Point pointOnLine(double p1X, double p1Y, double p2X, double p2Y, double distanceToP2) {
        double distanceP1P2 = HelperFX.distance(p1X, p1Y, p2X, p2Y);
        double t = distanceToP2 / distanceP1P2;
        return new Point((1.0 - t) * p1X + t * p2X, (1.0 - t) * p1Y + t * p2Y);
    }

    public static final int checkLineCircleCollision(Point p1, Point p2, double centerX, double centerY, double radius) {
        return HelperFX.checkLineCircleCollision(p1.x, p1.y, p2.x, p2.y, centerX, centerY, radius);
    }

    public static final int checkLineCircleCollision(double p1X, double p1Y, double p2X, double p2Y, double centerX, double centerY, double radius) {
        double A = p1Y - p2Y;
        double B = p2X - p1X;
        double C = p1X * p2Y - p2X * p1Y;
        return HelperFX.checkCollision(A, B, C, centerX, centerY, radius);
    }

    public static final int checkCollision(double a, double b, double c, double centerX, double centerY, double radius) {
        double dist = Math.abs(a * centerX + b * centerY + c) / Math.sqrt(a * a + b * b);
        if (radius > (dist = Helper.round((double)dist, (int)1))) {
            return 1;
        }
        if (radius < dist) {
            return -1;
        }
        return 0;
    }

    public static final int checkCircleCircleCollision(Point center1, double radius1, Point center2, double radius2) {
        double d = Math.sqrt((center1.getX() - center2.getX()) * (center1.getX() - center2.getX()) + (center1.getY() - center2.getY()) * (center1.getY() - center2.getY()));
        if (d <= radius1 - radius2) {
            return 1;
        }
        if (d <= radius2 - radius1) {
            return 1;
        }
        if (d < radius1 + radius2) {
            return 1;
        }
        if (Double.compare(d, radius1 + radius2) == 0) {
            return 0;
        }
        return -1;
    }

    public static final double getAngleFromXY(double x, double y, double centerX, double centerY) {
        return HelperFX.getAngleFromXY(x, y, centerX, centerY, 90.0);
    }

    public static final double getAngleFromXY(double x, double y, double centerX, double centerY, double angleOffset) {
        double nx;
        double deltaY = y - centerY;
        double deltaX = x - centerX;
        double radius = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        double ny = deltaY / radius;
        double theta = Math.atan2(ny, nx = deltaX / radius);
        theta = Double.compare(theta, 0.0) >= 0 ? Math.toDegrees(theta) : Math.toDegrees(theta) + 360.0;
        return (theta + angleOffset) % 360.0;
    }

    public static final double[] rotatePointAroundRotationCenter(double x, double y, double rX, double rY, double angleDeg) {
        double rad = Math.toRadians(angleDeg);
        double sin = Math.sin(rad);
        double cos = Math.cos(rad);
        double nX = rX + (x - rX) * cos - (y - rY) * sin;
        double nY = rY + (x - rX) * sin + (y - rY) * cos;
        return new double[]{nX, nY};
    }

    public static final void rotateCtx(GraphicsContext ctx, double x, double y, double angle) {
        ctx.translate(x, y);
        ctx.rotate(angle);
        ctx.translate(-x, -y);
    }

    public static final Point getPointBetweenP1AndP2(Point p1, Point p2) {
        double[] xy = HelperFX.getPointBetweenP1AndP2(p1.x, p1.y, p2.x, p2.y);
        return new Point(xy[0], xy[1]);
    }

    public static final double[] getPointBetweenP1AndP2(double p1X, double p1Y, double p2X, double p2Y) {
        return new double[]{(p1X + p2X) * 0.5, (p1Y + p2Y) * 0.5};
    }

    public static final <T extends Point> List<T> createConvexHull_OLD(List<T> points) {
        ArrayList<Point> convexHull = new ArrayList<Point>();
        if (points.size() < 3) {
            return new ArrayList<T>(points);
        }
        int minDataPoint = -1;
        int maxDataPoint = -1;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            if (((Point)points.get(i)).getX() < (double)minX) {
                minX = (int)((Point)points.get(i)).getX();
                minDataPoint = i;
            }
            if (!(((Point)points.get(i)).getX() > (double)maxX)) continue;
            maxX = (int)((Point)points.get(i)).getX();
            maxDataPoint = i;
        }
        Point minPoint = (Point)points.get(minDataPoint);
        Point maxPoint = (Point)points.get(maxDataPoint);
        convexHull.add(minPoint);
        convexHull.add(maxPoint);
        points.remove(minPoint);
        points.remove(maxPoint);
        ArrayList<Point> leftSet = new ArrayList<Point>();
        ArrayList<Point> rightSet = new ArrayList<Point>();
        for (int i = 0; i < points.size(); ++i) {
            Point p = (Point)points.get(i);
            if (HelperFX.pointLocation(minPoint, maxPoint, p) == -1) {
                leftSet.add(p);
                continue;
            }
            if (HelperFX.pointLocation(minPoint, maxPoint, p) != 1) continue;
            rightSet.add(p);
        }
        HelperFX.hullSet(minPoint, maxPoint, rightSet, convexHull);
        HelperFX.hullSet(maxPoint, minPoint, leftSet, convexHull);
        convexHull.add(new Point(((Point)convexHull.get(0)).getX(), ((Point)convexHull.get(0)).getY()));
        return convexHull;
    }

    public static final List<Point> createConvexHull(List<Point> points) {
        return QuickHull.quickHull(points);
    }

    public static final List<Point> createSmoothedConvexHull(List<Point> points, int subDivisions) {
        List<Point> hullPolygon = HelperFX.createConvexHull(points);
        return HelperFX.subdividePoints(hullPolygon, subDivisions);
    }

    private static final <T extends Point> double distance(T p1, T p2, T p3) {
        double deltaX = p2.getX() - p1.getX();
        double deltaY = p2.getY() - p1.getY();
        double num = deltaX * (p1.getY() - p3.getY()) - deltaY * (p1.getX() - p3.getX());
        return Math.abs(num);
    }

    private static final <T extends Point> void hullSet(T p1, T p2, List<T> points, List<T> hull) {
        int insertPosition = hull.indexOf(p2);
        if (points.isEmpty()) {
            return;
        }
        if (points.size() == 1) {
            Point point = (Point)points.get(0);
            points.remove(point);
            hull.add(insertPosition, point);
            return;
        }
        int dist = Integer.MIN_VALUE;
        int furthestDataPoint = -1;
        for (int i = 0; i < points.size(); ++i) {
            Point point = (Point)points.get(i);
            double distance = HelperFX.distance(p1, p2, point);
            if (!(distance > (double)dist)) continue;
            dist = (int)distance;
            furthestDataPoint = i;
        }
        Point point = (Point)points.get(furthestDataPoint);
        points.remove(furthestDataPoint);
        hull.add(insertPosition, point);
        ArrayList<Point> leftSetAP = new ArrayList<Point>();
        for (int i = 0; i < points.size(); ++i) {
            Point M = (Point)points.get(i);
            if (HelperFX.pointLocation(p1, point, M) != 1) continue;
            leftSetAP.add(M);
        }
        ArrayList<Point> leftSetPB = new ArrayList<Point>();
        for (int i = 0; i < points.size(); ++i) {
            Point M = (Point)points.get(i);
            if (HelperFX.pointLocation(point, p2, M) != 1) continue;
            leftSetPB.add(M);
        }
        HelperFX.hullSet(p1, point, leftSetAP, hull);
        HelperFX.hullSet(point, p2, leftSetPB, hull);
    }

    private static final <T extends Point> int pointLocation(T p1, T p2, T p3) {
        double cp1 = (p2.getX() - p1.getX()) * (p3.getY() - p1.getY()) - (p2.getY() - p1.getY()) * (p3.getX() - p1.getX());
        return cp1 > 0.0 ? 1 : (Double.compare(cp1, 0.0) == 0 ? 0 : -1);
    }

    public static final List<Point> reduceHull(List<Point> points, List<Point> hullPoints) {
        ArrayList<Point> pointsToCheck = new ArrayList<Point>(points);
        for (int noOfAttempts = 0; noOfAttempts < 1000000 && HelperFX.noOfDiagonalEdges(hullPoints) != 0; ++noOfAttempts) {
            ArrayList<Point> pointsToRemove = new ArrayList<Point>();
            int size = hullPoints.size();
            for (int i = 0; i < size - 1; ++i) {
                Optional<Point> newPoint;
                Point p2;
                Point p1 = hullPoints.get(i);
                if (HelperFX.isHorizontal(p1, p2 = hullPoints.get(i + 1)) || HelperFX.isVertical(p1, p2) || !(newPoint = pointsToCheck.stream().min(Comparator.comparingDouble(p -> HelperFX.distanceFromPointToLine(p, p1, p2)))).isPresent()) continue;
                Point np = newPoint.get();
                hullPoints.add(i + 1, np);
                pointsToRemove.add(np);
            }
            pointsToCheck.removeAll(pointsToRemove);
        }
        return hullPoints;
    }

    public static final List<Point> removePointsOnConvexHull(List<Point> points, List<Point> convexHull) {
        ArrayList<Point> pointsNotOnHullCurve = new ArrayList<Point>(points);
        ArrayList pointsToRemove = new ArrayList();
        int pointsInPolygon = convexHull.size();
        for (int i = 0; i < pointsInPolygon - 1; ++i) {
            Point p1 = convexHull.get(i);
            Point p2 = convexHull.get(i + 1);
            pointsNotOnHullCurve.forEach(p -> {
                if (HelperFX.isPointOnLine(p, p1, p2)) {
                    pointsToRemove.add(p);
                }
            });
        }
        pointsNotOnHullCurve.removeAll(pointsToRemove);
        return pointsNotOnHullCurve;
    }

    public static final int noOfDiagonalEdges(List<Point> polygonPoints) {
        int noOfDiagonalEdges = 0;
        int pointsInPolygon = polygonPoints.size();
        for (int i = 0; i < pointsInPolygon - 1; ++i) {
            Point p2;
            Point p1 = polygonPoints.get(i);
            if (HelperFX.isHorizontal(p1, p2 = polygonPoints.get(i + 1)) || HelperFX.isVertical(p1, p2)) continue;
            ++noOfDiagonalEdges;
        }
        if (!HelperFX.isHorizontal(polygonPoints.get(pointsInPolygon - 1), polygonPoints.get(0)) && !HelperFX.isVertical(polygonPoints.get(pointsInPolygon - 1), polygonPoints.get(0))) {
            ++noOfDiagonalEdges;
        }
        return noOfDiagonalEdges;
    }

    public static final boolean isHorizontal(Point p1, Point p2) {
        return Math.abs(p1.getY() - p2.getY()) < 1.0E-6;
    }

    public static final boolean isVertical(Point p1, Point p2) {
        return Math.abs(p1.getX() - p2.getX()) < 1.0E-6;
    }

    public static final List<Point> getPointsToCheck(List<Point> points, List<Point> hullCurvePoints) {
        ArrayList<Point[]> diagonals = new ArrayList<Point[]>();
        int pointsInPolygon = hullCurvePoints.size();
        for (int i = 0; i < pointsInPolygon - 1; ++i) {
            Point p2;
            Point p1 = hullCurvePoints.get(i);
            if (HelperFX.isHorizontal(p1, p2 = hullCurvePoints.get(i + 1)) || HelperFX.isVertical(p1, p2)) continue;
            diagonals.add(new Point[]{p1, p2});
        }
        ArrayList<Bounds> areas = new ArrayList<Bounds>();
        for (Point[] d : diagonals) {
            double x = Math.min(d[0].x, d[1].x);
            double y = Math.min(d[0].y, d[1].y);
            double w = Math.abs(d[1].x - d[0].x);
            double h = Math.abs(d[1].y - d[0].y);
            areas.add(new Bounds(x, y, w, h));
        }
        ArrayList<Point> pointsToCheck = new ArrayList<Point>();
        for (Point p : points) {
            for (Bounds area : areas) {
                if (!HelperFX.isInRectangle(p.getX(), p.getY(), area.getX(), area.getY(), area.getX() + area.getWidth(), area.getY() + area.getHeight())) continue;
                pointsToCheck.add(p);
            }
        }
        return pointsToCheck;
    }

    public static final List<Point> addPointsOnCurve(List<Point> curvePoints, List<Point> points) {
        ArrayList<Point> result = new ArrayList<Point>();
        ArrayList<Point> polygonPoints = new ArrayList<Point>(curvePoints);
        ArrayList<Point> pointsToCheck = new ArrayList<Point>(points);
        pointsToCheck.removeAll(curvePoints);
        int noOfPointsToCheck = pointsToCheck.size();
        int noOfPointsOnPolygon = polygonPoints.size();
        for (int i = 0; i < noOfPointsOnPolygon - 1; ++i) {
            Point p1 = (Point)polygonPoints.get(i);
            Point p2 = (Point)polygonPoints.get(i + 1);
            if (!result.contains(p1)) {
                result.add(p1);
            }
            for (int j = 0; j < noOfPointsToCheck; ++j) {
                Point p = (Point)pointsToCheck.get(j);
                if (!HelperFX.isPointOnLine(p, p1, p2)) continue;
                result.add(p);
            }
        }
        result.add((Point)polygonPoints.get(noOfPointsOnPolygon - 1));
        return result;
    }

    public static final List<Point> findGaps(List<Point> curvePoints, double width, double height, List<Point> points) {
        ArrayList<Point> startEndPoints = new ArrayList<Point>();
        ArrayList<Point> pointsToCheck = new ArrayList<Point>(points);
        int noOfPointsOnPolygon = curvePoints.size();
        block6: for (int i = 0; i < noOfPointsOnPolygon - 1; ++i) {
            Point p1 = curvePoints.get(i);
            Point p2 = curvePoints.get(i + 1);
            Position pos = Position.UNDEFINED;
            if (HelperFX.isHorizontal(p1, p2)) {
                if (p1.getX() < p2.getX()) {
                    pos = Position.BOTTOM;
                } else if (p1.getX() > p2.getX()) {
                    pos = Position.TOP;
                }
            } else if (HelperFX.isVertical(p1, p2)) {
                if (p1.getY() < p2.getY()) {
                    pos = Position.LEFT;
                } else if (p1.getY() > p2.getY()) {
                    pos = Position.RIGHT;
                }
            }
            switch (pos) {
                case TOP: {
                    if (HelperFX.isInRectangle(p2.getX(), p2.getY(), p1.getX() - width, p1.getY() - height, p1.getX(), p1.getY())) continue block6;
                    startEndPoints.add(p1);
                    startEndPoints.add(p2);
                    double dX = Math.abs(p1.getX() - p2.getX());
                    for (Point p : pointsToCheck) {
                        if (HelperFX.isInRectangle(p.getX(), p.getY(), p1.getX() - width / 2.0, p1.getY() - height, p1.getX(), p1.getY()) && !HelperFX.isVertical(p, p1)) continue;
                    }
                    continue block6;
                }
                case LEFT: {
                    if (HelperFX.isInRectangle(p2.getX(), p2.getY(), p1.getX(), p1.getY(), p1.getX() + width, p1.getY() + height)) continue block6;
                    startEndPoints.add(p1);
                    startEndPoints.add(p2);
                    double dX = Math.abs(p1.getY() - p2.getY());
                    continue block6;
                }
                case BOTTOM: {
                    if (HelperFX.isInRectangle(p2.getX(), p2.getY(), p1.getX(), p1.getY() - height, p1.getX() + width, p1.getY())) continue block6;
                    startEndPoints.add(p1);
                    startEndPoints.add(p2);
                    double dX = Math.abs(p1.getX() - p2.getX());
                    for (Point p : pointsToCheck) {
                        if (HelperFX.isInRectangle(p.getX(), p.getY(), p1.getX() - width / 2.0, p1.getY() - height, p1.getX() + width, p1.getY()) && !HelperFX.isVertical(p, p1)) continue;
                    }
                    continue block6;
                }
                case RIGHT: {
                    if (HelperFX.isInRectangle(p2.getX(), p2.getY(), p1.getX() - width, p1.getY() - height, p1.getX(), p1.getY())) continue block6;
                    startEndPoints.add(p1);
                    startEndPoints.add(p2);
                    double d = Math.abs(p1.getY() - p2.getY());
                }
            }
        }
        return startEndPoints;
    }

    public static final double[] getPointsXFromPoints(List<Point> points) {
        int size = points.size();
        double[] pointsX = new double[size];
        for (int i = 0; i < size; ++i) {
            pointsX[i] = points.get(i).getX();
        }
        return pointsX;
    }

    public static final double[] getPointsYFromPoints(List<Point> points) {
        int size = points.size();
        double[] pointsY = new double[size];
        for (int i = 0; i < size; ++i) {
            pointsY[i] = points.get(i).getY();
        }
        return pointsY;
    }

    public static final double[] getDoubleArrayFromPoints(List<Point> points) {
        int size = points.size();
        double[] pointsArray = new double[size * 2];
        int counter = 0;
        for (int i = 0; i < size; ++i) {
            pointsArray[counter] = points.get(i).getX();
            pointsArray[counter + 1] = points.get(i).getY();
            counter += 2;
        }
        return pointsArray;
    }

    public static final void sortXY(List<Point> points) {
        Collections.sort(points, Comparator.comparingDouble(Point::getX).thenComparingDouble(Point::getY));
    }

    public static final List<Point> sortByDistance(List<Point> points) {
        return HelperFX.sortByDistance(points, true);
    }

    public static final List<Point> sortByDistance(List<Point> points, boolean counterClockWise) {
        if (points.isEmpty()) {
            return points;
        }
        ArrayList<Point> output = new ArrayList<Point>();
        output.add(points.get(HelperFX.nearestPoint(new Point(0.0, 0.0), points)));
        points.remove(output.get(0));
        int x = 0;
        for (int i = 0; i < points.size() + x; ++i) {
            output.add(points.get(HelperFX.nearestPoint((Point)output.get(output.size() - 1), points)));
            points.remove(output.get(output.size() - 1));
            ++x;
        }
        if (counterClockWise) {
            Collections.reverse(output);
        }
        return output;
    }

    public static final int nearestPoint(Point p, List<Point> points) {
        Pair smallestDistance = new Pair((Object)0.0, (Object)0);
        for (int i = 0; i < points.size(); ++i) {
            double distance = HelperFX.distance(p.getX(), p.getY(), points.get(i).getX(), points.get(i).getY());
            if (i == 0) {
                smallestDistance = new Pair((Object)distance, (Object)i);
                continue;
            }
            if (!(distance < (Double)smallestDistance.getA())) continue;
            smallestDistance = new Pair((Object)distance, (Object)i);
        }
        return (Integer)smallestDistance.getB();
    }

    public static final String padLeft(String text, String filler, int n) {
        return String.format("%" + n + "s", text).replace(" ", filler);
    }

    public static final String padRight(String text, String filler, int n) {
        return String.format("%-" + n + "s", text).replace(" ", filler);
    }

    public static final List<Character> splitStringInCharacters(String text) {
        return text.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
    }

    public static final List<Character> splitNumberInDigits(double number) {
        return HelperFX.splitStringInCharacters(Double.toString(number));
    }

    public static final List<Point> removeDuplicatePoints(List<Point> points, double tolerance) {
        double tol = tolerance < 0.0 ? 0.0 : tolerance;
        int size = points.size();
        ArrayList<Point> reducedPoints = new ArrayList<Point>(points);
        HashSet<Point> pointsToRemove = new HashSet<Point>();
        for (int i = 0; i < size - 2; ++i) {
            Point p2;
            Point p1 = points.get(i);
            double distP1P2 = HelperFX.distance(p1, p2 = points.get(i + 1));
            if (!(distP1P2 <= tol)) continue;
            pointsToRemove.add(p2);
        }
        reducedPoints.removeAll(pointsToRemove);
        return reducedPoints;
    }

    public static final List<Point> simplify(List<Point> points, double angleTolerance, double minDistance) {
        double tolerance = angleTolerance < 0.0 ? 0.5 : angleTolerance / 2.0;
        double distance = minDistance < 0.0 ? 1.0 : minDistance;
        int size = points.size();
        if (size <= 4) {
            return points;
        }
        ArrayList<Point> reducedPoints = new ArrayList<Point>(HelperFX.removeDuplicatePoints(points, 1.0));
        HashSet<Point> pointsToRemove = new HashSet<Point>();
        for (int i = 0; i < size - 3; ++i) {
            Point p1 = points.get(i);
            Point p2 = points.get(i + 1);
            Point p3 = points.get(i + 2);
            double bearingP1P2 = HelperFX.bearing(p1.getX(), p1.getY(), p2.getX(), p2.getY());
            double bearingP1P3 = HelperFX.bearing(p1.getX(), p1.getY(), p3.getX(), p3.getY());
            double bearingP2P3 = HelperFX.bearing(p2.getX(), p2.getY(), p3.getX(), p3.getY());
            double deltaBearing = Math.abs(bearingP1P2 - bearingP2P3);
            if (deltaBearing < 0.5) {
                pointsToRemove.add(p2);
                continue;
            }
            if (deltaBearing % 90.0 == 0.0 || deltaBearing > 80.0 && deltaBearing < 90.0) continue;
            if (bearingP1P3 > bearingP1P2 - tolerance && bearingP1P3 < bearingP1P2 + tolerance) {
                pointsToRemove.add(p2);
                continue;
            }
            if (!(HelperFX.distance(p1, p2) < distance)) continue;
            pointsToRemove.add(p2);
        }
        Point lastPoint = points.get(size - 1);
        Point secondLastPoint = points.get(size - 2);
        Point thirdLastPoint = points.get(size - 3);
        Point fourthLastPoint = points.get(size - 4);
        if (HelperFX.removeP2(fourthLastPoint, thirdLastPoint, secondLastPoint, lastPoint, tolerance, distance)) {
            pointsToRemove.add(secondLastPoint);
        }
        reducedPoints.removeAll(pointsToRemove);
        return reducedPoints;
    }

    private static final boolean removeP2(Point p0, Point p1, Point p2, Point p3, double tolerance, double distance) {
        double bearingP1P2 = HelperFX.bearing(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        double bearingP1P3 = HelperFX.bearing(p1.getX(), p1.getY(), p3.getX(), p3.getY());
        double bearingP2P3 = HelperFX.bearing(p2.getX(), p2.getY(), p3.getX(), p3.getY());
        double deltaBearing = Math.abs(bearingP1P2 - bearingP2P3);
        if (deltaBearing < 0.5) {
            return true;
        }
        if (deltaBearing % 90.0 == 0.0) {
            return false;
        }
        if (deltaBearing > 80.0 && deltaBearing < 90.0) {
            return false;
        }
        if (bearingP1P3 > bearingP1P2 - tolerance && bearingP1P3 < bearingP1P2 + tolerance) {
            return true;
        }
        return HelperFX.distance(p1, p2) < distance;
    }

    public static final double bearing(Point p1, Point p2) {
        return HelperFX.bearing(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double bearing(double x1, double y1, double x2, double y2) {
        double bearing = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1)) + 90.0;
        if (bearing < 0.0) {
            bearing += 360.0;
        }
        return bearing;
    }

    public static final String getCardinalDirectionFromBearing(double brng) {
        double bearing = brng % 360.0;
        if (0.0 == bearing || 360.0 == bearing || bearing > CardinalDirection.N.from && bearing < 360.0) {
            return CardinalDirection.N.direction;
        }
        if (90.0 == bearing) {
            return CardinalDirection.E.direction;
        }
        if (180.0 == bearing) {
            return CardinalDirection.S.direction;
        }
        if (270.0 == bearing) {
            return CardinalDirection.W.direction;
        }
        for (CardinalDirection cardinalDirection : CardinalDirection.values()) {
            if (!(bearing >= cardinalDirection.from) || !(bearing <= cardinalDirection.to)) continue;
            return cardinalDirection.direction;
        }
        return "";
    }

    public static final double[] toHSL(Color color) {
        return HelperFX.rgbToHSL(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static final double[] rgbToHSL(double red, double green, double blue) {
        double min = Math.min(red, Math.min(green, blue));
        double max = Math.max(red, Math.max(green, blue));
        double hue = 0.0;
        if (max == min) {
            hue = 0.0;
        } else if (max == red) {
            hue = (60.0 * (green - blue) / (max - min) + 360.0) % 360.0;
        } else if (max == green) {
            hue = 60.0 * (blue - red) / (max - min) + 120.0;
        } else if (max == blue) {
            hue = 60.0 * (red - green) / (max - min) + 240.0;
        }
        double luminance = (max + min) / 2.0;
        double saturation = 0.0;
        saturation = Double.compare(max, min) == 0 ? 0.0 : (luminance <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
        return new double[]{hue, saturation, luminance};
    }

    public static final Color hslToRGB(double hue, double saturation, double luminance) {
        return HelperFX.hslToRGB(hue, saturation, luminance, 1.0);
    }

    public static final Color hslToRGB(double hue, double saturation, double luminance, double opacity) {
        saturation = Helper.clamp((double)0.0, (double)1.0, (double)saturation);
        luminance = Helper.clamp((double)0.0, (double)1.0, (double)luminance);
        opacity = Helper.clamp((double)0.0, (double)1.0, (double)opacity);
        hue %= 360.0;
        double q = luminance < 0.5 ? luminance * (1.0 + saturation) : luminance + saturation - saturation * luminance;
        double p = 2.0 * luminance - q;
        double r = Helper.clamp((double)0.0, (double)1.0, (double)HelperFX.hueToRGB(p, q, (hue /= 360.0) + 0.3333333333333333));
        double g = Helper.clamp((double)0.0, (double)1.0, (double)HelperFX.hueToRGB(p, q, hue));
        double b = Helper.clamp((double)0.0, (double)1.0, (double)HelperFX.hueToRGB(p, q, hue - 0.3333333333333333));
        return Color.color((double)r, (double)g, (double)b, (double)opacity);
    }

    private static final double hueToRGB(double p, double q, double t) {
        if (t < 0.0) {
            t += 1.0;
        }
        if (t > 1.0) {
            t -= 1.0;
        }
        if (6.0 * t < 1.0) {
            return p + (q - p) * 6.0 * t;
        }
        if (2.0 * t < 1.0) {
            return q;
        }
        if (3.0 * t < 2.0) {
            return p + (q - p) * 6.0 * (0.6666666666666666 - t);
        }
        return p;
    }

    public static final String colorToRGB(Color color) {
        String hex = color.toString().replace("0x", "");
        String hexRed = hex.substring(0, 2).toUpperCase();
        String hexGreen = hex.substring(2, 4).toUpperCase();
        String hexBlue = hex.substring(4, 6).toUpperCase();
        String intRed = Integer.toString(Integer.parseInt(hexRed, 16));
        String intGreen = Integer.toString(Integer.parseInt(hexGreen, 16));
        String intBlue = Integer.toString(Integer.parseInt(hexBlue, 16));
        return String.join((CharSequence)"", "colorToRGB(", intRed, ", ", intGreen, ", ", intBlue, ")");
    }

    public static final String colorToRGBA(Color color) {
        return HelperFX.colorToRGBA(color, color.getOpacity());
    }

    public static final String colorToRGBA(Color color, double alpha) {
        String hex = color.toString().replace("0x", "");
        String hexRed = hex.substring(0, 2).toUpperCase();
        String hexGreen = hex.substring(2, 4).toUpperCase();
        String hexBlue = hex.substring(4, 6).toUpperCase();
        String intRed = Integer.toString(Integer.parseInt(hexRed, 16));
        String intGreen = Integer.toString(Integer.parseInt(hexGreen, 16));
        String intBlue = Integer.toString(Integer.parseInt(hexBlue, 16));
        String alph = String.format(Locale.US, "%.3f", Helper.clamp((double)0.0, (double)1.0, (double)alpha));
        return String.join((CharSequence)"", "colorToRGBA(", intRed, ", ", intGreen, ", ", intBlue, ",", alph, ")");
    }

    public static final String colorToWeb(Color color) {
        return color.toString().replace("0x", "#").substring(0, 7);
    }

    public static final String colorToCss(Color color) {
        return color.toString().replace("0x", "#");
    }

    public static final boolean isMonochrome(Color color) {
        return Double.compare(color.getRed(), color.getGreen()) == 0 && Double.compare(color.getGreen(), color.getBlue()) == 0;
    }

    public static final double colorDistance(Color color1, Color color2) {
        double deltaR = color2.getRed() - color1.getRed();
        double deltaG = color2.getGreen() - color1.getGreen();
        double deltaB = color2.getBlue() - color1.getBlue();
        return Math.sqrt(deltaR * deltaR + deltaG * deltaG + deltaB * deltaB);
    }

    public static final double[] colorToYUV(Color color) {
        double weightFactorRed = 0.299;
        double weightFactorGreen = 0.587;
        double weightFactorBlue = 0.144;
        double uMax = 0.436;
        double vMax = 0.615;
        double y = Helper.clamp((double)0.0, (double)1.0, (double)(0.299 * color.getRed() + 0.587 * color.getGreen() + 0.144 * color.getBlue()));
        double u = Helper.clamp((double)-0.436, (double)0.436, (double)(0.436 * ((color.getBlue() - y) / 0.856)));
        double v = Helper.clamp((double)-0.615, (double)0.615, (double)(0.615 * ((color.getRed() - y) / 0.7010000000000001)));
        return new double[]{y, u, v};
    }

    public static final boolean isBright(Color color) {
        return (double)Double.compare(HelperFX.colorToYUV(color)[0], 0.5) >= 0.0;
    }

    public static final boolean isDark(Color color) {
        return HelperFX.colorToYUV(color)[0] < 0.5;
    }

    public static final Color getContrastColor(Color color) {
        return color.getBrightness() > 0.5 ? Color.BLACK : Color.WHITE;
    }

    public static final Color getColorWithOpacity(Color color, double opacity) {
        return Color.color((double)color.getRed(), (double)color.getGreen(), (double)color.getBlue(), (double)Helper.clamp((double)0.0, (double)1.0, (double)opacity));
    }

    public static final List<Color> createColorPalette(Color fromColor, Color toColor, int noOfColors) {
        int steps = Helper.clamp((int)1, (int)12, (int)noOfColors) - 1;
        double step = 1.0 / (double)steps;
        double deltaRed = (toColor.getRed() - fromColor.getRed()) * step;
        double deltaGreen = (toColor.getGreen() - fromColor.getGreen()) * step;
        double deltaBlue = (toColor.getBlue() - fromColor.getBlue()) * step;
        double deltaOpacity = (toColor.getOpacity() - fromColor.getOpacity()) * step;
        ArrayList<Color> palette = new ArrayList<Color>(noOfColors);
        Color currentColor = fromColor;
        palette.add(currentColor);
        for (int i = 0; i < steps; ++i) {
            double red = Helper.clamp((double)0.0, (double)1.0, (double)(currentColor.getRed() + deltaRed));
            double green = Helper.clamp((double)0.0, (double)1.0, (double)(currentColor.getGreen() + deltaGreen));
            double blue = Helper.clamp((double)0.0, (double)1.0, (double)(currentColor.getBlue() + deltaBlue));
            double opacity = Helper.clamp((double)0.0, (double)1.0, (double)(currentColor.getOpacity() + deltaOpacity));
            currentColor = Color.color((double)red, (double)green, (double)blue, (double)opacity);
            palette.add(currentColor);
        }
        return palette;
    }

    public static final Color[] createColorVariations(Color color, int newNoOfColors) {
        int noOfColors = Helper.clamp((int)1, (int)12, (int)newNoOfColors);
        double step = 0.8 / (double)noOfColors;
        double hue = color.getHue();
        double brg = color.getBrightness();
        Color[] colors = new Color[noOfColors];
        for (int i = 0; i < noOfColors; ++i) {
            colors[i] = Color.hsb((double)hue, (double)(0.2 + (double)i * step), (double)brg);
        }
        return colors;
    }

    public static final Color getColorAt(List<Stop> stopList, double positionOfColor) {
        Color COLOR;
        TreeMap<Double, Stop> STOPS = new TreeMap<Double, Stop>();
        for (Stop stop : stopList) {
            STOPS.put(stop.getOffset(), stop);
        }
        if (STOPS.isEmpty()) {
            return Color.BLACK;
        }
        double minFraction = (Double)Collections.min(STOPS.keySet());
        double maxFraction = (Double)Collections.max(STOPS.keySet());
        if (Double.compare(minFraction, 0.0) > 0) {
            STOPS.put(0.0, new Stop(0.0, ((Stop)STOPS.get(minFraction)).getColor()));
        }
        if (Double.compare(maxFraction, 1.0) < 0) {
            STOPS.put(1.0, new Stop(1.0, ((Stop)STOPS.get(maxFraction)).getColor()));
        }
        double POSITION = Helper.clamp((double)0.0, (double)1.0, (double)positionOfColor);
        if (STOPS.size() == 1) {
            Map ONE_ENTRY = (Map)((Object)STOPS.entrySet().iterator().next());
            COLOR = ((Stop)STOPS.get(ONE_ENTRY.keySet().iterator().next())).getColor();
        } else {
            Stop lowerBound = (Stop)STOPS.get(0.0);
            Stop upperBound = (Stop)STOPS.get(1.0);
            for (Double fraction : STOPS.keySet()) {
                if (Double.compare(fraction, POSITION) < 0) {
                    lowerBound = (Stop)STOPS.get(fraction);
                }
                if (Double.compare(fraction, POSITION) <= 0) continue;
                upperBound = (Stop)STOPS.get(fraction);
                break;
            }
            COLOR = HelperFX.interpolateColor(lowerBound, upperBound, POSITION);
        }
        return COLOR;
    }

    public static final Color interpolateColor(Stop lowerBound, Stop upperBound, double position) {
        double POS = (position - lowerBound.getOffset()) / (upperBound.getOffset() - lowerBound.getOffset());
        double DELTA_RED = (upperBound.getColor().getRed() - lowerBound.getColor().getRed()) * POS;
        double DELTA_GREEN = (upperBound.getColor().getGreen() - lowerBound.getColor().getGreen()) * POS;
        double DELTA_BLUE = (upperBound.getColor().getBlue() - lowerBound.getColor().getBlue()) * POS;
        double DELTA_OPACITY = (upperBound.getColor().getOpacity() - lowerBound.getColor().getOpacity()) * POS;
        double red = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getRed() + DELTA_RED));
        double green = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getGreen() + DELTA_GREEN));
        double blue = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getBlue() + DELTA_BLUE));
        double opacity = Helper.clamp((double)0.0, (double)1.0, (double)(lowerBound.getColor().getOpacity() + DELTA_OPACITY));
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }

    public static final Color interpolateColor(Color color1, Color color2, double fraction) {
        return HelperFX.interpolateColor(color1, color2, fraction, -1.0);
    }

    public static final Color getColorAt(LinearGradient gradient, double fraction) {
        return HelperFX.getColorWithOpacityAt(gradient, fraction, 1.0);
    }

    public static final Color getColorWithOpacityAt(LinearGradient gradient, double fraction, double targetOpacity) {
        List stops = gradient.getStops();
        double frac = fraction < 0.0 ? 0.0 : (fraction > 1.0 ? 1.0 : fraction);
        Stop lowerStop = new Stop(0.0, ((Stop)stops.get(0)).getColor());
        Stop upperStop = new Stop(1.0, ((Stop)stops.get(stops.size() - 1)).getColor());
        for (Stop stop : stops) {
            double currentFraction = stop.getOffset();
            if (Double.compare(currentFraction, frac) == 0) {
                return stop.getColor();
            }
            if (Double.compare(currentFraction, frac) < 0) {
                lowerStop = new Stop(currentFraction, stop.getColor());
                continue;
            }
            upperStop = new Stop(currentFraction, stop.getColor());
            break;
        }
        double interpolationFraction = (frac - lowerStop.getOffset()) / (upperStop.getOffset() - lowerStop.getOffset());
        return HelperFX.interpolateColor(lowerStop.getColor(), upperStop.getColor(), interpolationFraction, targetOpacity);
    }

    public static final Color interpolateColor(Color color1, Color color2, double fraction, double targetOpacity) {
        double frac = Helper.clamp((double)0.0, (double)1.0, (double)fraction);
        double targetOpct = targetOpacity < 0.0 ? targetOpacity : Helper.clamp((double)0.0, (double)1.0, (double)fraction);
        double RED1 = color1.getRed();
        double GREEN1 = color1.getGreen();
        double BLUE1 = color1.getBlue();
        double OPACITY1 = color1.getOpacity();
        double RED2 = color2.getRed();
        double GREEN2 = color2.getGreen();
        double BLUE2 = color2.getBlue();
        double OPACITY2 = color2.getOpacity();
        double DELTA_RED = RED2 - RED1;
        double DELTA_GREEN = GREEN2 - GREEN1;
        double DELTA_BLUE = BLUE2 - BLUE1;
        double DELTA_OPACITY = OPACITY2 - OPACITY1;
        double red = RED1 + DELTA_RED * frac;
        double green = GREEN1 + DELTA_GREEN * frac;
        double blue = BLUE1 + DELTA_BLUE * frac;
        double opacity = targetOpct < 0.0 ? OPACITY1 + DELTA_OPACITY * frac : targetOpct;
        red = Helper.clamp((double)0.0, (double)1.0, (double)red);
        green = Helper.clamp((double)0.0, (double)1.0, (double)green);
        blue = Helper.clamp((double)0.0, (double)1.0, (double)blue);
        opacity = Helper.clamp((double)0.0, (double)1.0, (double)opacity);
        return Color.color((double)red, (double)green, (double)blue, (double)opacity);
    }

    public static final void enableNode(Node node, boolean enable) {
        node.setManaged(enable);
        node.setVisible(enable);
    }

    public static final void scaleNodeTo(Node node, double targetWidth, double targetHeight) {
        node.setScaleX(targetWidth / node.getLayoutBounds().getWidth());
        node.setScaleY(targetHeight / node.getLayoutBounds().getHeight());
    }

    public static final Point[] smoothSparkLine(List<Double> dataList, double minValue, double maxValue, javafx.scene.shape.Rectangle graphBounds, int noOfDatapoints) {
        double high;
        int size = dataList.size();
        Point[] points = new Point[size];
        double low = Statistics.getMin(dataList);
        if (Helper.equals((double)low, (double)(high = Statistics.getMax(dataList)))) {
            low = minValue;
            high = maxValue;
        }
        double range = high - low;
        double minX = graphBounds.getX();
        double minY = graphBounds.getY();
        double maxY = minY + graphBounds.getHeight();
        double stepX = graphBounds.getWidth() / (double)(noOfDatapoints - 1);
        double stepY = graphBounds.getHeight() / range;
        for (int i = 0; i < size; ++i) {
            points[i] = new Point(minX + (double)i * stepX, maxY - Math.abs(low - dataList.get(i)) * stepY);
        }
        return HelperFX.subdividePoints(points, 16);
    }

    public static final void drawRoundedRect(GraphicsContext ctx, Bounds bounds, CornerRadii radii) {
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xPlusWidth = x + width;
        double yPlusHeight = y + height;
        ctx.beginPath();
        ctx.moveTo(x + radii.getTopLeft(), y);
        ctx.lineTo(xPlusWidth - radii.getTopRight(), y);
        ctx.quadraticCurveTo(xPlusWidth, y, xPlusWidth, y + radii.getTopRight());
        ctx.lineTo(xPlusWidth, yPlusHeight - radii.getBottomRight());
        ctx.quadraticCurveTo(xPlusWidth, yPlusHeight, xPlusWidth - radii.getBottomRight(), yPlusHeight);
        ctx.lineTo(x + radii.getBottomLeft(), yPlusHeight);
        ctx.quadraticCurveTo(x, yPlusHeight, x, yPlusHeight - radii.getBottomLeft());
        ctx.lineTo(x, y + radii.getTopLeft());
        ctx.quadraticCurveTo(x, y, x + radii.getTopLeft(), y);
        ctx.closePath();
    }

    public static final Point getCubicBezierXYatT(Point startPoint, Point controlPoint1, Point controlPoint2, Point endPoint, double distance) {
        double x = HelperFX.cubicN(distance, startPoint.getX(), controlPoint1.getX(), controlPoint2.getX(), endPoint.getX());
        double y = HelperFX.cubicN(distance, startPoint.getY(), controlPoint1.getY(), controlPoint2.getY(), endPoint.getY());
        return new Point(x, y);
    }

    public static final double[] getCubicBezierXYatT(double startPointX, double startPointY, double controlPoint1X, double controlPoint1Y, double controlPoint2X, double controlPoint2Y, double endPointX, double endPointY, double distance) {
        double x = HelperFX.cubicN(distance, startPointX, controlPoint1X, controlPoint2X, endPointX);
        double y = HelperFX.cubicN(distance, startPointY, controlPoint1Y, controlPoint2Y, endPointY);
        return new double[]{x, y};
    }

    private static final double cubicN(double distance, double a, double b, double c, double d) {
        double t2 = distance * distance;
        double t3 = t2 * distance;
        return a + (-a * 3.0 + distance * (3.0 * a - a * distance)) * distance + (3.0 * b + distance * (-6.0 * b + b * 3.0 * distance)) * distance + (c * 3.0 - c * 3.0 * distance) * t2 + d * t3;
    }

    public static final Path smoothPath(ObservableList<PathElement> elements, boolean filled) {
        if (elements.isEmpty()) {
            return new Path();
        }
        Point[] dataPoints = new Point[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            PathElement element = (PathElement)elements.get(i);
            if (element instanceof MoveTo) {
                MoveTo move = (MoveTo)element;
                dataPoints[i] = new Point(move.getX(), move.getY());
                continue;
            }
            if (!(element instanceof LineTo)) continue;
            LineTo line = (LineTo)element;
            dataPoints[i] = new Point(line.getX(), line.getY());
        }
        double zeroY = ((MoveTo)elements.get(0)).getY();
        ArrayList<Object> smoothedElements = new ArrayList<Object>();
        Pair<Point[], Point[]> result = HelperFX.calcCurveControlPoints(dataPoints);
        Point[] firstControlPoints = (Point[])result.getA();
        Point[] secondControlPoints = (Point[])result.getB();
        if (filled) {
            smoothedElements.add(new MoveTo(dataPoints[0].getX(), zeroY));
            smoothedElements.add(new LineTo(dataPoints[0].getX(), dataPoints[0].getY()));
        } else {
            smoothedElements.add(new MoveTo(dataPoints[0].getX(), dataPoints[0].getY()));
        }
        for (int i = 2; i < dataPoints.length; ++i) {
            int ci = i - 1;
            smoothedElements.add(new CubicCurveTo(firstControlPoints[ci].getX(), firstControlPoints[ci].getY(), secondControlPoints[ci].getX(), secondControlPoints[ci].getY(), dataPoints[i].getX(), dataPoints[i].getY()));
        }
        if (filled) {
            smoothedElements.add(new LineTo(dataPoints[dataPoints.length - 1].getX(), zeroY));
            smoothedElements.add(new ClosePath());
        }
        return new Path(smoothedElements);
    }

    private static final Pair<Point[], Point[]> calcCurveControlPoints(Point[] dataPoints) {
        int n = dataPoints.length - 1;
        if (n == 1) {
            Point[] firstControlPoints = new Point[]{new Point((2.0 * dataPoints[0].getX() + dataPoints[1].getX()) / 3.0, (2.0 * dataPoints[0].getY() + dataPoints[1].getY()) / 3.0)};
            Point[] secondControlPoints = new Point[]{new Point(2.0 * firstControlPoints[0].getX() - dataPoints[0].getX(), 2.0 * firstControlPoints[0].getY() - dataPoints[0].getY())};
            return new Pair((Object)firstControlPoints, (Object)secondControlPoints);
        }
        double[] rhs = new double[n];
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * dataPoints[i].getX() + 2.0 * dataPoints[i + 1].getX();
        }
        rhs[0] = dataPoints[0].getX() + 2.0 * dataPoints[1].getX();
        rhs[n - 1] = (8.0 * dataPoints[n - 1].getX() + dataPoints[n].getX()) / 2.0;
        double[] x = HelperFX.getFirstControlPoints(rhs);
        for (int i = 1; i < n - 1; ++i) {
            rhs[i] = 4.0 * dataPoints[i].getY() + 2.0 * dataPoints[i + 1].getY();
        }
        rhs[0] = dataPoints[0].getY() + 2.0 * dataPoints[1].getY();
        rhs[n - 1] = (8.0 * dataPoints[n - 1].getY() + dataPoints[n].getY()) / 2.0;
        double[] y = HelperFX.getFirstControlPoints(rhs);
        Point[] firstControlPoints = new Point[n];
        Point[] secondControlPoints = new Point[n];
        for (int i = 0; i < n; ++i) {
            firstControlPoints[i] = new Point(x[i], y[i]);
            secondControlPoints[i] = i < n - 1 ? new Point(2.0 * dataPoints[i + 1].getX() - x[i + 1], 2.0 * dataPoints[i + 1].getY() - y[i + 1]) : new Point((dataPoints[n].getX() + x[n - 1]) / 2.0, (dataPoints[n].getY() + y[n - 1]) / 2.0);
        }
        return new Pair((Object)firstControlPoints, (Object)secondControlPoints);
    }

    private static final double[] getFirstControlPoints(double[] rhs) {
        int i;
        int n = rhs.length;
        double[] x = new double[n];
        double[] tmp = new double[n];
        double b = 2.0;
        x[0] = rhs[0] / b;
        for (i = 1; i < n; ++i) {
            tmp[i] = 1.0 / b;
            b = (i < n - 1 ? 4.0 : 3.5) - tmp[i];
            x[i] = (rhs[i] - x[i - 1]) / b;
        }
        for (i = 1; i < n; ++i) {
            int n2 = n - i - 1;
            x[n2] = x[n2] - tmp[n - i] * x[n - i];
        }
        return x;
    }

    public static final boolean isInPolygon(double x, double y, Polygon polygon) {
        ObservableList points = polygon.getPoints();
        int size = points.size();
        int noOfPointsInPolygon = size / 2;
        double[] pointsX = new double[noOfPointsInPolygon];
        double[] pointsY = new double[noOfPointsInPolygon];
        int pointCounter = 0;
        for (int i = 0; i < size - 1; i += 2) {
            pointsX[pointCounter] = (Double)points.get(i);
            pointsY[pointCounter] = (Double)points.get(i + 1);
            ++pointCounter;
        }
        return HelperFX.isInPolygon(x, y, noOfPointsInPolygon, pointsX, pointsY);
    }

    public static final int getDegrees(double decDeg) {
        return (int)decDeg;
    }

    public static final int getMinutes(double decDeg) {
        return (int)((decDeg - (double)HelperFX.getDegrees(decDeg)) * 60.0);
    }

    public static final double getSeconds(double decDeg) {
        return ((decDeg - (double)HelperFX.getDegrees(decDeg)) * 60.0 - (double)HelperFX.getMinutes(decDeg)) * 60.0;
    }

    public static final double getDecimalDeg(int degrees, int minutes, double seconds) {
        return (seconds / 60.0 + (double)minutes) / 60.0 + (double)degrees;
    }

    public static final Node getNodeByColRow(int col, int row, GridPane gridPane) {
        Node result = null;
        ObservableList childrens = gridPane.getChildren();
        for (Node node : childrens) {
            if (GridPane.getRowIndex((Node)node) != row || GridPane.getColumnIndex((Node)node) != col) continue;
            result = node;
            break;
        }
        return result;
    }

    public static final ColorInput createColorMask(Image sourceImage, Color color) {
        return new ColorInput(0.0, 0.0, sourceImage.getWidth(), sourceImage.getHeight(), (Paint)color);
    }

    public static final Blend createColorBlend(Image sourceImage, Color color) {
        ColorInput mask = HelperFX.createColorMask(sourceImage, color);
        Blend blend = new Blend(BlendMode.MULTIPLY);
        blend.setTopInput((Effect)mask);
        return blend;
    }

    public static final WritableImage getRedChannel(Image sourceImage) {
        return HelperFX.getColorChannel(sourceImage, Color.RED);
    }

    public static final WritableImage getGreenChannel(Image sourceImage) {
        return HelperFX.getColorChannel(sourceImage, Color.LIME);
    }

    public static final WritableImage getBlueChannel(Image sourceImage) {
        return HelperFX.getColorChannel(sourceImage, Color.BLUE);
    }

    private static final WritableImage getColorChannel(Image sourceImage, Color color) {
        ImageView imageView = new ImageView(sourceImage);
        Blend blend = HelperFX.createColorBlend(sourceImage, color);
        imageView.setEffect((Effect)blend);
        SnapshotParameters params = new SnapshotParameters();
        return imageView.snapshot(params, null);
    }

    public static final Dimension getTextDimension(String text, Font font) {
        Text t = new Text(text);
        t.setFont(font);
        double textWidth = t.getBoundsInLocal().getWidth();
        double textHeight = t.getBoundsInLocal().getHeight();
        t = null;
        return new Dimension(textWidth, textHeight);
    }

    public static final ZoneOffset getZoneOffset() {
        return HelperFX.getZoneOffset(ZoneId.systemDefault());
    }

    public static final ZoneOffset getZoneOffset(ZoneId zoneId) {
        return zoneId.getRules().getOffset(Instant.now());
    }

    public static final long toMillis(LocalDateTime dateTime, ZoneOffset zoneOffset) {
        return HelperFX.toSeconds(dateTime, zoneOffset) * 1000L;
    }

    public static final long toSeconds(LocalDateTime dateTime, ZoneOffset zoneOffset) {
        return dateTime.toEpochSecond(zoneOffset);
    }

    public static final double toNumericValue(LocalDateTime date) {
        return HelperFX.toNumericValue(date, ZoneId.systemDefault());
    }

    public static final double toNumericValue(LocalDateTime date, ZoneId zoneId) {
        return HelperFX.toSeconds(date, HelperFX.getZoneOffset(zoneId));
    }

    public static final LocalDateTime toRealValue(double value) {
        return HelperFX.secondsToLocalDateTime((long)value);
    }

    public static final LocalDateTime toRealValue(double value, ZoneId zoneId) {
        return HelperFX.secondsToLocalDateTime((long)value, zoneId);
    }

    public static final LocalDateTime secondsToLocalDateTime(long seconds) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneId.systemDefault());
    }

    public static final LocalDateTime secondsToLocalDateTime(long seconds, ZoneId zoneId) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds), zoneId);
    }

    public static final void saveAsPng(Node node, String fileName) {
        SnapshotParameters parameters = new SnapshotParameters();
        parameters.setFill((Paint)Color.TRANSPARENT);
        WritableImage snapshot = node.snapshot(parameters, null);
        String name = fileName.replace("\\.[a-zA-Z]{3,4}", "");
        File file = new File(name + ".png");
        try {
            ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)snapshot, null), "png", file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final Image createNoiseImage(double width, double height, Color darkColor, Color brightColor, double alphaVariationInPercent) {
        if (Double.compare(width, 0.0) <= 0 || Double.compare(height, 0.0) <= 0) {
            return null;
        }
        int w = (int)width;
        int h = (int)height;
        double alphaVariation = Helper.clamp((double)0.0, (double)100.0, (double)alphaVariationInPercent);
        WritableImage image = new WritableImage(w, h);
        PixelWriter pixelWriter = image.getPixelWriter();
        Random rndBlackWhite = new Random();
        Random rndAlpha = new Random();
        double alphaStart = alphaVariation / 100.0 / 2.0;
        double variation = alphaVariation / 100.0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color noiseColor = rndBlackWhite.nextBoolean() ? brightColor : darkColor;
                double noiseAlpha = Helper.clamp((double)0.0, (double)1.0, (double)(alphaStart + rndAlpha.nextDouble() * variation));
                pixelWriter.setColor(x, y, Color.color((double)noiseColor.getRed(), (double)noiseColor.getGreen(), (double)noiseColor.getBlue(), (double)noiseAlpha));
            }
        }
        return image;
    }
}

