/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTConfig;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.vendor.VendorInfo;
import com.helger.pdflayout.IPDDocumentCustomizer;
import com.helger.pdflayout.PDFCreationException;
import com.helger.pdflayout.PLConfig;
import com.helger.pdflayout.base.IPLVisitable;
import com.helger.pdflayout.base.IPLVisitor;
import com.helger.pdflayout.base.PLPageSet;
import com.helger.pdflayout.base.PLPageSetPrepareResult;
import com.helger.pdflayout.render.PreparationContextGlobal;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PageLayoutPDF
implements IPLVisitable {
    public static final boolean DEFAULT_COMPRESS_PDF = true;
    public static final boolean DEFAULT_CREATE_PDF_A = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(PageLayoutPDF.class);
    private String m_sDocumentAuthor;
    private LocalDateTime m_aDocumentCreationDate;
    private String m_sDocumentCreator;
    private String m_sDocumentTitle;
    private String m_sDocumentKeywords;
    private String m_sDocumentSubject;
    private boolean m_bCompressPDF = true;
    private boolean m_bCreatePDF_A = false;
    private final ICommonsList<PLPageSet> m_aPageSets = new CommonsArrayList();
    private IPDDocumentCustomizer m_aDocumentCustomizer;

    public PageLayoutPDF() {
        this.m_sDocumentAuthor = VendorInfo.getVendorName() + " " + VendorInfo.getVendorURLWithoutProtocol();
        this.m_aDocumentCreationDate = PDTFactory.getCurrentLocalDateTime();
        this.m_sDocumentCreator = VendorInfo.getVendorName();
    }

    public final boolean isCompressPDF() {
        return this.m_bCompressPDF;
    }

    @Nonnull
    public final PageLayoutPDF setCompressPDF(boolean bl) {
        this.m_bCompressPDF = bl;
        return this;
    }

    public final boolean isCreatePDF_A() {
        return this.m_bCreatePDF_A;
    }

    @Nonnull
    public final PageLayoutPDF setCreatePDF_A(boolean bl) {
        this.m_bCreatePDF_A = bl;
        return this;
    }

    @Nullable
    public final String getDocumentAuthor() {
        return this.m_sDocumentAuthor;
    }

    @Nonnull
    public final PageLayoutPDF setDocumentAuthor(@Nullable String string) {
        this.m_sDocumentAuthor = string;
        return this;
    }

    @Nullable
    public final LocalDateTime getDocumentCreationDateTime() {
        return this.m_aDocumentCreationDate;
    }

    @Nonnull
    public final PageLayoutPDF setDocumentCreationDateTime(@Nullable LocalDateTime localDateTime) {
        this.m_aDocumentCreationDate = localDateTime;
        return this;
    }

    @Nullable
    public final String getDocumentCreator() {
        return this.m_sDocumentCreator;
    }

    @Nonnull
    public final PageLayoutPDF setDocumentCreator(@Nullable String string) {
        this.m_sDocumentCreator = string;
        return this;
    }

    @Nullable
    public final String getDocumentTitle() {
        return this.m_sDocumentTitle;
    }

    @Nonnull
    public final PageLayoutPDF setDocumentTitle(@Nullable String string) {
        this.m_sDocumentTitle = string;
        return this;
    }

    @Nullable
    public final String getDocumentKeywords() {
        return this.m_sDocumentKeywords;
    }

    @Nonnull
    public final PageLayoutPDF setDocumentKeywords(@Nullable String string) {
        this.m_sDocumentKeywords = string;
        return this;
    }

    @Nullable
    public final String getDocumentSubject() {
        return this.m_sDocumentSubject;
    }

    @Nonnull
    public final PageLayoutPDF setDocumentSubject(@Nullable String string) {
        this.m_sDocumentSubject = string;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends PLPageSet> getAllPageSets() {
        return (ICommonsList)this.m_aPageSets.getClone();
    }

    @Nonnull
    public PageLayoutPDF addPageSet(@Nonnull PLPageSet pLPageSet) {
        ValueEnforcer.notNull((Object)pLPageSet, (String)"PageSet");
        this.m_aPageSets.add((Object)pLPageSet);
        return this;
    }

    @Nonnull
    public EChange removePageSet(@Nullable PLPageSet pLPageSet) {
        return this.m_aPageSets.removeObject((Object)pLPageSet);
    }

    @Nullable
    public final IPDDocumentCustomizer getDocumentCustomizer() {
        return this.m_aDocumentCustomizer;
    }

    @Nonnull
    public final PageLayoutPDF setDocumentCustomizer(@Nullable IPDDocumentCustomizer iPDDocumentCustomizer) {
        this.m_aDocumentCustomizer = iPDDocumentCustomizer;
        return this;
    }

    @Override
    @Nonnull
    public EChange visit(@Nonnull IPLVisitor iPLVisitor) throws IOException {
        EChange eChange = EChange.UNCHANGED;
        for (PLPageSet pLPageSet : this.m_aPageSets) {
            eChange = eChange.or((IChangeIndicator)pLPageSet.visit(iPLVisitor));
        }
        return eChange;
    }

    @Nonnull
    public PageLayoutPDF renderTo(@Nonnull @WillClose OutputStream outputStream) throws PDFCreationException {
        block76: {
            ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
            try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
                PLPageSetPrepareResult pLPageSetPrepareResult;
                Object object;
                Object object2;
                Object object32;
                OutputStream outputStream2;
                PDDocument pDDocument;
                try {
                    pDDocument = new PDDocument();
                    try {
                        outputStream2 = StreamHelper.getBuffered((OutputStream)(this.m_bCreatePDF_A ? nonBlockingByteArrayOutputStream : outputStream));
                        try {
                            int n = 0;
                            for (Object object32 : this.m_aPageSets) {
                                n += object32.getElementCount();
                            }
                            if (n == 0) {
                                throw new PDFCreationException("All page sets are empty!");
                            }
                            object2 = new PDDocumentInformation();
                            if (StringHelper.hasText((String)this.m_sDocumentAuthor)) {
                                object2.setAuthor(this.m_sDocumentAuthor);
                            }
                            if (this.m_aDocumentCreationDate != null) {
                                object2.setCreationDate((Calendar)GregorianCalendar.from(this.m_aDocumentCreationDate.atZone(PDTConfig.getDefaultZoneId())));
                            }
                            if (StringHelper.hasText((String)this.m_sDocumentCreator)) {
                                object2.setCreator(this.m_sDocumentCreator);
                            }
                            if (StringHelper.hasText((String)this.m_sDocumentTitle)) {
                                object2.setTitle(this.m_sDocumentTitle);
                            }
                            if (StringHelper.hasText((String)this.m_sDocumentKeywords)) {
                                object2.setKeywords(this.m_sDocumentKeywords);
                            }
                            if (StringHelper.hasText((String)this.m_sDocumentSubject)) {
                                object2.setSubject(this.m_sDocumentSubject);
                            }
                            object2.setProducer("ph-pdf-layout " + PLConfig.PROJECT_VERSION + " - https://github.com/phax/ph-pdf-layout");
                            pDDocument.setDocumentInformation((PDDocumentInformation)object2);
                            object2 = new PreparationContextGlobal(pDDocument);
                            object32 = new PLPageSetPrepareResult[this.m_aPageSets.size()];
                            int n2 = 0;
                            int n3 = 0;
                            for (PLPageSet pLPageSet : this.m_aPageSets) {
                                object = pLPageSet.prepareAllPages((PreparationContextGlobal)object2);
                                object32[n2] = object;
                                n3 += ((PLPageSetPrepareResult)object).getPageCount();
                                ++n2;
                            }
                            n2 = 0;
                            int n4 = this.m_aPageSets.size();
                            int n5 = 0;
                            for (PLPageSet pLPageSet : this.m_aPageSets) {
                                pLPageSetPrepareResult = object32[n2];
                                pLPageSet.renderAllPages(pLPageSetPrepareResult, pDDocument, this.m_bCompressPDF, n2, n4, n5, n3);
                                n5 += pLPageSetPrepareResult.getPageCount();
                                ++n2;
                            }
                            if (this.m_aDocumentCustomizer != null) {
                                this.m_aDocumentCustomizer.customizeDocument(pDDocument);
                            }
                            pDDocument.save(outputStream2);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("PDF successfully created");
                            }
                        }
                        finally {
                            if (outputStream2 != null) {
                                outputStream2.close();
                            }
                        }
                    }
                    finally {
                        pDDocument.close();
                    }
                }
                catch (IOException iOException) {
                    throw new PDFCreationException("IO Error", iOException);
                }
                catch (Exception exception) {
                    throw new PDFCreationException("Internal error", exception);
                }
                if (!this.m_bCreatePDF_A) break block76;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Start adding PDF/A information");
                }
                try {
                    pDDocument = nonBlockingByteArrayOutputStream.getAsInputStream();
                    try {
                        outputStream2 = PDDocument.load((InputStream)pDDocument);
                        try (OutputStream outputStream3 = StreamHelper.getBuffered((OutputStream)outputStream);){
                            PDMetadata pDMetadata;
                            XmpSerializer xmpSerializer2;
                            Object object4;
                            Object object5;
                            Object object6;
                            PLPageSet pLPageSet;
                            object2 = this.m_aDocumentCreationDate == null ? PDTFactory.createCalendar() : GregorianCalendar.from(this.m_aDocumentCreationDate.atZone(PDTConfig.getDefaultZoneId()));
                            object32 = "ph-pdf-layout " + PLConfig.PROJECT_VERSION;
                            XMPMetadata xMPMetadata = XMPMetadata.createXMPMetadata();
                            AdobePDFSchema adobePDFSchema = xMPMetadata.createAndAddAdobePDFSchema();
                            adobePDFSchema.setProducer((String)object32);
                            XMPBasicSchema xMPBasicSchema = xMPMetadata.createAndAddXMPBasicSchema();
                            xMPBasicSchema.setCreatorTool((String)object32);
                            xMPBasicSchema.setCreateDate((Calendar)object2);
                            xMPBasicSchema.setModifyDate((Calendar)object2);
                            PDDocumentCatalog pDDocumentCatalog = outputStream2.getDocumentCatalog();
                            object = new PDMarkInfo();
                            pLPageSet = new PDStructureTreeRoot();
                            pDDocumentCatalog.setMarkInfo((PDMarkInfo)object);
                            pDDocumentCatalog.setStructureTreeRoot((PDStructureTreeRoot)pLPageSet);
                            pDDocumentCatalog.getMarkInfo().setMarked(true);
                            pLPageSetPrepareResult = outputStream2.getDocumentInformation();
                            pLPageSetPrepareResult.setCreationDate((Calendar)object2);
                            pLPageSetPrepareResult.setModificationDate((Calendar)object2);
                            if (StringHelper.hasText((String)this.m_sDocumentAuthor)) {
                                pLPageSetPrepareResult.setAuthor(this.m_sDocumentAuthor);
                            }
                            pLPageSetPrepareResult.setProducer((String)object32);
                            if (StringHelper.hasText((String)this.m_sDocumentCreator)) {
                                pLPageSetPrepareResult.setCreator(this.m_sDocumentCreator);
                            }
                            if (StringHelper.hasText((String)this.m_sDocumentTitle)) {
                                pLPageSetPrepareResult.setTitle(this.m_sDocumentTitle);
                            }
                            if (StringHelper.hasText((String)this.m_sDocumentSubject)) {
                                pLPageSetPrepareResult.setSubject(this.m_sDocumentSubject);
                            }
                            try {
                                object6 = xMPMetadata.createAndAddDublinCoreSchema();
                                if (StringHelper.hasText((String)this.m_sDocumentTitle)) {
                                    object6.setTitle(this.m_sDocumentTitle);
                                }
                                if (StringHelper.hasText((String)this.m_sDocumentCreator)) {
                                    object6.addCreator(this.m_sDocumentCreator);
                                }
                                if (StringHelper.hasText((String)this.m_sDocumentKeywords)) {
                                    object6.addDescription("", this.m_sDocumentKeywords);
                                }
                                if (StringHelper.hasText((String)this.m_sDocumentSubject)) {
                                    object6.addSubject(this.m_sDocumentSubject);
                                }
                                object6.addDate((Calendar)object2);
                                object5 = xMPMetadata.createAndAddPFAIdentificationSchema();
                                object5.setPart(Integer.valueOf(3));
                                object5.setConformance("A");
                                object4 = new NonBlockingByteArrayOutputStream();
                                try {
                                    xmpSerializer2 = new XmpSerializer();
                                    xmpSerializer2.serialize(xMPMetadata, (OutputStream)object4, true);
                                    pDMetadata = new PDMetadata((PDDocument)outputStream2);
                                    pDMetadata.importXMPMetadata(object4.toByteArray());
                                    pDDocumentCatalog.setMetadata(pDMetadata);
                                }
                                finally {
                                    object4.close();
                                }
                            }
                            catch (BadFieldValueException badFieldValueException) {
                                throw new IllegalArgumentException("Failed to set PDF Metadata", badFieldValueException);
                            }
                            object6 = ICC_Profile.getInstance(1000);
                            object5 = ((ICC_Profile)object6).getData();
                            object4 = new NonBlockingByteArrayInputStream((byte[])object5);
                            try {
                                xmpSerializer2 = new PDOutputIntent((PDDocument)outputStream2, (InputStream)object4);
                                xmpSerializer2.setInfo("sRGB IEC61966-2.1");
                                xmpSerializer2.setOutputCondition("sRGB IEC61966-2.1");
                                xmpSerializer2.setOutputConditionIdentifier("sRGB IEC61966-2.1");
                                xmpSerializer2.setRegistryName("http://www.color.org");
                                pDDocumentCatalog.addOutputIntent((PDOutputIntent)xmpSerializer2);
                                pDDocumentCatalog.setLanguage("de-DE");
                            }
                            finally {
                                object4.close();
                            }
                            for (XmpSerializer xmpSerializer2 : outputStream2.getPages()) {
                                pDMetadata = new PDViewerPreferences(xmpSerializer2.getCOSObject());
                                pDMetadata.setDisplayDocTitle(true);
                                pDDocumentCatalog.setViewerPreferences((PDViewerPreferences)pDMetadata);
                            }
                            outputStream2.save(outputStream3);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("PDF with PDF/A successfully created");
                            }
                        }
                        finally {
                            if (outputStream2 != null) {
                                outputStream2.close();
                            }
                        }
                    }
                    finally {
                        if (pDDocument != null) {
                            pDDocument.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new PDFCreationException("IO Error", iOException);
                }
                catch (Exception exception) {
                    throw new PDFCreationException("Internal error", exception);
                }
            }
        }
        return this;
    }

    @Nonnull
    @Deprecated
    public final PageLayoutPDF renderTo(@Nullable IPDDocumentCustomizer iPDDocumentCustomizer, @Nonnull @WillClose OutputStream outputStream) throws PDFCreationException {
        this.setDocumentCustomizer(iPDDocumentCustomizer);
        return this.renderTo(outputStream);
    }

    @Nonnull
    public PageLayoutPDF renderTo(@Nonnull File file) throws PDFCreationException {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);
        if (fileOutputStream == null) {
            throw new IllegalArgumentException("Failed to open file '" + file.getAbsolutePath() + "' for writing");
        }
        return this.renderTo(fileOutputStream);
    }
}

