/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLRenderableObject;
import com.helger.pdflayout.base.IPLElement;
import com.helger.pdflayout.spec.BorderSpec;
import com.helger.pdflayout.spec.MarginSpec;
import com.helger.pdflayout.spec.PaddingSpec;
import com.helger.pdflayout.spec.SizeSpec;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractPLElement<IMPLTYPE extends AbstractPLElement<IMPLTYPE>>
extends AbstractPLRenderableObject<IMPLTYPE>
implements IPLElement<IMPLTYPE> {
    private SizeSpec m_aMinSize = DEFAULT_MIN_SIZE;
    private SizeSpec m_aMaxSize = DEFAULT_MAX_SIZE;
    private MarginSpec m_aMargin = DEFAULT_MARGIN;
    private BorderSpec m_aBorder = DEFAULT_BORDER;
    private PaddingSpec m_aPadding = DEFAULT_PADDING;
    private Color m_aFillColor = DEFAULT_FILL_COLOR;

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        this.setMargin(((AbstractPLElement)IMPLTYPE).getMargin());
        this.setBorder(((AbstractPLElement)IMPLTYPE).getBorder());
        this.setPadding(((AbstractPLElement)IMPLTYPE).getPadding());
        this.setFillColor(((AbstractPLElement)IMPLTYPE).getFillColor());
        return (IMPLTYPE)((AbstractPLElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final SizeSpec getMinSize() {
        return this.m_aMinSize;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMinSize(@Nonnull SizeSpec sizeSpec) {
        this.m_aMinSize = (SizeSpec)ValueEnforcer.notNull((Object)sizeSpec, (String)"MinSize");
        this.onRenderSizeChange();
        return (IMPLTYPE)((AbstractPLElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final SizeSpec getMaxSize() {
        return this.m_aMaxSize;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMaxSize(@Nonnull SizeSpec sizeSpec) {
        this.m_aMaxSize = (SizeSpec)ValueEnforcer.notNull((Object)sizeSpec, (String)"MaxSize");
        this.onRenderSizeChange();
        return (IMPLTYPE)((AbstractPLElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final MarginSpec getMargin() {
        return this.m_aMargin;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setMargin(@Nonnull MarginSpec marginSpec) {
        ValueEnforcer.notNull((Object)marginSpec, (String)"Mergin");
        this.m_aMargin = marginSpec;
        return (IMPLTYPE)((AbstractPLElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final BorderSpec getBorder() {
        return this.m_aBorder;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setBorder(@Nonnull BorderSpec borderSpec) {
        ValueEnforcer.notNull((Object)borderSpec, (String)"Border");
        this.m_aBorder = borderSpec;
        return (IMPLTYPE)((AbstractPLElement)this.thisAsT());
    }

    @Override
    @Nonnull
    public final PaddingSpec getPadding() {
        return this.m_aPadding;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setPadding(@Nonnull PaddingSpec paddingSpec) {
        ValueEnforcer.notNull((Object)paddingSpec, (String)"Padding");
        this.m_aPadding = paddingSpec;
        return (IMPLTYPE)((AbstractPLElement)this.thisAsT());
    }

    @Override
    @Nullable
    public final Color getFillColor() {
        return this.m_aFillColor;
    }

    @Override
    @Nonnull
    public final IMPLTYPE setFillColor(@Nullable Color color) {
        this.m_aFillColor = color;
        return (IMPLTYPE)((AbstractPLElement)this.thisAsT());
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    protected SizeSpec getRenderSize(@Nonnull SizeSpec sizeSpec) {
        ValueEnforcer.notNull((Object)sizeSpec, (String)"Size");
        float f = Math.max(this.m_aMinSize.getWidth(), sizeSpec.getWidth());
        float f2 = Math.max(this.m_aMinSize.getHeight(), sizeSpec.getHeight());
        f = Math.min(this.m_aMaxSize.getWidth(), f);
        f2 = Math.min(this.m_aMaxSize.getHeight(), f2);
        return new SizeSpec(f, f2);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("MinSize", (Object)this.m_aMinSize).append("MaxSize", (Object)this.m_aMaxSize).append("Margin", (Object)this.m_aMargin).append("Border", (Object)this.m_aBorder).append("Padding", (Object)this.m_aPadding).appendIfNotNull("FillColor", (Object)this.m_aFillColor).getToString();
    }
}

