/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLObject;
import com.helger.pdflayout.base.IPLHasMarginBorderPadding;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.IPLVisitor;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.SizeSpec;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractPLRenderableObject<IMPLTYPE extends AbstractPLRenderableObject<IMPLTYPE>>
extends AbstractPLObject<IMPLTYPE>
implements IPLRenderableObject<IMPLTYPE> {
    private boolean m_bPrepared = false;
    private SizeSpec m_aPrepareAvailableSize;
    private SizeSpec m_aPreparedSize;
    private SizeSpec m_aRenderSize;

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        this.m_aPrepareAvailableSize = ((AbstractPLRenderableObject)IMPLTYPE).getPrepareAvailableSize();
        return (IMPLTYPE)((AbstractPLRenderableObject)this.thisAsT());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @Nonnull
    @OverrideOnDemand
    public EChange visit(@Nonnull IPLVisitor iPLVisitor) throws IOException {
        return iPLVisitor.onElement(this);
    }

    protected final void internalCheckAlreadyPrepared() {
        if (!this.isPrepared()) {
            throw new IllegalStateException(this.getDebugID() + " was not yet prepared: " + this.toString());
        }
    }

    protected final void internalCheckNotPrepared() {
        if (this.isPrepared()) {
            throw new IllegalStateException(this.getDebugID() + " was already prepared and can therefore not be modified: " + this.toString());
        }
    }

    @Override
    public final boolean isPrepared() {
        return this.m_bPrepared;
    }

    @Nullable
    protected final SizeSpec getPrepareAvailableSize() {
        return this.m_aPrepareAvailableSize;
    }

    @Override
    @Nullable
    public final SizeSpec getPreparedSize() {
        return this.m_aPreparedSize;
    }

    @Override
    @Nullable
    public final SizeSpec getRenderSize() {
        return this.m_aRenderSize;
    }

    @Nonnull
    protected abstract SizeSpec onPrepare(@Nonnull PreparationContext var1);

    @Nonnull
    @OverrideOnDemand
    protected SizeSpec getRenderSize(@Nonnull SizeSpec sizeSpec) {
        return sizeSpec;
    }

    private void _setPreparedSize(@Nonnull SizeSpec sizeSpec) {
        ValueEnforcer.notNull((Object)sizeSpec, (String)"PreparedSize");
        this.m_bPrepared = true;
        this.m_aPreparedSize = sizeSpec;
        this.m_aRenderSize = this.getRenderSize(sizeSpec);
        if (PLDebugLog.isDebugPrepare()) {
            Object object = "";
            if (this instanceof IPLHasMarginBorderPadding) {
                object = " with " + PLDebugLog.getXMBP((IPLHasMarginBorderPadding)((Object)this)) + " and " + PLDebugLog.getYMBP((IPLHasMarginBorderPadding)((Object)this));
            }
            PLDebugLog.debugPrepare(this, "Prepared object: " + PLDebugLog.getWH(sizeSpec) + (String)object + "; Render size: " + PLDebugLog.getWH(this.m_aRenderSize));
        }
    }

    protected final void onRenderSizeChange() {
        if (this.m_bPrepared) {
            SizeSpec sizeSpec = this.m_aRenderSize;
            this.m_aRenderSize = this.getRenderSize(this.m_aPreparedSize);
            if (PLDebugLog.isDebugPrepare() && !sizeSpec.equals(this.m_aRenderSize)) {
                PLDebugLog.debugPrepare(this, "RenderSize changed from " + PLDebugLog.getWH(sizeSpec) + " to " + PLDebugLog.getWH(this.m_aRenderSize));
            }
        }
    }

    @Override
    @Nonnull
    public final SizeSpec prepare(@Nonnull PreparationContext preparationContext) {
        Object object;
        this.internalCheckNotPrepared();
        if (PLDebugLog.isDebugPrepare()) {
            object = "";
            if (this instanceof IPLHasMarginBorderPadding) {
                object = " with " + PLDebugLog.getXMBP((IPLHasMarginBorderPadding)((Object)this)) + " and " + PLDebugLog.getYMBP((IPLHasMarginBorderPadding)((Object)this));
            }
            PLDebugLog.debugPrepare(this, "Preparing object for available " + PLDebugLog.getWH(preparationContext.getAvailableWidth(), preparationContext.getAvailableHeight()) + (String)object);
        }
        this.m_aPrepareAvailableSize = new SizeSpec(preparationContext.getAvailableWidth(), preparationContext.getAvailableHeight());
        object = this.onPrepare(preparationContext);
        this._setPreparedSize((SizeSpec)object);
        return this.m_aRenderSize;
    }

    protected abstract void onMarkAsNotPrepared();

    protected final void internalMarkAsNotPreparedDontPropagate() {
        this.internalCheckAlreadyPrepared();
        this.m_bPrepared = false;
        this.m_aPreparedSize = null;
        this.m_aRenderSize = null;
    }

    public final void internalMarkAsNotPrepared() {
        this.internalMarkAsNotPreparedDontPropagate();
        this.onMarkAsNotPrepared();
    }

    @Nonnull
    protected final IMPLTYPE internalMarkAsPrepared(@Nonnull SizeSpec sizeSpec) {
        this.internalCheckNotPrepared();
        this._setPreparedSize(sizeSpec);
        return (IMPLTYPE)((AbstractPLRenderableObject)this.thisAsT());
    }

    @OverrideOnDemand
    protected abstract void onRender(@Nonnull PageRenderContext var1) throws IOException;

    @Override
    @Nonnegative
    public final void render(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        this.internalCheckAlreadyPrepared();
        if (PLDebugLog.isDebugRender()) {
            PLDebugLog.debugRender(this, "Rendering at " + PLDebugLog.getXYWH(pageRenderContext.getStartLeft(), pageRenderContext.getStartTop(), pageRenderContext.getWidth(), pageRenderContext.getHeight()));
        }
        this.onRender(pageRenderContext);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Prepared", this.m_bPrepared).appendIfNotNull("PrepareAvailableSize", (Object)this.m_aPrepareAvailableSize).appendIfNotNull("PreparedSize", (Object)this.m_aPreparedSize).appendIfNotNull("RenderSize", (Object)this.m_aRenderSize).getToString();
    }
}

