/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.base;

import com.helger.commons.traits.IGenericImplTrait;
import com.helger.pdflayout.base.IPLHasOutline;
import com.helger.pdflayout.spec.PaddingSpec;
import javax.annotation.Nonnull;

public interface IPLHasPadding<IMPLTYPE extends IPLHasPadding<IMPLTYPE>>
extends IPLHasOutline,
IGenericImplTrait<IMPLTYPE> {
    public static final PaddingSpec DEFAULT_PADDING = PaddingSpec.PADDING0;

    @Nonnull
    default public IMPLTYPE setPadding(float f) {
        return this.setPadding(f, f);
    }

    @Nonnull
    default public IMPLTYPE setPadding(float f, float f2) {
        return this.setPadding(f, f2, f, f2);
    }

    @Nonnull
    default public IMPLTYPE setPadding(float f, float f2, float f3, float f4) {
        return this.setPadding(new PaddingSpec(f, f2, f3, f4));
    }

    @Nonnull
    public IMPLTYPE setPadding(@Nonnull PaddingSpec var1);

    @Nonnull
    default public IMPLTYPE setPaddingTop(float f) {
        return this.setPadding(this.getPadding().getCloneWithTop(f));
    }

    @Nonnull
    default public IMPLTYPE setPaddingRight(float f) {
        return this.setPadding(this.getPadding().getCloneWithRight(f));
    }

    @Nonnull
    default public IMPLTYPE setPaddingBottom(float f) {
        return this.setPadding(this.getPadding().getCloneWithBottom(f));
    }

    @Nonnull
    default public IMPLTYPE setPaddingLeft(float f) {
        return this.setPadding(this.getPadding().getCloneWithLeft(f));
    }

    @Nonnull
    default public IMPLTYPE setPaddingX(float f) {
        return this.setPaddingLeft(f).setPaddingRight(f);
    }

    @Nonnull
    default public IMPLTYPE setPaddingY(float f) {
        return this.setPaddingTop(f).setPaddingBottom(f);
    }

    @Nonnull
    default public IMPLTYPE addPaddingTop(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasPadding)this.thisAsT());
        }
        return this.setPaddingTop(this.getPaddingTop() + f);
    }

    @Nonnull
    default public IMPLTYPE addPaddingRight(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasPadding)this.thisAsT());
        }
        return this.setPaddingRight(this.getPaddingRight() + f);
    }

    @Nonnull
    default public IMPLTYPE addPaddingBottom(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasPadding)this.thisAsT());
        }
        return this.setPaddingBottom(this.getPaddingBottom() + f);
    }

    @Nonnull
    default public IMPLTYPE addPaddingLeft(float f) {
        if (f == 0.0f) {
            return (IMPLTYPE)((IPLHasPadding)this.thisAsT());
        }
        return this.setPaddingLeft(this.getPaddingLeft() + f);
    }

    @Nonnull
    default public IMPLTYPE addPaddingX(float f) {
        return this.addPaddingLeft(f).addPaddingRight(f);
    }

    @Nonnull
    default public IMPLTYPE addPaddingY(float f) {
        return this.addPaddingTop(f).addPaddingBottom(f);
    }

    @Nonnull
    public PaddingSpec getPadding();

    default public float getPaddingTop() {
        return this.getPadding().getTop();
    }

    default public float getPaddingRight() {
        return this.getPadding().getRight();
    }

    default public float getPaddingBottom() {
        return this.getPadding().getBottom();
    }

    default public float getPaddingLeft() {
        return this.getPadding().getLeft();
    }

    default public float getPaddingXSum() {
        return this.getPadding().getXSum();
    }

    default public float getPaddingYSum() {
        return this.getPadding().getYSum();
    }

    @Override
    default public float getOutlineTop() {
        return this.getPaddingTop();
    }

    @Override
    default public float getOutlineRight() {
        return this.getPaddingRight();
    }

    @Override
    default public float getOutlineBottom() {
        return this.getPaddingBottom();
    }

    @Override
    default public float getOutlineLeft() {
        return this.getPaddingLeft();
    }

    @Override
    default public float getOutlineXSum() {
        return this.getPaddingXSum();
    }

    @Override
    default public float getOutlineYSum() {
        return this.getPaddingYSum();
    }
}

