/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.box;

import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.AbstractPLBlockElement;
import com.helger.pdflayout.base.AbstractPLRenderableObject;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.base.IPLSplittableObject;
import com.helger.pdflayout.base.IPLVisitor;
import com.helger.pdflayout.base.PLElementWithSize;
import com.helger.pdflayout.base.PLSplitResult;
import com.helger.pdflayout.debug.PLDebugLog;
import com.helger.pdflayout.render.PLRenderHelper;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.SizeSpec;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractPLBox<IMPLTYPE extends AbstractPLBox<IMPLTYPE>>
extends AbstractPLBlockElement<IMPLTYPE>
implements IPLSplittableObject<IMPLTYPE, IMPLTYPE> {
    private IPLRenderableObject<?> m_aElement;
    private boolean m_bVertSplittable = true;
    private SizeSpec m_aElementPreparedSize;
    private SizeSpec m_aRenderOffset = SizeSpec.SIZE0;

    public AbstractPLBox(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        this.setElement(iPLRenderableObject);
    }

    @Override
    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public IMPLTYPE setBasicDataFrom(@Nonnull IMPLTYPE IMPLTYPE) {
        super.setBasicDataFrom(IMPLTYPE);
        this.setVertSplittable(((AbstractPLBox)IMPLTYPE).isVertSplittable());
        return (IMPLTYPE)((AbstractPLBox)this.thisAsT());
    }

    @Nullable
    public final IPLRenderableObject<?> getElement() {
        return this.m_aElement;
    }

    public final boolean hasElement() {
        return this.m_aElement != null;
    }

    @Nonnull
    public final IMPLTYPE setElement(@Nullable IPLRenderableObject<?> iPLRenderableObject) {
        this.internalCheckNotPrepared();
        this.m_aElement = iPLRenderableObject;
        return (IMPLTYPE)((AbstractPLBox)this.thisAsT());
    }

    @Override
    public final boolean isVertSplittable() {
        if (!this.m_bVertSplittable) {
            return false;
        }
        return this.hasElement() && this.getElement().isVertSplittable();
    }

    @Override
    @Nonnull
    public final IMPLTYPE setVertSplittable(boolean bl) {
        this.m_bVertSplittable = bl;
        return (IMPLTYPE)((AbstractPLBox)this.thisAsT());
    }

    @Override
    @Nonnull
    public EChange visit(@Nonnull IPLVisitor iPLVisitor) throws IOException {
        EChange eChange = super.visit(iPLVisitor);
        if (this.m_aElement != null && this.m_aElement.visit(iPLVisitor).isChanged()) {
            eChange = EChange.CHANGED;
            SizeSpec sizeSpec = this.m_aElement.getPreparedSize();
            this.internalMarkAsNotPreparedDontPropagate();
            this.internalSetElementPreparedSize(sizeSpec);
            this.internalMarkAsPrepared(sizeSpec.plus(this.m_aElement.getOutlineXSum(), this.m_aElement.getOutlineYSum()));
        }
        return eChange;
    }

    @Nullable
    protected final SizeSpec getElementPreparedSize() {
        return this.m_aElementPreparedSize;
    }

    protected final void internalSetElementPreparedSize(@Nullable SizeSpec sizeSpec) {
        this.m_aElementPreparedSize = sizeSpec;
    }

    @Override
    @Nonnull
    protected SizeSpec getRenderSize(@Nonnull SizeSpec sizeSpec) {
        SizeSpec sizeSpec2 = super.getRenderSize(sizeSpec);
        if (this.isFullWidth()) {
            sizeSpec2 = sizeSpec2.withWidth(this.getPrepareAvailableSize().getWidth() - this.getOutlineXSum());
        }
        this.m_aRenderOffset = new SizeSpec(this.getIndentX(sizeSpec2.getWidth(), sizeSpec.getWidth()), this.getIndentY(sizeSpec2.getHeight(), sizeSpec.getHeight()));
        return sizeSpec2;
    }

    @Override
    protected SizeSpec onPrepare(@Nonnull PreparationContext preparationContext) {
        if (this.m_aElement == null) {
            return SizeSpec.SIZE0;
        }
        float f = preparationContext.getAvailableWidth() - this.getOutlineXSum();
        float f2 = preparationContext.getAvailableHeight() - this.getOutlineYSum();
        PreparationContext preparationContext2 = new PreparationContext(preparationContext.getGlobalContext(), f, f2);
        this.internalSetElementPreparedSize(this.m_aElement.prepare(preparationContext2));
        return new SizeSpec(this.m_aElementPreparedSize.getWidth() + this.m_aElement.getOutlineXSum(), this.m_aElementPreparedSize.getHeight() + this.m_aElement.getOutlineYSum());
    }

    @Override
    protected void onMarkAsNotPrepared() {
        this.internalSetElementPreparedSize(null);
        if (this.m_aElement instanceof AbstractPLRenderableObject) {
            ((AbstractPLRenderableObject)this.m_aElement).internalMarkAsNotPrepared();
        }
    }

    @Override
    @Nullable
    public PLSplitResult splitElementVert(float f, float f2) {
        PLSplitResult pLSplitResult;
        if (f2 <= 0.0f) {
            return null;
        }
        float f3 = this.getPreparedHeight();
        if (f3 <= f2) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Splitting makes no sense, because Box 2 would be empty");
            }
            return null;
        }
        IPLRenderableObject<?> iPLRenderableObject = this.getElement();
        IPLSplittableObject iPLSplittableObject = ((AbstractPLBox)((AbstractPLBox)this.internalCreateNewVertSplitObject((AbstractPLBox)this.thisAsT())).setID(this.getID() + "-1")).setVertSplittable(false);
        IPLSplittableObject iPLSplittableObject2 = ((AbstractPLBox)((AbstractPLBox)this.internalCreateNewVertSplitObject((AbstractPLBox)this.thisAsT())).setID(this.getID() + "-2")).setVertSplittable(true);
        iPLSplittableObject.setMinWidth(this.getMinWidth());
        iPLSplittableObject.setMaxWidth(this.getMaxWidth());
        iPLSplittableObject2.setMinWidth(this.getMinWidth());
        iPLSplittableObject2.setMaxWidth(this.getMaxWidth());
        float f4 = 0.0f;
        float f5 = 0.0f;
        SizeSpec sizeSpec = null;
        SizeSpec sizeSpec2 = null;
        float f6 = this.getElementPreparedSize().getWidth();
        float f7 = f2 - iPLRenderableObject.getOutlineYSum();
        if (PLDebugLog.isDebugSplit()) {
            PLDebugLog.debugSplit(this, "Trying to split " + iPLRenderableObject.getDebugID() + " into pieces for split size " + PLDebugLog.getWH(f6, f7));
        }
        if ((pLSplitResult = iPLRenderableObject.getAsSplittable().splitElementVert(f6, f7)) == null) {
            if (PLDebugLog.isDebugSplit()) {
                PLDebugLog.debugSplit(this, "Splitting makes no sense, because Box 2 would be empty");
            }
            return null;
        }
        IPLRenderableObject<?> iPLRenderableObject2 = pLSplitResult.getFirstElement().getElement();
        ((AbstractPLBox)iPLSplittableObject).setElement(iPLRenderableObject2);
        f4 += pLSplitResult.getFirstElement().getHeightFull();
        sizeSpec = pLSplitResult.getFirstElement().getSize();
        IPLRenderableObject<?> iPLRenderableObject3 = pLSplitResult.getSecondElement().getElement();
        ((AbstractPLBox)iPLSplittableObject2).setElement(iPLRenderableObject3);
        f5 += pLSplitResult.getSecondElement().getHeightFull();
        sizeSpec2 = pLSplitResult.getSecondElement().getSize();
        if (PLDebugLog.isDebugSplit()) {
            PLDebugLog.debugSplit(this, "Split box element " + iPLRenderableObject.getDebugID() + " into pieces: " + iPLRenderableObject2.getDebugID() + " (" + pLSplitResult.getFirstElement().getWidth() + "+" + iPLRenderableObject2.getOutlineXSum() + " & " + pLSplitResult.getFirstElement().getHeight() + "+" + iPLRenderableObject2.getOutlineYSum() + ") and " + iPLRenderableObject3.getDebugID() + " (" + pLSplitResult.getSecondElement().getWidth() + "+" + iPLRenderableObject3.getOutlineXSum() + " & " + pLSplitResult.getSecondElement().getHeight() + "+" + iPLRenderableObject3.getOutlineYSum() + ")");
        }
        ((AbstractPLRenderableObject)((Object)iPLSplittableObject)).internalMarkAsPrepared(new SizeSpec(f, f4));
        ((AbstractPLBox)iPLSplittableObject).internalSetElementPreparedSize(sizeSpec);
        ((AbstractPLRenderableObject)((Object)iPLSplittableObject2)).internalMarkAsPrepared(new SizeSpec(f, f5));
        ((AbstractPLBox)iPLSplittableObject2).internalSetElementPreparedSize(sizeSpec2);
        return new PLSplitResult(new PLElementWithSize((IPLRenderableObject<?>)((Object)iPLSplittableObject), new SizeSpec(f, f4)), new PLElementWithSize((IPLRenderableObject<?>)((Object)iPLSplittableObject2), new SizeSpec(f, f5)));
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        PLRenderHelper.fillAndRenderBorder((AbstractPLBox)this.thisAsT(), pageRenderContext, 0.0f, 0.0f);
        if (this.m_aElement != null) {
            float f = pageRenderContext.getStartLeft() + this.getOutlineLeft() + this.m_aRenderOffset.getWidth();
            float f2 = pageRenderContext.getStartTop() - this.getOutlineTop() - this.m_aRenderOffset.getHeight();
            PageRenderContext pageRenderContext2 = new PageRenderContext(pageRenderContext, f, f2, this.getRenderWidth(), this.getRenderHeight());
            this.m_aElement.render(pageRenderContext2);
        } else {
            PLDebugLog.debugRender(this, "Not rendering the box, because no element is contained");
        }
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("Element", this.m_aElement).append("VertSplittable", this.m_bVertSplittable).appendIfNotNull("ElementPreparedSize", (Object)this.m_aElementPreparedSize).appendIfNotNull("RenderOffset", (Object)this.m_aRenderOffset).getToString();
    }
}

