/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.list;

import com.helger.commons.ValueEnforcer;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.element.list.AbstractBulletPointCreatorFontBased;
import com.helger.pdflayout.element.text.PLText;
import com.helger.pdflayout.spec.FontSpec;
import java.util.function.IntFunction;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class BulletPointCreatorNumeric
extends AbstractBulletPointCreatorFontBased<BulletPointCreatorNumeric> {
    private final IntFunction<String> m_aFormatter;

    public BulletPointCreatorNumeric(@Nonnull IntFunction<String> intFunction, @Nonnull FontSpec fontSpec) {
        super(fontSpec);
        ValueEnforcer.notNull(intFunction, (String)"Formatter");
        this.m_aFormatter = intFunction;
    }

    @Nonnull
    public final IntFunction<String> getFormatter() {
        return this.m_aFormatter;
    }

    @Nonnull
    public String getBulletPointText(@Nonnegative int n) {
        return this.m_aFormatter.apply(n);
    }

    @Override
    @Nonnull
    public IPLRenderableObject<?> getBulletPointElement(@Nonnegative int n) {
        return ((PLText)new PLText(this.getBulletPointText(n), this.getFontSpec()).setVertSplittable(false)).setPadding(this.getPadding());
    }
}

