/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.table;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.pdflayout.element.table.IPLTableGridType;
import com.helger.pdflayout.element.table.PLTable;
import com.helger.pdflayout.spec.BorderStyleSpec;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EPLTableGridType implements IPLTableGridType
{
    NONE("none"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, pLTableRow -> pLTableRow.forEachCell((pLTableCell, n, n2, n3) -> pLTableCell.setBorder(null, null, null, null)));
        }
    }
    ,
    FULL("full"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n5, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n4) -> pLTableRow.forEachCell((pLTableCell, n5, n6, n7) -> {
                if (n6 >= n3 && n6 <= n5) {
                    if (n4 == n) {
                        if (n6 == n3) {
                            pLTableCell.setBorder(borderStyleSpec, borderStyleSpec, borderStyleSpec, borderStyleSpec);
                        } else {
                            pLTableCell.setBorder(borderStyleSpec, borderStyleSpec, borderStyleSpec, null);
                        }
                    } else if (n6 == n3) {
                        pLTableCell.setBorder(null, borderStyleSpec, borderStyleSpec, borderStyleSpec);
                    } else {
                        pLTableCell.setBorder(null, borderStyleSpec, borderStyleSpec, null);
                    }
                }
            }));
        }
    }
    ,
    FULL_NO_BORDER("full_no_border"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n5, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n4) -> pLTableRow.forEachCell((pLTableCell, n5, n6, n7) -> {
                if (n6 >= n3 && n6 <= n5) {
                    boolean bl = n4 == n;
                    boolean bl2 = n6 == n3;
                    pLTableCell.setBorder(bl ? null : borderStyleSpec, null, null, bl2 ? null : borderStyleSpec);
                }
            }));
        }
    }
    ,
    OUTER("outer"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n5) -> pLTableRow.forEachCell((pLTableCell, n6, n7, n8) -> {
                if (n7 >= n3 && n7 <= n4) {
                    boolean bl = n5 == n;
                    boolean bl2 = n5 == n2;
                    boolean bl3 = n7 == n3;
                    boolean bl4 = n8 - 1 == n4;
                    pLTableCell.setBorder(bl ? borderStyleSpec : null, bl4 ? borderStyleSpec : null, bl2 ? borderStyleSpec : null, bl3 ? borderStyleSpec : null);
                }
            }));
        }
    }
    ,
    HORZ_ALL("horz_all"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n5, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n4) -> pLTableRow.forEachCell((pLTableCell, n5, n6, n7) -> {
                if (n6 >= n3 && n6 <= n5) {
                    boolean bl = n4 == n;
                    pLTableCell.setBorder(bl ? borderStyleSpec : null, null, borderStyleSpec, null);
                }
            }));
        }
    }
    ,
    HORZ_OUTER_BORDER("horz_outer_border"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n5, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n4) -> pLTableRow.forEachCell((pLTableCell, n5, n6, n7) -> {
                if (n6 >= n3 && n6 <= n5) {
                    boolean bl = n4 == n;
                    boolean bl2 = n6 == n3;
                    boolean bl3 = n7 - 1 == n5;
                    pLTableCell.setBorder(bl ? borderStyleSpec : null, bl3 ? borderStyleSpec : null, borderStyleSpec, bl2 ? borderStyleSpec : null);
                }
            }));
        }
    }
    ,
    HORZ_NO_BORDER("horz_no_border"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n5, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n4) -> pLTableRow.forEachCell((pLTableCell, n5, n6, n7) -> {
                if (n6 >= n3 && n6 <= n5) {
                    boolean bl = n4 == n2;
                    pLTableCell.setBorder(null, null, bl ? null : borderStyleSpec, null);
                }
            }));
        }
    }
    ,
    VERT_ALL("vert_all"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n6) -> pLTableRow.forEachCell((pLTableCell, n3, n4, n5) -> {
                if (n4 >= n3 && n4 <= n4) {
                    boolean bl = n4 == n3;
                    pLTableCell.setBorder(null, borderStyleSpec, null, bl ? borderStyleSpec : null);
                }
            }));
        }
    }
    ,
    VERT_OUTER_BORDER("vert_outer_border"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n5) -> pLTableRow.forEachCell((pLTableCell, n6, n7, n8) -> {
                if (n7 >= n3 && n7 <= n4) {
                    boolean bl = n5 == n;
                    boolean bl2 = n5 == n2;
                    boolean bl3 = n7 == n3;
                    pLTableCell.setBorder(bl ? borderStyleSpec : null, borderStyleSpec, bl2 ? borderStyleSpec : null, bl3 ? borderStyleSpec : null);
                }
            }));
        }
    }
    ,
    VERT_NO_BORDER("vert_no_border"){

        @Override
        public void applyGridToTable(@Nonnull PLTable pLTable, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnull BorderStyleSpec borderStyleSpec) {
            ValueEnforcer.notNull((Object)pLTable, (String)"Table");
            ValueEnforcer.notNull((Object)borderStyleSpec, (String)"BorderStyleSpec");
            pLTable.forEachRow(n, n2, (pLTableRow, n6) -> pLTableRow.forEachCell((pLTableCell, n3, n4, n5) -> {
                if (n4 >= n3 && n4 <= n4) {
                    boolean bl = n5 - 1 == n4;
                    pLTableCell.setBorder(null, bl ? null : borderStyleSpec, null, null);
                }
            }));
        }
    };

    private final String m_sID;

    private EPLTableGridType(String string2) {
        this.m_sID = string2;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    public static EPLTableGridType getFromIDOrNull(@Nullable String string) {
        return (EPLTableGridType)EnumHelper.getFromIDOrNull(EPLTableGridType.class, (Object)string);
    }
}

