/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.element.table;

import com.helger.commons.mutable.MutableInt;
import com.helger.pdflayout.base.IPLRenderableObject;
import com.helger.pdflayout.element.hbox.AbstractPLHBox;
import com.helger.pdflayout.element.hbox.PLHBoxColumn;
import com.helger.pdflayout.element.table.IPLTableCellConsumer;
import com.helger.pdflayout.element.table.IPLTableCellFilter;
import com.helger.pdflayout.element.table.PLTableCell;
import com.helger.pdflayout.render.PageRenderContext;
import com.helger.pdflayout.render.PreparationContext;
import com.helger.pdflayout.spec.BorderStyleSpec;
import com.helger.pdflayout.spec.MarginSpec;
import com.helger.pdflayout.spec.PaddingSpec;
import com.helger.pdflayout.spec.WidthSpec;
import java.awt.Color;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PLTableRow
extends AbstractPLHBox<PLTableRow> {
    @Nonnull
    protected PLTableCell internalCreateVertSplitEmptyElement(@Nonnull IPLRenderableObject<?> iPLRenderableObject, float f, float f2) {
        PLTableCell pLTableCell = new PLTableCell(null);
        pLTableCell.setBasicDataFrom((PLTableCell)iPLRenderableObject);
        pLTableCell.prepare(new PreparationContext(null, f, f2));
        return pLTableCell;
    }

    @Override
    @Nonnull
    public PLTableRow internalCreateNewVertSplitObject(@Nonnull PLTableRow pLTableRow) {
        PLTableRow pLTableRow2 = new PLTableRow();
        pLTableRow2.setBasicDataFrom(pLTableRow);
        return pLTableRow2;
    }

    @Override
    protected void onRender(@Nonnull PageRenderContext pageRenderContext) throws IOException {
        super.onRender(pageRenderContext);
    }

    public void addCell(@Nonnull PLTableCell pLTableCell, @Nonnull WidthSpec widthSpec) {
        this.addColumn(pLTableCell, widthSpec);
    }

    @Nullable
    public PLTableCell getCellAtIndex(int n) {
        PLHBoxColumn pLHBoxColumn = this.getColumnAtIndex(n);
        return pLHBoxColumn == null ? null : (PLTableCell)pLHBoxColumn.getElement();
    }

    @Nullable
    public PLTableCell getFirstCell() {
        return this.getCellAtIndex(0);
    }

    @Nullable
    public PLTableCell getLastCell() {
        return this.getCellAtIndex(this.getColumnCount() - 1);
    }

    public void forEachCell(@Nonnull Consumer<? super PLTableCell> consumer) {
        this.forEachColumn(pLHBoxColumn -> consumer.accept((PLTableCell)pLHBoxColumn.getElement()));
    }

    public void forEachCell(@Nonnull ObjIntConsumer<? super PLTableCell> objIntConsumer) {
        this.forEachColumnByIndex((pLHBoxColumn, n) -> objIntConsumer.accept((PLTableCell)pLHBoxColumn.getElement(), n));
    }

    public void forEachCell(@Nonnull IPLTableCellConsumer iPLTableCellConsumer) {
        MutableInt mutableInt = new MutableInt(0);
        this.forEachColumnByIndex((pLHBoxColumn, n) -> {
            PLTableCell pLTableCell = (PLTableCell)pLHBoxColumn.getElement();
            int n2 = pLTableCell.getColSpan();
            iPLTableCellConsumer.accept(pLTableCell, n, mutableInt.intValue(), mutableInt.intValue() + n2);
            mutableInt.inc(n2);
        });
    }

    public void forEachCell(int n, int n2, @Nonnull Consumer<? super PLTableCell> consumer) {
        this.forEachCell((? super PLTableCell pLTableCell, int n3) -> {
            if (n3 >= n && n3 <= n2) {
                consumer.accept((PLTableCell)pLTableCell);
            }
        });
    }

    public void forEachCell(int n, int n2, @Nonnull ObjIntConsumer<? super PLTableCell> objIntConsumer) {
        this.forEachCell((? super PLTableCell pLTableCell, int n3) -> {
            if (n3 >= n && n3 <= n2) {
                objIntConsumer.accept((PLTableCell)pLTableCell, n3);
            }
        });
    }

    public void forEachCell(@Nonnull IPLTableCellFilter iPLTableCellFilter, @Nonnull IPLTableCellConsumer iPLTableCellConsumer) {
        this.forEachCell((PLTableCell pLTableCell, int n, int n2, int n3) -> {
            if (iPLTableCellFilter.test(pLTableCell, n, n2, n3)) {
                iPLTableCellConsumer.accept(pLTableCell, n, n2, n3);
            }
        });
    }

    @Nonnull
    public PLTableRow setFillColor(@Nullable Color color) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setFillColor(color));
        return this;
    }

    @Nonnull
    public PLTableRow setBorder(@Nullable BorderStyleSpec borderStyleSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setBorder(borderStyleSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setBorderTop(@Nullable BorderStyleSpec borderStyleSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setBorderTop(borderStyleSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setBorderRight(@Nullable BorderStyleSpec borderStyleSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setBorderRight(borderStyleSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setBorderBottom(@Nullable BorderStyleSpec borderStyleSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setBorderBottom(borderStyleSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setBorderLeft(@Nullable BorderStyleSpec borderStyleSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setBorderLeft(borderStyleSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setBorderX(@Nullable BorderStyleSpec borderStyleSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setBorderX(borderStyleSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setBorderY(@Nullable BorderStyleSpec borderStyleSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setBorderY(borderStyleSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setMargin(@Nonnull MarginSpec marginSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMargin(marginSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setMargin(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMargin(f));
        return this;
    }

    @Nonnull
    public PLTableRow setMarginTop(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMarginTop(f));
        return this;
    }

    @Nonnull
    public PLTableRow setMarginRight(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMarginRight(f));
        return this;
    }

    @Nonnull
    public PLTableRow setMarginBottom(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMarginBottom(f));
        return this;
    }

    @Nonnull
    public PLTableRow setMarginLeft(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMarginLeft(f));
        return this;
    }

    @Nonnull
    public PLTableRow setMarginX(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMarginX(f));
        return this;
    }

    @Nonnull
    public PLTableRow setMarginY(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setMarginY(f));
        return this;
    }

    @Nonnull
    public PLTableRow setPadding(@Nonnull PaddingSpec paddingSpec) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPadding(paddingSpec));
        return this;
    }

    @Nonnull
    public PLTableRow setPadding(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPadding(f));
        return this;
    }

    @Nonnull
    public PLTableRow setPaddingTop(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPaddingTop(f));
        return this;
    }

    @Nonnull
    public PLTableRow setPaddingRight(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPaddingRight(f));
        return this;
    }

    @Nonnull
    public PLTableRow setPaddingBottom(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPaddingBottom(f));
        return this;
    }

    @Nonnull
    public PLTableRow setPaddingLeft(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPaddingLeft(f));
        return this;
    }

    @Nonnull
    public PLTableRow setPaddingX(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPaddingX(f));
        return this;
    }

    @Nonnull
    public PLTableRow setPaddingY(float f) {
        this.forEachCell((? super PLTableCell pLTableCell) -> pLTableCell.setPaddingY(f));
        return this;
    }
}

