/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.render;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.string.StringParser;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.base.EPLPlaceholder;
import com.helger.pdflayout.base.PLPageSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

@Immutable
public class PagePreRenderContext {
    private final PLPageSet m_aPageSet;
    private final PDDocument m_aDoc;
    private final PDPage m_aPage;
    private final int m_nPageSetIndex;
    private final int m_nPageSetCount;
    private final int m_nPageSetPageIndex;
    private final int m_nPageSetPageCount;
    private final int m_nTotalPageIndex;
    private final int m_nTotalPageCount;
    private final ICommonsOrderedMap<String, String> m_aPlaceholders = new CommonsLinkedHashMap();

    public PagePreRenderContext(@Nonnull PLPageSet pLPageSet, @Nonnull PDDocument pDDocument, @Nonnull PDPage pDPage, @Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnegative int n5, @Nonnegative int n6) {
        ValueEnforcer.notNull((Object)pLPageSet, (String)"PageSet");
        ValueEnforcer.notNull((Object)pDDocument, (String)"Document");
        ValueEnforcer.notNull((Object)pDPage, (String)"Page");
        ValueEnforcer.isGE0((int)n, (String)"PageSetIndex");
        ValueEnforcer.isGE0((int)n2, (String)"PageSetCount");
        ValueEnforcer.isGE0((int)n3, (String)"PageSetPageIndex");
        ValueEnforcer.isGE0((int)n4, (String)"PageSetPageCount");
        ValueEnforcer.isGE0((int)n5, (String)"TotalPageIndex");
        ValueEnforcer.isGE0((int)n6, (String)"TotalPageCount");
        this.m_aPageSet = pLPageSet;
        this.m_aDoc = pDDocument;
        this.m_aPage = pDPage;
        this.m_nPageSetIndex = n;
        this.m_nPageSetCount = n2;
        this.m_nPageSetPageIndex = n3;
        this.m_nPageSetPageCount = n4;
        this.m_nTotalPageIndex = n5;
        this.m_nTotalPageCount = n6;
        this.m_aPlaceholders.put((Object)EPLPlaceholder.PAGESET_INDEX.getVariable(), (Object)Integer.toString(this.getPageSetIndex()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.PAGESET_NUMBER.getVariable(), (Object)Integer.toString(this.getPageSetNumber()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.PAGESET_COUNT.getVariable(), (Object)Integer.toString(this.getPageSetCount()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.PAGESET_PAGE_INDEX.getVariable(), (Object)Integer.toString(this.getPageSetPageIndex()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.PAGESET_PAGE_NUMBER.getVariable(), (Object)Integer.toString(this.getPageSetPageNumber()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.PAGESET_PAGE_COUNT.getVariable(), (Object)Integer.toString(this.getPageSetPageCount()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.TOTAL_PAGE_INDEX.getVariable(), (Object)Integer.toString(this.getTotalPageIndex()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.TOTAL_PAGE_NUMBER.getVariable(), (Object)Integer.toString(this.getTotalPageNumber()));
        this.m_aPlaceholders.put((Object)EPLPlaceholder.TOTAL_PAGE_COUNT.getVariable(), (Object)Integer.toString(this.getTotalPageCount()));
    }

    @Nonnull
    public PLPageSet getPageSet() {
        return this.m_aPageSet;
    }

    @Nonnull
    public PDDocument getDocument() {
        return this.m_aDoc;
    }

    @Nonnull
    public PDPage getPage() {
        return this.m_aPage;
    }

    @Nonnegative
    public int getPageSetIndex() {
        return this.m_nPageSetIndex;
    }

    @Nonnegative
    public int getPageSetNumber() {
        return this.m_nPageSetIndex + 1;
    }

    @Nonnegative
    public int getPageSetCount() {
        return this.m_nPageSetCount;
    }

    @Nonnegative
    public int getPageSetPageIndex() {
        return this.m_nPageSetPageIndex;
    }

    @Nonnegative
    public int getPageSetPageNumber() {
        return this.m_nPageSetPageIndex + 1;
    }

    @Nonnegative
    public int getPageSetPageCount() {
        return this.m_nPageSetPageCount;
    }

    @Nonnegative
    public int getTotalPageIndex() {
        return this.m_nTotalPageIndex;
    }

    @Nonnegative
    public int getTotalPageNumber() {
        return this.m_nTotalPageIndex + 1;
    }

    @Nonnegative
    public int getTotalPageCount() {
        return this.m_nTotalPageCount;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllPlaceholders() {
        return this.m_aPlaceholders.getClone();
    }

    @Nullable
    public String getPlaceholder(@Nullable String string) {
        return (String)this.m_aPlaceholders.get((Object)string);
    }

    public int getPlaceholderAsInt(@Nullable String string, int n) {
        return StringParser.parseInt((String)this.getPlaceholder(string), (int)n);
    }

    public void addPlaceholder(@Nonnull @Nonempty String string, int n) {
        this.addPlaceholder(string, Integer.toString(n));
    }

    public void addPlaceholder(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Key");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aPlaceholders.put((Object)string, (Object)string2);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("PageSet", (Object)this.m_aPageSet).append("PDDoc", (Object)this.m_aDoc).append("PDPage", (Object)this.m_aPage).append("PageSetIndex", this.m_nPageSetIndex).append("PageSetCount", this.m_nPageSetCount).append("PageSetPageIndex", this.m_nPageSetPageIndex).append("PageSetPageCount", this.m_nPageSetPageCount).append("TotalPageIndex", this.m_nTotalPageIndex).append("TotalPageCount", this.m_nTotalPageCount).append("Placeholders", this.m_aPlaceholders).getToString();
    }
}

