/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.spec.PreloadFont;
import java.awt.Color;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@MustImplementEqualsAndHashcode
public class FontSpec
implements Serializable {
    public static final Color DEFAULT_COLOR = Color.BLACK;
    private final PreloadFont m_aPreloadFont;
    private final float m_fFontSize;
    private final Color m_aColor;

    public FontSpec(@Nonnull PreloadFont preloadFont, @Nonnegative float f) {
        this(preloadFont, f, DEFAULT_COLOR);
    }

    public FontSpec(@Nonnull PreloadFont preloadFont, @Nonnegative float f, @Nonnull Color color) {
        ValueEnforcer.notNull((Object)preloadFont, (String)"Font");
        ValueEnforcer.isFalse((boolean)Float.isNaN(f), (String)"FontSize may not be NaN");
        ValueEnforcer.isGT0((float)f, (String)"FontSize");
        ValueEnforcer.notNull((Object)color, (String)"Color");
        this.m_aPreloadFont = preloadFont;
        this.m_fFontSize = f;
        this.m_aColor = color;
    }

    @Nonnull
    public final PreloadFont getPreloadFont() {
        return this.m_aPreloadFont;
    }

    @Nonnull
    @Nonempty
    public final String getPreloadFontID() {
        return this.m_aPreloadFont.getID();
    }

    @Nonnegative
    public final float getFontSize() {
        return this.m_fFontSize;
    }

    @Nonnull
    public final Color getColor() {
        return this.m_aColor;
    }

    @Nonnull
    public FontSpec getCloneWithDifferentFont(@Nonnull PreloadFont preloadFont) {
        ValueEnforcer.notNull((Object)preloadFont, (String)"NewFont");
        if (preloadFont.equals(this.m_aPreloadFont)) {
            return this;
        }
        return new FontSpec(preloadFont, this.m_fFontSize, this.m_aColor);
    }

    @Nonnull
    public FontSpec getCloneWithDifferentFontSize(float f) {
        ValueEnforcer.isGT0((float)f, (String)"FontSize");
        if (EqualsHelper.equals((float)f, (float)this.m_fFontSize)) {
            return this;
        }
        return new FontSpec(this.m_aPreloadFont, f, this.m_aColor);
    }

    @Nonnull
    public FontSpec getCloneWithDifferentColor(@Nonnull Color color) {
        ValueEnforcer.notNull((Object)color, (String)"NewColor");
        if (color.equals(this.m_aColor)) {
            return this;
        }
        return new FontSpec(this.m_aPreloadFont, this.m_fFontSize, color);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FontSpec fontSpec = (FontSpec)object;
        return this.m_aPreloadFont.equals(fontSpec.m_aPreloadFont) && EqualsHelper.equals((float)this.m_fFontSize, (float)fontSpec.m_fFontSize) && this.m_aColor.equals(fontSpec.m_aColor);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aPreloadFont).append(this.m_fFontSize).append((Object)this.m_aColor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("PreloadFont", (Object)this.m_aPreloadFont).append("FontSize", this.m_fFontSize).append("Color", (Object)this.m_aColor).getToString();
    }
}

