/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pdflayout.spec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.pdflayout.spec.EValueUOMType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
@SuppressFBWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
public class HeightSpec
implements Serializable {
    private final EValueUOMType m_eType;
    private final float m_fValue;

    public HeightSpec(@Nonnull EValueUOMType eValueUOMType, float f) {
        ValueEnforcer.notNull((Object)((Object)eValueUOMType), (String)"HeightType");
        this.m_eType = eValueUOMType;
        this.m_fValue = f;
    }

    @Nonnull
    public final EValueUOMType getType() {
        return this.m_eType;
    }

    @Nonnull
    @Nonempty
    public final String getTypeID() {
        return this.m_eType.getID();
    }

    public final boolean isAbsolute() {
        return this.m_eType.isValueRequired();
    }

    public final boolean isStar() {
        return this.m_eType == EValueUOMType.STAR;
    }

    public final boolean isAuto() {
        return this.m_eType == EValueUOMType.AUTO;
    }

    @Nonnegative
    public final float getValue() {
        return this.m_fValue;
    }

    @Nonnegative
    public float getEffectiveValue(float f) {
        switch (this.m_eType) {
            case ABSOLUTE: {
                return Math.min(this.m_fValue, f);
            }
            case PERCENTAGE: {
                return f * this.m_fValue / 100.0f;
            }
        }
        throw new IllegalStateException("Unsupported: " + this.m_eType + " - must be calculated outside!");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HeightSpec heightSpec = (HeightSpec)object;
        return this.m_eType.equals((Object)heightSpec.m_eType) && EqualsHelper.equals((float)this.m_fValue, (float)heightSpec.m_fValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eType).append(this.m_fValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Type", (Enum)this.m_eType).appendIf("Value", (double)this.m_fValue, d -> this.isAbsolute()).getToString();
    }

    @Nonnull
    public static HeightSpec abs(@Nonnegative float f) {
        ValueEnforcer.isGT0((float)f, (String)"Value");
        return new HeightSpec(EValueUOMType.ABSOLUTE, f);
    }

    @Nonnull
    public static HeightSpec perc(@Nonnegative float f) {
        ValueEnforcer.isGT0((float)f, (String)"Perc");
        return new HeightSpec(EValueUOMType.PERCENTAGE, f);
    }

    @Nonnull
    public static HeightSpec star() {
        return new HeightSpec(EValueUOMType.STAR, 0.0f);
    }

    @Nonnull
    public static HeightSpec auto() {
        return new HeightSpec(EValueUOMType.AUTO, 0.0f);
    }
}

