/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.geonames.api;

import com.google.gson.annotations.SerializedName;
import org.mapton.api.MLatLon;
import org.mapton.geonames.api.Country;
import org.mapton.geonames.api.CountryManager;

public class Geoname {
    @SerializedName(value="alternate_names")
    private String mAlternateNames;
    @SerializedName(value="ascii_name")
    private String mAsciiName;
    @SerializedName(value="country_code")
    private String mCountryCode;
    @SerializedName(value="elevation")
    private Integer mElevation;
    @SerializedName(value="lat")
    private Double mLatitude;
    @SerializedName(value="lon")
    private Double mLongitude;
    @SerializedName(value="name")
    private String mName;
    @SerializedName(value="population")
    private Integer mPopulation;

    public String getAlternateNames() {
        return this.mAlternateNames;
    }

    public String getAsciiName() {
        return this.mAsciiName;
    }

    public Country getCountry() {
        return CountryManager.getInstance().getCodeCountryMap().get(this.getCountryCode());
    }

    public String getCountryCode() {
        return this.mCountryCode;
    }

    public String getCountryName() {
        return CountryManager.getInstance().getCodeNameMap().getOrDefault(this.getCountryCode(), "");
    }

    public Integer getElevation() {
        return this.mElevation;
    }

    public MLatLon getLatLon() {
        return new MLatLon(this.getLatitude().doubleValue(), this.getLongitude().doubleValue());
    }

    public Double getLatitude() {
        return this.mLatitude;
    }

    public Double getLongitude() {
        return this.mLongitude;
    }

    public String getName() {
        return this.mName;
    }

    public Integer getPopulation() {
        return this.mPopulation;
    }

    public void setAlternateNames(String alternateNames) {
        this.mAlternateNames = alternateNames;
    }

    public void setAsciiName(String asciiName) {
        this.mAsciiName = asciiName;
    }

    public void setCountryCode(String countryCode) {
        this.mCountryCode = countryCode;
    }

    public void setElevation(Integer elevation) {
        this.mElevation = elevation;
    }

    public void setLatitude(Double latitude) {
        this.mLatitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.mLongitude = longitude;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setPopulation(Integer population) {
        this.mPopulation = population;
    }
}

