/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.seasonal;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import java.awt.Color;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import org.apache.commons.lang3.RandomUtils;
import org.mapton.api.MLatLon;

public class Candle {
    private ShapeAttributes mBaseAttributes;
    private CappedCylinder mBaseCylinder;
    private ShapeAttributes mConeAttributes;
    private final double mHeight;
    private final MLatLon mLatLon;
    private boolean mLit;
    private final ArrayList<Renderable> mRenderables = new ArrayList();
    private final LocalDateTime mStartDateTime;
    private Cone mTopCone;
    private CappedCylinder mWickCylinder;
    private ShapeAttributes mWickLitAttributes;
    private ShapeAttributes mWickUnlitAttributes;
    private final double mWidth;

    public Candle(MLatLon latLon, LocalDateTime startDateTime, double height, double width) {
        this.mLatLon = latLon;
        this.mStartDateTime = startDateTime;
        this.mHeight = height;
        this.mWidth = width;
        this.initAttributes();
    }

    public ArrayList<Renderable> getRenderables() {
        LocalDateTime now = LocalDateTime.now();
        this.mLit = now.isAfter(this.mStartDateTime);
        long minutes = ChronoUnit.MINUTES.between(this.mStartDateTime, now);
        double periodMinutes = 37440.0;
        double height = this.mHeight;
        if (minutes > 0L) {
            double quota = (double)minutes / periodMinutes;
            height = this.mHeight - this.mHeight * 0.9 * quota;
        }
        this.mRenderables.clear();
        if (height > 0.0) {
            this.createObjects(height);
            this.mRenderables.add((Renderable)this.mBaseCylinder);
            this.mRenderables.add((Renderable)this.mWickCylinder);
            if (this.mLit) {
                this.mRenderables.add((Renderable)this.mTopCone);
            }
        }
        return this.mRenderables;
    }

    private void createObjects(double height) {
        Position position = Position.fromDegrees((double)this.mLatLon.getLatitude(), (double)this.mLatLon.getLongitude());
        this.mBaseCylinder = new CappedCylinder((LatLon)position, this.mWidth);
        this.mBaseCylinder.setAltitudes(0.0, height);
        this.mBaseCylinder.setAttributes(this.mBaseAttributes);
        this.mWickCylinder = new CappedCylinder((LatLon)position, this.mWidth * 0.1);
        int wickHeight = 8;
        this.mWickCylinder.setAltitudes(height, height + 8.0);
        if (this.mLit) {
            this.mWickCylinder.setAttributes(this.mWickLitAttributes);
        } else {
            this.mWickCylinder.setAttributes(this.mWickUnlitAttributes);
        }
        double offset = 8.0E-6;
        int coneHeight = RandomUtils.nextInt((int)23, (int)28);
        Position wickPosition = Position.fromDegrees((double)(this.mLatLon.getLatitude() + RandomUtils.nextDouble((double)0.0, (double)offset) * (double)(RandomUtils.nextBoolean() ? 1 : -1)), (double)(this.mLatLon.getLongitude() + RandomUtils.nextDouble((double)0.0, (double)offset) * (double)(RandomUtils.nextBoolean() ? 1 : -1)), (double)(height + 5.6 + (double)coneHeight * 0.5));
        this.mTopCone = new Cone(wickPosition, (double)coneHeight, this.mWidth * 0.6);
        this.mTopCone.setAttributes(this.mConeAttributes);
    }

    private void initAttributes() {
        this.mBaseAttributes = new BasicShapeAttributes();
        this.mBaseAttributes.setInteriorMaterial(new Material(Color.red.darker()));
        this.mBaseAttributes.setDrawOutline(false);
        this.mBaseAttributes.setEnableLighting(true);
        this.mConeAttributes = new BasicShapeAttributes(this.mBaseAttributes);
        this.mConeAttributes.setDrawOutline(false);
        this.mConeAttributes.setInteriorMaterial(Material.YELLOW);
        this.mConeAttributes.setInteriorOpacity(0.6);
        this.mWickUnlitAttributes = new BasicShapeAttributes(this.mBaseAttributes);
        this.mWickUnlitAttributes.setInteriorMaterial(Material.WHITE);
        this.mWickLitAttributes = new BasicShapeAttributes(this.mWickUnlitAttributes);
        this.mWickLitAttributes.setInteriorMaterial(Material.BLACK);
    }
}

