/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.seasonal;

import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import java.time.LocalDateTime;
import javax.swing.Timer;
import org.mapton.addon.seasonal.BaseRenderer;
import org.mapton.addon.seasonal.Candle;
import org.mapton.addon.seasonal.SeasonalSOSB;
import org.mapton.api.MLatLon;
import org.mapton.api.MOptions;
import org.mapton.api.MSimpleObjectStorageManager;
import org.mapton.api.Mapton;
import org.mapton.worldwind.api.LayerBundleManager;

public class CandleRenderer
extends BaseRenderer {
    public CandleRenderer(RenderableLayer layer) {
        super(layer);
        this.initAdvent();
    }

    @Override
    public void run() {
    }

    private void initAdvent() {
        double[] lons;
        double[] lats;
        LocalDateTime[] startTimes = new LocalDateTime[]{LocalDateTime.parse("2023-12-03T00:00:00"), LocalDateTime.parse("2023-12-10T00:00:00"), LocalDateTime.parse("2023-12-17T00:00:00"), LocalDateTime.parse("2023-12-24T00:00:00")};
        double[][] ll = (double[][])Mapton.getGlobalState().get("org.mapton.addon.seasonal.candle");
        if (ll != null) {
            lats = ll[0];
            lons = ll[1];
        } else {
            MLatLon mapHome = MOptions.getInstance().getMapHome();
            double lat = mapHome.getLatitude();
            double lon = mapHome.getLongitude();
            double dist = 6.75E-4;
            lats = new double[]{lat, lat, lat, lat};
            lons = new double[]{lon - 1.5 * dist, lon - 0.5 * dist, lon + 0.5 * dist, lon + 1.5 * dist};
        }
        Candle[] candles = new Candle[4];
        for (int i = 0; i < candles.length; ++i) {
            candles[i] = new Candle(new MLatLon(lats[i], lons[i]), startTimes[i], 120.0, 5.0);
        }
        Timer timer = new Timer(700, event -> {
            this.mLayer.removeAllRenderables();
            if (MSimpleObjectStorageManager.getInstance().getBoolean(SeasonalSOSB.class, Boolean.valueOf(true)).booleanValue()) {
                for (Candle candle : candles) {
                    for (Renderable renderable : candle.getRenderables()) {
                        this.mLayer.addRenderable(renderable);
                    }
                }
                LayerBundleManager.getInstance().redraw();
            }
        });
        LocalDateTime now = LocalDateTime.now();
        if (now.isAfter(startTimes[0].minusDays(3L)) && now.isBefore(startTimes[startTimes.length - 1].plusDays(10L))) {
            timer.start();
        }
    }
}

