/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.seasonal;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.Polygon;
import java.awt.Color;
import java.util.ArrayList;
import org.apache.commons.lang3.RandomUtils;
import org.controlsfx.control.action.Action;
import org.mapton.addon.seasonal.BaseRenderer;
import org.mapton.api.MLatLon;
import org.mapton.api.Mapton;

public class HalloweenRenderer
extends BaseRenderer {
    public HalloweenRenderer(RenderableLayer layer) {
        super(layer);
        this.setLatLon(new MLatLon(28.0, 0.0));
        this.setZoom(0.05);
    }

    @Override
    public void run() {
        Material skinMaterial = new Material(Color.decode("#e26300"));
        BasicAirspaceAttributes skinAttrs = new BasicAirspaceAttributes(skinMaterial, 0.9);
        Material featureMaterial = Material.BLACK;
        BasicAirspaceAttributes featureAttrs = new BasicAirspaceAttributes(featureMaterial, 0.8);
        BasicAirspaceAttributes hornAttrs = new BasicAirspaceAttributes(skinMaterial, 1.0);
        double skinLowAlt = 100000.0;
        double skinHighAlt = 200000.0;
        CappedCylinder skinCylinder = new CappedCylinder((AirspaceAttributes)skinAttrs);
        skinCylinder.setCenter(LatLon.fromDegrees((double)90.0, (double)0.0));
        skinCylinder.setCenter(LatLon.fromDegrees((double)0.0, (double)0.0));
        skinCylinder.setRadii(0.0, 2.0E7);
        skinCylinder.setAltitudes(100000.0, 200000.0);
        skinCylinder.setTerrainConforming(false, false);
        skinCylinder.setDragEnabled(false);
        this.mLayer.addRenderable((Renderable)skinCylinder);
        double hornHeight = 3000000.0;
        double baseRadius = 1000000.0;
        double hornRadius = 1000000.0;
        Cone westCone = new Cone(Position.fromDegrees((double)57.0, (double)-50.0, (double)1400000.0), 3000000.0, 1000000.0);
        westCone.setAttributes((ShapeAttributes)hornAttrs);
        this.mLayer.addRenderable((Renderable)westCone);
        Cone eastCone = new Cone(Position.fromDegrees((double)57.0, (double)50.0, (double)1400000.0), 3000000.0, 1000000.0);
        eastCone.setAttributes((ShapeAttributes)hornAttrs);
        this.mLayer.addRenderable((Renderable)eastCone);
        Polygon westEyePolygon = new Polygon((AirspaceAttributes)featureAttrs);
        westEyePolygon.setAltitudes(200000.0, 400000.0);
        ArrayList<LatLon> westEyeList = new ArrayList<LatLon>();
        westEyeList.add(LatLon.fromDegrees((double)30.0, (double)-30.0));
        westEyeList.add(LatLon.fromDegrees((double)30.0, (double)-15.0));
        westEyeList.add(LatLon.fromDegrees((double)45.0, (double)-15.0));
        westEyePolygon.setLocations(westEyeList);
        this.mLayer.addRenderable((Renderable)westEyePolygon);
        Polygon rightEyePolygon = new Polygon((AirspaceAttributes)featureAttrs);
        rightEyePolygon.setAltitudes(200000.0, 400000.0);
        ArrayList<LatLon> rightEyeList = new ArrayList<LatLon>();
        rightEyeList.add(LatLon.fromDegrees((double)30.0, (double)30.0));
        rightEyeList.add(LatLon.fromDegrees((double)30.0, (double)15.0));
        rightEyeList.add(LatLon.fromDegrees((double)45.0, (double)15.0));
        rightEyePolygon.setLocations(rightEyeList);
        this.mLayer.addRenderable((Renderable)rightEyePolygon);
        Polygon nosePolygon = new Polygon((AirspaceAttributes)featureAttrs);
        nosePolygon.setAltitudes(200000.0, 400000.0);
        ArrayList<LatLon> noseList = new ArrayList<LatLon>();
        noseList.add(LatLon.fromDegrees((double)10.0, (double)-7.5));
        noseList.add(LatLon.fromDegrees((double)10.0, (double)7.5));
        noseList.add(LatLon.fromDegrees((double)25.0, (double)0.0));
        nosePolygon.setLocations(noseList);
        this.mLayer.addRenderable((Renderable)nosePolygon);
        ArrayList<LatLon> mouthList = new ArrayList<LatLon>();
        double baseLat = -10.0;
        int lonSpan = 100;
        for (int i = -lonSpan / 2; i <= lonSpan / 2; i += 10) {
            double lon = i;
            boolean odd = (i / 10 & 1) != 0;
            double span = (double)(odd ? 2 : 3) * RandomUtils.nextDouble((double)0.8, (double)1.2);
            double lat = baseLat + span;
            mouthList.add(LatLon.fromDegrees((double)lat, (double)lon));
        }
        Polygon mouthPolygon = new Polygon((AirspaceAttributes)featureAttrs);
        mouthPolygon.setAltitudes(200000.0, 400000.0);
        mouthPolygon.setLocations(mouthList);
        this.mLayer.addRenderable((Renderable)mouthPolygon);
        Mapton.notification((String)"toolbar.notification.warning", (String)"Trick or treat!", (String)"Give me some Jazz,\nthen Go Home!", (Action[])new Action[]{null});
    }
}

