/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.seasonal;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.Orbit;
import gov.nasa.worldwind.render.airspaces.Polygon;
import java.awt.Color;
import java.util.Arrays;
import org.apache.commons.lang3.RandomUtils;
import org.mapton.addon.seasonal.BaseRenderer;
import org.mapton.api.MLatLon;

public class MardiGrasRenderer
extends BaseRenderer {
    public MardiGrasRenderer(RenderableLayer layer) {
        super(layer);
        this.setLatLon(new MLatLon(28.0, 0.0));
    }

    @Override
    public void run() {
        int i;
        Material topBreadMaterial = new Material(Color.decode("#712616").darker());
        Material bottomBreadMaterial = new Material(Color.decode("#712616"));
        Material creamMaterial = new Material(Color.decode("#fffdd0"));
        Material sugarMaterial = new Material(Color.decode("#f5f5f5"));
        BasicAirspaceAttributes topBreadAttrs = new BasicAirspaceAttributes(topBreadMaterial, 0.95);
        BasicAirspaceAttributes botttomBreadAttrs = new BasicAirspaceAttributes(bottomBreadMaterial, 0.95);
        BasicAirspaceAttributes creamAttrs = new BasicAirspaceAttributes(creamMaterial, 0.95);
        BasicAirspaceAttributes sugarAttrs = new BasicAirspaceAttributes(sugarMaterial, 1.0);
        CappedCylinder topCylinder = new CappedCylinder((AirspaceAttributes)topBreadAttrs);
        topCylinder.setCenter(LatLon.fromDegrees((double)90.0, (double)0.0));
        topCylinder.setRadii(0.0, 7000000.0);
        double lowAlt = 100000.0;
        double highAlt = 500000.0;
        topCylinder.setAltitudes(100000.0, 500000.0);
        topCylinder.setTerrainConforming(false, false);
        topCylinder.setDragEnabled(false);
        CappedCylinder bottomCylinder = new CappedCylinder((AirspaceAttributes)botttomBreadAttrs);
        bottomCylinder.setCenter(LatLon.fromDegrees((double)-90.0, (double)0.0));
        bottomCylinder.setRadii(0.0, 1.1E7);
        bottomCylinder.setAltitudes(100000.0, 500000.0);
        bottomCylinder.setTerrainConforming(false, false);
        bottomCylinder.setDragEnabled(false);
        Orbit creamOrbit = new Orbit((AirspaceAttributes)creamAttrs);
        creamOrbit.setLocations(LatLon.fromDegrees((double)18.0, (double)180.0), LatLon.fromDegrees((double)18.0, (double)90.0));
        creamOrbit.setAltitudes(100000.0, 750000.0);
        creamOrbit.setWidth(4500000.0);
        creamOrbit.setOrbitType("Center");
        creamOrbit.setTerrainConforming(false, false);
        creamOrbit.setDragEnabled(false);
        this.mLayer.addRenderable((Renderable)topCylinder);
        this.mLayer.addRenderable((Renderable)bottomCylinder);
        double baseLat = 18.0;
        double width = 12.0;
        int step = 60;
        for (i = -180; i < 180; i += step) {
            Polygon creamPolygon = new Polygon((AirspaceAttributes)creamAttrs);
            double startLon = i;
            double stopLon = i + step;
            creamPolygon.setLocations(Arrays.asList(LatLon.fromDegrees((double)(baseLat - width), (double)startLon), LatLon.fromDegrees((double)(baseLat - width), (double)stopLon), LatLon.fromDegrees((double)(baseLat + width), (double)stopLon), LatLon.fromDegrees((double)(baseLat + width), (double)startLon)));
            creamPolygon.setAltitudes(100000.0, 750000.0);
            creamPolygon.setTerrainConforming(true, true);
            this.mLayer.addRenderable((Renderable)creamPolygon);
        }
        for (i = 0; i < 2000; ++i) {
            double lat = RandomUtils.nextDouble((double)50.0, (double)90.0);
            double lon = RandomUtils.nextDouble((double)0.0, (double)360.0) - 180.0;
            CappedCylinder sugarCylinder = new CappedCylinder((AirspaceAttributes)sugarAttrs);
            sugarCylinder.setCenter(LatLon.fromDegrees((double)lat, (double)lon));
            sugarCylinder.setRadii(0.0, 70000.0 * RandomUtils.nextDouble((double)0.3, (double)1.2));
            sugarCylinder.setAltitudes(500000.0, 500000.0 * RandomUtils.nextDouble((double)1.0, (double)1.01));
            sugarCylinder.setTerrainConforming(false, false);
            sugarCylinder.setDragEnabled(false);
            this.mLayer.addRenderable((Renderable)sugarCylinder);
        }
    }
}

