/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.seasonal;

import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.mapton.addon.seasonal.BaseRenderer;
import org.mapton.addon.seasonal.CandleRenderer;
import org.mapton.addon.seasonal.HalloweenRenderer;
import org.mapton.addon.seasonal.MardiGrasRenderer;
import org.mapton.addon.seasonal.SeasonalSOSB;
import org.mapton.api.MSimpleObjectStorageManager;
import org.mapton.api.Mapton;
import org.mapton.worldwind.api.LayerBundle;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class SeasonalLayerBundle
extends LayerBundle {
    private final int STARTUP_DELAY = 5;
    private final RenderableLayer mCandleLayer = new RenderableLayer();
    private final CandleRenderer mCandleRenderer;
    private final RenderableLayer mLayer = new RenderableLayer();

    public SeasonalLayerBundle() {
        this.mLayer.setPickEnabled(false);
        this.setVisibleInLayerManager((Layer)this.mLayer, false);
        this.mCandleLayer.setPickEnabled(false);
        this.setVisibleInLayerManager((Layer)this.mCandleLayer, false);
        this.mCandleRenderer = new CandleRenderer(this.mCandleLayer);
        this.initListeners();
    }

    public void populate() {
        this.getLayers().addAll((Object[])new Layer[]{this.mLayer, this.mCandleLayer});
        this.setPopulated(true);
        this.mLayer.setEnabled(true);
        this.mLayer.setMinActiveAltitude(10000.0);
    }

    private void checkForRefresh() {
        Object[] fettisdagar = new String[]{"20220301", "20230221", "20240213", "20250304", "20260217", "20270209", "20280229", "20290213"};
        String[] halloween = new String[]{"1030", "1031"};
        String today = FastDateFormat.getInstance((String)"yyyyMMdd").format(new Date(System.currentTimeMillis()));
        if (ArrayUtils.contains((Object[])fettisdagar, (Object)today)) {
            this.refresh(new MardiGrasRenderer(this.mLayer));
        } else if (Arrays.stream(halloween).anyMatch(s -> StringUtils.endsWith((CharSequence)today, (CharSequence)s))) {
            this.refresh(new HalloweenRenderer(this.mLayer));
        }
    }

    private void initListeners() {
        Mapton.getExecutionFlow().executeWhenReady("execution_flow_map_ww_initialized", () -> this.checkForRefresh());
        MSimpleObjectStorageManager.getInstance().addListener(pcl -> this.checkForRefresh(), SeasonalSOSB.class);
    }

    private void refresh(BaseRenderer renderer) {
        this.removeAllRenderables();
        if (MSimpleObjectStorageManager.getInstance().getBoolean(SeasonalSOSB.class, Boolean.valueOf(true)).booleanValue()) {
            new Thread(() -> {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                    renderer.run();
                    if (renderer.isHollow()) {
                        Preferences node = NbPreferences.root().node("org/mapton/me/worldwind");
                        node.put("map_style_prev", node.get("map_style", "se.trixon.hollow"));
                        node.put("map_style", "se.trixon.hollow");
                    }
                    renderer.panTo();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }, ((Object)((Object)this)).getClass().getCanonicalName()).start();
        }
    }
}

