/*
 * Decompiled with CFR 0.152.
 */
package com.helger.font.api;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.font.api.IFontWeight;
import javax.annotation.Nonnegative;

public class FontWeight
implements IFontWeight {
    private final int m_nWeight;

    public FontWeight(@Nonnegative int n) {
        this.m_nWeight = ValueEnforcer.isGE0((int)n, (String)"Weight");
    }

    @Override
    @Nonnegative
    public int getWeight() {
        return this.m_nWeight;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FontWeight fontWeight = (FontWeight)object;
        return this.m_nWeight == fontWeight.m_nWeight;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nWeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Weight", this.m_nWeight).getToString();
    }
}

