/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.wikipedia_ww;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.Renderable;
import java.awt.Color;
import org.mapton.addon.wikipedia.api.WikipediaArticle;
import org.mapton.addon.wikipedia.api.WikipediaArticleManager;
import org.mapton.worldwind.api.LayerBundle;
import org.mapton.worldwind.api.WWHelper;
import se.trixon.almond.util.SystemHelper;

public class WikipediaLayerBundle
extends LayerBundle {
    private final RenderableLayer mLayer = new RenderableLayer();
    private final WikipediaArticleManager mWikipediaArticleManager = WikipediaArticleManager.getInstance();

    public WikipediaLayerBundle() {
        this.mLayer.setName("Wikipedia");
        this.setCategoryAddOns((Layer)this.mLayer);
        this.setName("Wikipedia");
        this.init();
        this.initRepaint();
        this.initListeners();
    }

    public void populate() throws Exception {
        this.getLayers().add((Object)this.mLayer);
        this.repaint(0L);
    }

    private void init() {
        this.mLayer.setPickEnabled(true);
        this.attachTopComponentToLayer("WikipediaTopComponent", (Layer)this.mLayer);
    }

    private void initListeners() {
        this.mWikipediaArticleManager.getAllItems().addListener(c -> {
            this.repaint();
            this.mLayer.setEnabled(true);
        });
    }

    private void initRepaint() {
        this.setPainter(() -> {
            this.removeAllRenderables();
            String imageAddress = SystemHelper.getPackageAsPath(((Object)((Object)this)).getClass()) + "Wikipedia-logo.png";
            for (WikipediaArticle article : this.mWikipediaArticleManager.getAllItems()) {
                PointPlacemark placemark = new PointPlacemark(Position.fromDegrees((double)article.getLatLon().getLatitude(), (double)article.getLatLon().getLongitude()));
                placemark.setLabelText(article.getTitle());
                placemark.setValue("gov.nasa.worldwind.avkey.DisplayName", (Object)article.getDescription());
                placemark.setLineEnabled(false);
                placemark.setEnableLabelPicking(true);
                placemark.setAltitudeMode(1);
                placemark.setEnableLabelPicking(true);
                PointPlacemarkAttributes attrs = new PointPlacemarkAttributes(placemark.getDefaultAttributes());
                attrs.setImageAddress(imageAddress);
                attrs.setImageColor(Color.decode("#ff8888"));
                attrs.setLabelScale(Double.valueOf(1.0));
                attrs.setScale(Double.valueOf(0.15));
                attrs.setImageOffset(Offset.CENTER);
                placemark.setAttributes(attrs);
                placemark.setHighlightAttributes(WWHelper.createHighlightAttributes((PointPlacemarkAttributes)attrs, (double)1.5));
                placemark.setValue("mapton.runnable.left_click", () -> this.mWikipediaArticleManager.setSelectedItemAfterReset((Object)article));
                this.mLayer.addRenderable((Renderable)placemark);
            }
            this.setDragEnabled(false);
        });
    }
}

