/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.maintenance.settings21;

import java.io.File;
import org.mapton.api.Mapton;
import org.openide.modules.Places;
import se.trixon.almond.nbp.dialogs.NbOptionalDialog;
import se.trixon.almond.util.SnapHelper;

public class Settings21
implements Runnable {
    private final String mCache;
    private final String mIntro;
    private final String mUser;

    public Settings21() {
        this.mIntro = "First off, sorry about the inconvenience.\n\nThe settings and cache directories has changed and you might want to take action.\nClose Mapton before any operations on the directories, and remember, backups are good.\n\nYour choices are:\n 1 Do nothing, old data will be kept but not used.\n 2 Delete OLD directories and start afresh.\n 3 a) Clear the contents of NEW, except OLD. b) Move the contents from OLD to NEW. c) Delete OLD.\n\n";
        this.mUser = "Settings OLD: %s\nSettings NEW: %s\n";
        this.mCache = "\nCache OLD: %s\nCache NEW: %s\n";
    }

    @Override
    public void run() {
        Mapton.getExecutionFlow().executeWhenReady("execution_flow_map_initialized", () -> {
            File oldCacheDir;
            File oldUserDir;
            File newUserDir = Places.getUserDirectory();
            File newCacheDir = Places.getCacheDirectory();
            if (SnapHelper.isSnap()) {
                oldUserDir = new File(System.getenv("SNAP_USER_DATA"), ".mapton/2.1");
                oldCacheDir = new File(System.getenv("SNAP_USER_DATA"), ".cache/mapton/2.1");
            } else {
                oldUserDir = new File(newUserDir, "2.1");
                oldCacheDir = new File(newCacheDir, "2.1");
            }
            Object message = this.mIntro;
            if (oldUserDir.isDirectory()) {
                message = (String)message + this.mUser.formatted(oldUserDir, newUserDir);
            }
            if (oldCacheDir.isDirectory()) {
                message = (String)message + this.mCache.formatted(oldCacheDir, newCacheDir);
            }
            if (!((String)message).equals(this.mIntro)) {
                NbOptionalDialog.requestShowDialog(Settings21.class, (String)"0", (int)2, (String)"IMPORTANT INFORMATION", (String)message, null);
            }
        });
    }
}

