/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset;

import de.gsi.dataset.Formatter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DefaultNumberFormatter
implements Formatter<Number> {
    protected static final int NO_PREFIX_OFFSET = 8;
    protected static final String SI_PREFIX = "yzafpn\u00b5m kMGTPEZY";
    protected static final String SI_PREFIX_TEST = "yzafpnu\u00b5mkKMGTPEZY";
    protected static final int[] SI_PREFIX_EXP = new int[]{-24, -21, -18, -15, -12, -9, -6, -6, -3, 3, 3, 6, 9, 12, 15, 18, 21, 24};
    protected final DecimalFormat[] decimalFormat = new DecimalFormat[]{new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat("+#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat(" #.#;-#.#", DecimalFormatSymbols.getInstance(Locale.UK))};
    protected final DecimalFormat[] decimalFormatMaxPrecision = new DecimalFormat[]{new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK)), new DecimalFormat("#.#", DecimalFormatSymbols.getInstance(Locale.UK))};
    protected String fixedLengthFormat;
    protected String fixPrecisionFormat;
    protected String fixPrecisionFormatZero;
    private SignConvention signConvention = SignConvention.EMPTY_SIGN;
    private SignConvention signConventionExp = SignConvention.FORCE_SIGN;
    private int numberOfCharacters = 6;
    private int fixedPrecision = 3;
    private FormatMode formatMode = FormatMode.OPTIMAL_WIDTH;

    public DefaultNumberFormatter() {
        for (DecimalFormat format : this.decimalFormat) {
            format.setMaximumFractionDigits(20);
        }
        this.setNumberOfCharacters(this.numberOfCharacters);
        this.setFixedPrecision(this.fixedPrecision);
    }

    @Override
    @NotNull
    public Number fromString(@NotNull String string) {
        if (FormatMode.METRIC_PREFIX.equals((Object)this.formatMode)) {
            return DefaultNumberFormatter.metricParse(string, false);
        }
        if (FormatMode.BYTE_PREFIX.equals((Object)this.formatMode)) {
            return DefaultNumberFormatter.metricParse(string, true);
        }
        Double ret = Double.valueOf(string);
        long retInt = ret.longValue();
        if ((double)retInt == ret) {
            return retInt;
        }
        return ret;
    }

    @Override
    public final Class<Number> getClassInstance() {
        return Number.class;
    }

    public int getFixedPrecision() {
        return this.fixedPrecision;
    }

    public void setFixedPrecision(int fixedPrecision) {
        assert (fixedPrecision >= 0) : "precision must be larger 0, is: " + fixedPrecision;
        this.fixPrecisionFormat = "%." + fixedPrecision + "f%c";
        this.fixPrecisionFormatZero = "%." + fixedPrecision + "f";
        for (DecimalFormat format : this.decimalFormatMaxPrecision) {
            format.setMaximumFractionDigits(fixedPrecision);
        }
        this.fixedPrecision = fixedPrecision;
    }

    public FormatMode getFormatMode() {
        return this.formatMode;
    }

    public void setFormatMode(FormatMode formatMode) {
        this.formatMode = formatMode;
    }

    public int getNumberOfCharacters() {
        return this.numberOfCharacters;
    }

    public void setNumberOfCharacters(int numberOfCharacters) {
        assert (numberOfCharacters >= 0) : "numberOfCharacters must be larger 0, is: " + numberOfCharacters;
        this.fixedLengthFormat = "%1$" + numberOfCharacters + "s";
        this.numberOfCharacters = numberOfCharacters;
    }

    public SignConvention getSignConvention() {
        return this.signConvention;
    }

    public void setSignConvention(SignConvention signConvention) {
        this.signConvention = signConvention;
    }

    public SignConvention getSignConventionExp() {
        return this.signConventionExp;
    }

    public void setSignConventionExp(SignConvention signConventionExp) {
        this.signConventionExp = signConventionExp;
    }

    @Override
    @NotNull
    public String toString(@NotNull Number number) {
        if (number.doubleValue() == Double.NEGATIVE_INFINITY) {
            return this.formatMode.fixedWidth() ? String.format(this.fixedLengthFormat, "-\u221e") : "-\u221e";
        }
        if (number.doubleValue() == Double.POSITIVE_INFINITY) {
            return this.formatMode.fixedWidth() ? String.format(this.fixedLengthFormat, "+\u221e") : "+\u221e";
        }
        if (Double.isNaN(number.doubleValue())) {
            return this.formatMode.fixedWidth() ? String.format(this.fixedLengthFormat, "NaN") : "NaN";
        }
        switch (this.formatMode) {
            case METRIC_PREFIX: {
                return this.metricFormat(number.doubleValue(), false);
            }
            case BYTE_PREFIX: {
                return this.metricFormat(number.doubleValue(), true);
            }
            case FIXED_WIDTH_EXP: {
                return DefaultNumberFormatter.expFormatFixedWidth(number, this.numberOfCharacters, this.signConvention, this.signConventionExp);
            }
            case OPTIMAL_WIDTH: {
                return this.optimalWidthFormat(number);
            }
            case FIXED_WIDTH_AND_EXP: 
            case FIXED_WIDTH_ONLY: {
                return this.fixedWidthFormat(number);
            }
        }
        return number.toString();
    }

    protected String fixedWidthFormat(@NotNull Number number) {
        if (number.doubleValue() == 0.0) {
            if (Math.copySign(1.0, number.doubleValue()) > 0.0) {
                return String.format(this.fixedLengthFormat, "0");
            }
            return String.format(this.fixedLengthFormat, "-0");
        }
        String decimalForm = this.decimalFormat[this.signConvention.index].format(number);
        int decimalFormLength = decimalForm.length();
        int indexDecimalPoint = decimalForm.indexOf(46);
        if (indexDecimalPoint >= 0 && indexDecimalPoint < this.numberOfCharacters) {
            decimalForm = decimalForm.substring(0, Math.min(this.numberOfCharacters, decimalFormLength));
            decimalFormLength = decimalForm.length();
        }
        if (FormatMode.FIXED_WIDTH_ONLY.equals((Object)this.formatMode)) {
            return decimalFormLength >= this.numberOfCharacters ? decimalForm : String.format(this.fixedLengthFormat, decimalForm);
        }
        double absValue = Math.abs(number.doubleValue());
        String exponentialForm = DefaultNumberFormatter.expFormatFixedWidth(number, this.numberOfCharacters, this.signConvention, this.signConventionExp);
        double minExpLimit = Math.pow(10.0, (double)(-this.numberOfCharacters) + 2.0);
        double maxExpLimit = Math.pow(10.0, (double)this.numberOfCharacters - 2.0);
        if ((decimalFormLength <= exponentialForm.length() || decimalFormLength <= 5) && absValue > minExpLimit && absValue < maxExpLimit) {
            return decimalFormLength >= this.numberOfCharacters ? decimalForm : String.format(this.fixedLengthFormat, decimalForm);
        }
        return exponentialForm;
    }

    protected String metricFormat(double value, boolean byteFormat) {
        if (value == 0.0) {
            return String.format(this.fixPrecisionFormatZero, 0.0);
        }
        int orderOfMagnitude3 = Math.min((int)Math.floor(byteFormat ? Math.log10(Math.abs(value)) / Math.log10(1024.0) : Math.log10(Math.abs(value)) / 3.0), SI_PREFIX.length() - 8 - 1);
        int prefix_index = orderOfMagnitude3 + 8;
        double scaledValue = value / (byteFormat ? Math.pow(1024.0, orderOfMagnitude3) : Math.pow(10.0, (double)orderOfMagnitude3 * 3.0));
        if (prefix_index < 0 || prefix_index >= SI_PREFIX.length()) {
            return String.format("%." + this.fixedPrecision + "fe%d", scaledValue, orderOfMagnitude3 * 3);
        }
        return String.format(prefix_index != 8 ? this.fixPrecisionFormat : this.fixPrecisionFormatZero, scaledValue, Character.valueOf(SI_PREFIX.charAt(prefix_index)));
    }

    protected String optimalWidthFormat(@NotNull Number number) {
        if (number.doubleValue() == 0.0) {
            return "0";
        }
        String decimalForm = this.decimalFormatMaxPrecision[SignConvention.NONE.index].format(number);
        int decimalFormLength = decimalForm.length();
        double absValue = Math.abs(number.doubleValue());
        double minPrecision = Math.pow(10.0, -this.fixedPrecision);
        String exponentialForm = DefaultNumberFormatter.expFormatFixedPrecision(number.doubleValue(), this.fixedPrecision, SignConvention.NONE, this.signConventionExp);
        return decimalFormLength < exponentialForm.length() && absValue >= minPrecision ? decimalForm : exponentialForm;
    }

    protected static String expFormatFixedPrecision(double value, int precision, SignConvention sign, SignConvention signExp) {
        int order = (int)Math.floor(Math.log10(Math.abs(value)));
        double mantissa = value / Math.pow(10.0, order);
        return String.format(DefaultNumberFormatter.getSignPrefix(sign, mantissa >= 0.0) + "." + precision + "fE" + DefaultNumberFormatter.getSignPrefix(signExp, order >= 0) + "d", mantissa, order);
    }

    protected static String expFormatFixedWidth(Number value, int width, SignConvention sign, SignConvention signExp) {
        int order = (int)Math.floor(Math.log10(Math.abs(value.doubleValue())));
        int orderExp = (order == 0 ? 0 : (int)Math.floor(Math.log10(Math.abs(order)))) + 1;
        double mantissa = value.doubleValue() / Math.pow(10.0, order);
        int spaceForSigns = (SignConvention.NONE.equals((Object)sign) ? 0 : 1) + (SignConvention.NONE.equals((Object)signExp) ? 0 : 1);
        int precision = Math.max(0, width - (3 + orderExp + spaceForSigns));
        return String.format(DefaultNumberFormatter.getSignPrefix(sign, mantissa >= 0.0) + "." + precision + "fE" + DefaultNumberFormatter.getSignPrefix(signExp, order >= 0) + "d", mantissa, order);
    }

    protected static String getSignPrefix(SignConvention sign, boolean posValue) {
        switch (sign) {
            case FORCE_SIGN: {
                return "%+";
            }
            case EMPTY_SIGN: {
                return posValue ? " %" : "%";
            }
        }
        return "%";
    }

    protected static double metricParse(@NotNull String str, boolean byteFormat) {
        if (StringUtils.containsAny((CharSequence)str, (CharSequence)SI_PREFIX_TEST)) {
            String[] split = StringUtils.splitByCharacterType((String)str);
            assert (split.length > 1) : "malformed string: '" + str + "'";
            String prefix = split[split.length - 1];
            int index = SI_PREFIX_TEST.indexOf(prefix.charAt(0));
            assert (index >= 0) : "could not find matching index for prefix '" + prefix.charAt(0) + "'";
            double prefixScale = byteFormat ? Math.pow(1024.0, (double)SI_PREFIX_EXP[index] / 3.0) : Math.pow(10.0, SI_PREFIX_EXP[index]);
            double mantissa = Double.parseDouble(str.substring(0, str.length() - 1));
            return mantissa * prefixScale;
        }
        return Double.parseDouble(str);
    }

    public static enum FormatMode {
        FIXED_WIDTH_ONLY,
        FIXED_WIDTH_AND_EXP,
        FIXED_WIDTH_EXP,
        OPTIMAL_WIDTH,
        METRIC_PREFIX,
        BYTE_PREFIX,
        JDK;


        boolean fixedWidth() {
            return this == FIXED_WIDTH_ONLY || this == FIXED_WIDTH_AND_EXP || this == FIXED_WIDTH_EXP;
        }
    }

    public static enum SignConvention {
        NONE(0),
        FORCE_SIGN(1),
        EMPTY_SIGN(2);

        private final int index;

        private SignConvention(int index) {
            this.index = index;
        }
    }
}

