/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import java.io.Serializable;
import java.util.Objects;

public class DataRange {
    private static final double MIN_VALUE = -1.7976931348623157E308;
    private static final double MAX_VALUE = Double.MAX_VALUE;
    protected double min;
    protected double max;

    public DataRange() {
        this(Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public DataRange(DataRange range) {
        this.set(range.min, range.max);
    }

    public DataRange(double min, double max) {
        this.set(min, max);
    }

    public boolean add(DataRange range) {
        boolean a = this.add(range.min);
        boolean b = this.add(range.max);
        return a || b;
    }

    public boolean add(double value) {
        if (!Double.isFinite(value)) {
            return false;
        }
        if (value > this.min && value < this.max) {
            return false;
        }
        boolean retVal = false;
        if (value < this.min) {
            this.min = value;
            retVal = true;
        }
        if (value > this.max) {
            this.max = value;
            retVal = true;
        }
        return retVal;
    }

    public boolean add(double[] values) {
        return this.add(values, values.length);
    }

    public boolean add(double[] values, int nLength) {
        boolean retVal = false;
        for (int i = 0; i < nLength; ++i) {
            if (!this.add(values[i])) continue;
            retVal = true;
        }
        return retVal;
    }

    public boolean clear() {
        return this.set(Double.MAX_VALUE, -1.7976931348623157E308);
    }

    public boolean contains(double value) {
        return this.isDefined() && value <= this.max && value >= this.min;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataRange)) {
            return false;
        }
        DataRange range = (DataRange)obj;
        return range.hashCode() == this.hashCode();
    }

    public double getLength() {
        double len = this.getMax() - this.getMin();
        return this.isDefined() ? len : 0.0;
    }

    public double getMax() {
        if (this.isMaxDefined()) {
            return this.max;
        }
        return Double.NaN;
    }

    public double getMin() {
        if (this.isMinDefined()) {
            return this.min;
        }
        return Double.NaN;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean isDefined() {
        return this.isMinDefined() && this.isMaxDefined();
    }

    public boolean isMaxDefined() {
        return this.max > -1.7976931348623157E308;
    }

    public boolean isMinDefined() {
        return this.min < Double.MAX_VALUE;
    }

    public boolean set(DataRange range) {
        return this.set(range.min, range.max);
    }

    public boolean set(double min, double max) {
        boolean a = this.setMin(min);
        boolean b = this.setMax(max);
        return a || b;
    }

    public boolean setMax(double max) {
        if (this.max == max) {
            return false;
        }
        this.max = max;
        return true;
    }

    public boolean setMin(double min) {
        if (this.min == min) {
            return false;
        }
        this.min = min;
        return true;
    }

    public String toString() {
        String sb = this.getClass().getSimpleName() + " [min=" + (Serializable)(this.isMinDefined() ? Double.valueOf(this.getMin()) : "NotDefined") + ", max=" + (Serializable)(this.isMaxDefined() ? Double.valueOf(this.getMax()) : "NotDefined") + "]";
        return sb;
    }
}

