/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;

public class DoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSet2D,
DataSetError,
EditableDataSet {
    private static final String Y_COORDINATES = "Y coordinates";
    private static final String X_COORDINATES = "X coordinates";
    private static final long serialVersionUID = 8931518518245752926L;
    protected DoubleArrayList xValues;
    protected DoubleArrayList yValues;
    protected DoubleArrayList yErrorsPos;
    protected DoubleArrayList yErrorsNeg;

    public DoubleErrorDataSet(DataSet another) {
        super(another.getName(), another.getDimension(), DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        this.set(another);
    }

    public DoubleErrorDataSet(String name) {
        this(name, 0);
    }

    public DoubleErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, int initalSize, boolean deepCopy) {
        super(name, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        this.set(xValues, yValues, yErrorsNeg, yErrorsPos, initalSize, deepCopy);
    }

    public DoubleErrorDataSet(String name, int initalSize) {
        super(name, 2, DataSetError.ErrorType.NO_ERROR, DataSetError.ErrorType.ASYMMETRIC);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new DoubleArrayList(initalSize);
        this.yValues = new DoubleArrayList(initalSize);
        this.yErrorsPos = new DoubleArrayList(initalSize);
        this.yErrorsNeg = new DoubleArrayList(initalSize);
    }

    public DoubleErrorDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public DoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String label) {
        this.lock().writeLockGuard(() -> {
            this.xValues.add(x);
            this.yValues.add(y);
            this.yErrorsNeg.add(yErrorNeg);
            this.yErrorsPos.add(yErrorPos);
            if (label != null && !label.isEmpty()) {
                this.addDataLabel(this.xValues.size() - 1, label);
            }
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y - yErrorNeg);
            this.getAxisDescription(1).add(y + yErrorPos);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "add"));
    }

    public DoubleErrorDataSet add(double[] xValuesNew, double[] yValuesNew, double[] yErrorsNegNew, double[] yErrorsPosNew) {
        AssertUtils.notNull(X_COORDINATES, xValuesNew);
        AssertUtils.notNull(Y_COORDINATES, yValuesNew);
        AssertUtils.notNull("X error coordinates", yErrorsNegNew);
        AssertUtils.notNull("Y error coordinates", yErrorsPosNew);
        AssertUtils.equalDoubleArrays(xValuesNew, yValuesNew);
        this.lock().writeLockGuard(() -> {
            int addAt = this.xValues.size();
            int newElements = Math.min(Math.min(xValuesNew.length, yValuesNew.length), Math.min(yErrorsNegNew.length, yErrorsPosNew.length));
            this.resize(addAt + newElements);
            this.xValues.setElements(addAt, xValuesNew, 0, newElements);
            this.yValues.setElements(addAt, yValuesNew, 0, newElements);
            this.yErrorsNeg.setElements(addAt, yErrorsNegNew, 0, newElements);
            this.yErrorsPos.setElements(addAt, yErrorsPosNew, 0, newElements);
            this.getAxisDescription(0).add(xValuesNew);
            this.getAxisDescription(1).add(yValuesNew);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public DoubleErrorDataSet add(int index, double ... newValue) {
        if (newValue.length >= 4) {
            return this.add(index, newValue[0], newValue[1], newValue[2], newValue[3]);
        }
        return this.add(index, newValue[0], newValue[1]);
    }

    public DoubleErrorDataSet add(int index, double x, double y) {
        return this.add(index, x, y, 0.0, 0.0, null);
    }

    public DoubleErrorDataSet add(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(index, x, y, yErrorNeg, yErrorPos, null);
    }

    public DoubleErrorDataSet add(int index, double x, double y, double yErrorNeg, double yErrorPos, String label) {
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
            this.xValues.add(indexAt, x);
            this.yValues.add(indexAt, y);
            this.yErrorsNeg.add(indexAt, yErrorNeg);
            this.yErrorsPos.add(indexAt, yErrorPos);
            this.getDataLabelMap().addValueAndShiftKeys(indexAt, this.xValues.size(), label);
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y - yErrorNeg);
            this.getAxisDescription(1).add(y + yErrorPos);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleErrorDataSet add(int index, double[] x, double[] y, double[] yErrorNeg, double[] yErrorPos) {
        AssertUtils.notNull(X_COORDINATES, x);
        AssertUtils.notNull(Y_COORDINATES, y);
        AssertUtils.notNull(X_COORDINATES, yErrorNeg);
        AssertUtils.notNull(Y_COORDINATES, yErrorPos);
        int min = Math.min(x.length, y.length);
        AssertUtils.equalDoubleArrays(x, y, min);
        this.lock().writeLockGuard(() -> {
            int indexAt = Math.max(0, Math.min(index, this.getDataCount()));
            this.xValues.addElements(indexAt, x, 0, min);
            this.yValues.addElements(indexAt, y, 0, min);
            this.yErrorsNeg.addElements(indexAt, yErrorNeg, 0, min);
            this.yErrorsPos.addElements(indexAt, yErrorPos, 0, min);
            this.getAxisDescription(0).add(x);
            this.getAxisDescription(1).add(y);
            this.getDataLabelMap().shiftKeys(indexAt, this.xValues.size());
            this.getDataStyleMap().shiftKeys(indexAt, this.xValues.size());
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public DoubleErrorDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.xValues.clear();
            this.yValues.clear();
            this.yErrorsPos.clear();
            this.yErrorsNeg.clear();
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            this.clearMetaInfo();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    @Override
    public final double get(int dimIndex, int index) {
        return dimIndex == 0 ? this.xValues.elements()[index] : this.yValues.elements()[index];
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsNeg.elements()[index];
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? 0.0 : this.yErrorsPos.elements()[index];
    }

    @Override
    public double[] getErrorsNegative(int dimIndex) {
        return dimIndex == 0 ? super.getErrorsNegative(dimIndex) : this.yErrorsNeg.elements();
    }

    @Override
    public double[] getErrorsPositive(int dimIndex) {
        return dimIndex == 0 ? super.getErrorsPositive(dimIndex) : this.yErrorsPos.elements();
    }

    @Override
    public final double[] getValues(int dimIndex) {
        return dimIndex == 0 ? this.xValues.elements() : this.yValues.elements();
    }

    public DoubleErrorDataSet increaseCapacity(int amount) {
        this.lock().writeLockGuard(() -> {
            int size = this.getDataCount();
            this.resize(this.getCapacity() + amount);
            this.resize(size);
        });
        return (DoubleErrorDataSet)this.getThis();
    }

    @Override
    public DoubleErrorDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public DoubleErrorDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            int clampedToIndex = Math.min(toIndex, this.getDataCount());
            this.xValues.removeElements(fromIndex, clampedToIndex);
            this.yValues.removeElements(fromIndex, clampedToIndex);
            this.yErrorsNeg.removeElements(fromIndex, clampedToIndex);
            this.yErrorsPos.removeElements(fromIndex, clampedToIndex);
            this.getDataLabelMap().remove(fromIndex, clampedToIndex);
            this.getDataLabelMap().remove(fromIndex, clampedToIndex);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public DoubleErrorDataSet resize(int size) {
        this.lock().writeLockGuard(() -> {
            this.xValues.size(size);
            this.yValues.size(size);
            this.yErrorsPos.size(size);
            this.yErrorsNeg.size(size);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    @Override
    public DoubleErrorDataSet set(DataSet other, boolean copy) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> {
            if (other instanceof DataSetError) {
                this.set(other.getValues(0), other.getValues(1), ((DataSetError)other).getErrorsNegative(1), ((DataSetError)other).getErrorsPositive(1), other.getDataCount(), copy);
            } else {
                int count = other.getDataCount();
                this.set(other.getValues(0), other.getValues(1), new double[count], new double[count], other.getDataCount(), copy);
            }
            this.copyMetaData(other);
            this.copyDataLabelsAndStyles(other, copy);
            this.copyAxisDescription(other);
        }));
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set(DataSet, boolean=" + copy + ")"));
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        return this.set(xValues, yValues, yErrorsNeg, yErrorsPos, true);
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, boolean copy) {
        return this.set(xValues, yValues, yErrorsNeg, yErrorsPos, -1, copy);
    }

    public DoubleErrorDataSet set(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos, int nSamples, boolean copy) {
        AssertUtils.notNull(X_COORDINATES, xValues);
        AssertUtils.notNull(Y_COORDINATES, yValues);
        AssertUtils.notNull("Y error neg", yErrorsNeg);
        AssertUtils.notNull("Y error pos", yErrorsPos);
        int errorMin = Math.min(yErrorsPos.length, yErrorsNeg.length);
        int dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, errorMin));
        AssertUtils.equalDoubleArrays(xValues, yValues, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsNeg, dataMaxIndex);
        AssertUtils.equalDoubleArrays(xValues, yErrorsPos, dataMaxIndex);
        if (nSamples >= 0) {
            AssertUtils.indexInBounds(nSamples, xValues.length + 1, "xValues bounds");
            AssertUtils.indexInBounds(nSamples, yValues.length + 1, "yValues bounds");
            AssertUtils.indexInBounds(nSamples, yErrorsNeg.length + 1, "yErrorsNeg bounds");
            AssertUtils.indexInBounds(nSamples, yErrorsPos.length + 1, "yErrorsPos bounds");
        }
        int nSamplesToAdd = nSamples >= 0 ? Math.min(nSamples, xValues.length) : xValues.length;
        this.lock().writeLockGuard(() -> {
            this.getDataLabelMap().clear();
            this.getDataStyleMap().clear();
            if (copy) {
                if (this.xValues == null) {
                    this.xValues = new DoubleArrayList();
                }
                if (this.yValues == null) {
                    this.yValues = new DoubleArrayList();
                }
                if (this.yErrorsPos == null) {
                    this.yErrorsPos = new DoubleArrayList();
                }
                if (this.yErrorsNeg == null) {
                    this.yErrorsNeg = new DoubleArrayList();
                }
                this.resize(0);
                this.xValues.addElements(0, xValues, 0, nSamplesToAdd);
                this.yValues.addElements(0, yValues, 0, nSamplesToAdd);
                this.yErrorsNeg.addElements(0, yErrorsNeg, 0, nSamplesToAdd);
                this.yErrorsPos.addElements(0, yErrorsPos, 0, nSamplesToAdd);
            } else {
                this.xValues = DoubleArrayList.wrap((double[])xValues, (int)nSamplesToAdd);
                this.yValues = DoubleArrayList.wrap((double[])yValues, (int)nSamplesToAdd);
                this.yErrorsNeg = DoubleArrayList.wrap((double[])yErrorsNeg, (int)nSamplesToAdd);
                this.yErrorsPos = DoubleArrayList.wrap((double[])yErrorsPos, (int)nSamplesToAdd);
            }
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public DoubleErrorDataSet set(int index, double ... newValue) {
        if (newValue.length >= 4) {
            return this.set(index, newValue[0], newValue[1], newValue[2], newValue[3]);
        }
        return this.set(index, newValue[0], newValue[1]);
    }

    public DoubleErrorDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    public DoubleErrorDataSet set(int index, double x, double y, double yErrorNeg, double yErrorPos) {
        this.lock().writeLockGuard(() -> {
            int dataCount = Math.max(index + 1, this.getDataCount());
            this.xValues.size(dataCount);
            this.yValues.size(dataCount);
            this.xValues.elements()[index] = x;
            this.yValues.elements()[index] = y;
            this.yErrorsNeg.size(dataCount);
            this.yErrorsPos.size(dataCount);
            this.yErrorsNeg.elements()[index] = yErrorNeg;
            this.yErrorsPos.elements()[index] = yErrorPos;
            this.getDataLabelMap().remove(index);
            this.getDataStyleMap().remove(index);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - single"));
    }

    public DoubleErrorDataSet set(int index, double[] x, double[] y, double[] yErrorNeg, double[] yErrorPos) {
        this.lock().writeLockGuard(() -> {
            this.resize(Math.max(index + x.length, this.xValues.size()));
            System.arraycopy(x, 0, this.xValues.elements(), index, x.length);
            System.arraycopy(y, 0, this.yValues.elements(), index, y.length);
            System.arraycopy(yErrorNeg, 0, this.yErrorsNeg.elements(), index, yErrorNeg.length);
            System.arraycopy(yErrorPos, 0, this.yErrorsPos.elements(), index, yErrorPos.length);
            this.getDataLabelMap().remove(index, index + x.length);
            this.getDataStyleMap().remove(index, index + x.length);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "set - via arrays"));
    }

    public DoubleErrorDataSet trim() {
        this.lock().writeLockGuard(() -> {
            this.xValues.trim(0);
            this.yValues.trim(0);
            this.yErrorsPos.trim(0);
            this.yErrorsNeg.trim(0);
        });
        return (DoubleErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }
}

