/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.Histogram;
import de.gsi.dataset.Histogram1D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractHistogram;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;
import java.util.List;

public class Histogram
extends AbstractHistogram
implements Histogram1D,
DataSet2D {
    private static final long serialVersionUID = -8609726961834745312L;
    protected final boolean isHorizontal;

    public Histogram(String name, double[] xBins) {
        this(name, xBins, true);
    }

    public Histogram(String name, double[] xBins, boolean horizontal) {
        super(name, xBins);
        this.isHorizontal = horizontal;
        if (!this.isHorizontal) {
            this.flipAbscissaWithOrdinate();
        }
    }

    public Histogram(String name, int nBins, double minX, double maxX, AbstractHistogram.HistogramOuterBounds boundsType) {
        this(name, nBins, minX, maxX, true, boundsType);
    }

    public Histogram(String name, int nBins, double minX, double maxX, boolean horizontal, AbstractHistogram.HistogramOuterBounds boundsType) {
        super(name, nBins, minX, maxX, boundsType);
        this.isHorizontal = horizontal;
        if (!this.isHorizontal) {
            this.flipAbscissaWithOrdinate();
        }
    }

    @Override
    public void addBinContent(int bin, double w) {
        this.lock().writeLockGuard(() -> {
            int n = bin;
            this.data[n] = this.data[n] + w;
            if (bin == 0 || bin == this.data.length - 1) {
                return;
            }
            if (this.getDimension() == 2) {
                this.getAxisDescription(this.isHorizontal ? 1 : 0).add(this.data[bin]);
            } else {
                this.getAxisDescription(this.getDimension() - 1).add(this.data[bin]);
            }
        });
        this.fireInvalidated(new UpdatedDataEvent(this, "addBinContent()"));
    }

    @Override
    public int fill(double x, double w) {
        int retVal = this.lock().writeLockGuard(() -> {
            int bin = this.findBin(this.isHorizontal ? 0 : 1, x);
            this.addBinContent(bin, w);
            return bin;
        });
        this.fireInvalidated(new AddedDataEvent(this, "fill(double x, double w)"));
        return retVal;
    }

    @Override
    public void fillN(double[] x, double[] w, int stepSize) {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < x.length; ++i) {
                this.fill(x[i], w[i]);
            }
        });
        this.fireInvalidated(new AddedDataEvent(this, "fillN"));
    }

    @Override
    public double get(int dimIndex, int index) {
        switch (this.getBoundsType()) {
            case BINS_CENTERED_ON_BOUNDARY: {
                switch (dimIndex) {
                    case 0: {
                        return this.isHorizontal ? this.getBinCenter(0, index + 1) : this.getBinContent(index + 1);
                    }
                    case 1: {
                        return this.isHorizontal ? this.getBinContent(index + 1) : this.getBinCenter(1, index + 1);
                    }
                }
                return dimIndex + 1 < this.getDimension() ? this.getBinCenter(0, index + 1) : this.getBinContent(index + 1);
            }
        }
        switch (dimIndex) {
            case 0: {
                return this.isHorizontal ? this.getBinLimits(0, Histogram.Boundary.LOWER, index + 1) : this.getBinContent(index + 1);
            }
            case 1: {
                return this.isHorizontal ? this.getBinContent(index + 1) : this.getBinLimits(1, Histogram.Boundary.LOWER, index + 1);
            }
        }
        return dimIndex + 1 < this.getDimension() ? this.getBinLimits(0, Histogram.Boundary.LOWER, index + 1) : this.getBinContent(index + 1);
    }

    @Override
    public int getIndex(int dimIndex, double ... value) {
        AssertUtils.checkArrayDimension("value", value, 1);
        return Math.max(this.findBin(dimIndex, value[0]) - 1, 0);
    }

    @Override
    public List<String> getWarningList() {
        List<String> retVal = super.getWarningList();
        if (this.getBinContent(0) > 0.0 && !retVal.contains("under-range")) {
            retVal.add("under-range");
        }
        if (this.getBinContent(this.data.length - 1) > 0.0 && !retVal.contains("over-range")) {
            retVal.add("over-range");
        }
        return retVal;
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.data, 0.0);
        this.getDataStyleMap().clear();
        this.getDataLabelMap().clear();
        super.getWarningList().remove("under-range");
        super.getWarningList().remove("over-range");
        if (this.getDimension() == 2) {
            this.getAxisDescription(this.isHorizontal ? 1 : 0).clear();
        } else {
            this.getAxisDescription(this.getDimension() - 1).clear();
        }
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException("set is not implemented");
    }

    protected void flipAbscissaWithOrdinate() {
        this.getAxisDescription(1).set(this.getAxisDescription(0));
        this.getAxisDescription(0).clear();
        Histogram.swap(this.axisBins, 0, 1);
    }
}

