/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

public class LabelledMarker {
    private static String defaultColor = null;
    private static double defaultLineWidth = 0.0;
    private static double defaultFontSize = 0.0;
    private double x;
    private double y;
    private String label;
    private String color;
    private double lineWidth;
    private double fontSize = 12.0;

    public LabelledMarker(double x, String label) {
        this.x = x;
        this.label = label;
        this.color = defaultColor;
        this.lineWidth = defaultLineWidth;
        this.fontSize = defaultFontSize;
    }

    public LabelledMarker(double x, String label, String color) {
        this.x = x;
        this.label = label;
        this.color = color;
        this.lineWidth = defaultLineWidth;
        this.fontSize = defaultFontSize;
    }

    public LabelledMarker(double x, String label, String color, double lineWidth) {
        this.x = x;
        this.label = label;
        this.color = color;
        this.lineWidth = lineWidth;
        this.fontSize = defaultFontSize;
    }

    public String getColor() {
        return this.color;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public String getLabel() {
        return this.label;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public String getStyle() {
        StringBuilder sb = new StringBuilder();
        if (this.color != null && !this.color.isEmpty()) {
            sb.append("strokeColor=").append(this.color).append("; ");
            sb.append("fillColor=").append(this.color).append("; ");
        }
        if (this.lineWidth > 0.0) {
            sb.append("strokeWidth=").append(this.lineWidth).append("; ");
        }
        if (this.fontSize > 0.0) {
            sb.append("fontSize =").append(this.fontSize).append("; ");
        }
        return sb.toString();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void shift(double v) {
        this.x += v;
    }

    public static String getDefaultColor() {
        return defaultColor;
    }

    public static double getDefaultFontSize() {
        return defaultFontSize;
    }

    public static double getDefaultLineWidth() {
        return defaultLineWidth;
    }

    public static void setDefaultColor(String defaultColor) {
        LabelledMarker.defaultColor = defaultColor;
    }

    public static void setDefaultFontSize(double defaultFontSize) {
        LabelledMarker.defaultFontSize = defaultFontSize;
    }

    public static void setDefaultLineWidth(double defaultLineWidth) {
        LabelledMarker.defaultLineWidth = defaultLineWidth;
    }
}

