/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import java.util.ArrayList;
import java.util.List;

public class WrappedDataSet
extends AbstractDataSet<WrappedDataSet>
implements DataSet {
    private static final long serialVersionUID = -2324840899629186284L;
    private DataSet dataset;
    private final transient EventListener listener = s -> this.datasetInvalidated();

    public WrappedDataSet(String name) {
        super(name, 2);
    }

    private void datasetInvalidated() {
        this.getAxisDescriptions().forEach(AxisDescription::clear);
        this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public double get(int dimIndex, int index) {
        return this.dataset == null ? 0.0 : this.dataset.get(dimIndex, index);
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return this.dataset == null ? new ArrayList() : this.dataset.getAxisDescriptions();
    }

    @Override
    public int getDataCount() {
        return this.dataset == null ? 0 : this.dataset.getDataCount();
    }

    public DataSet getDataset() {
        return this.dataset;
    }

    @Override
    public String getName() {
        if (this.dataset != null) {
            return this.dataset.getName();
        }
        return super.getName();
    }

    @Override
    public String getStyle(int index) {
        return this.dataset == null ? null : this.dataset.getStyle(index);
    }

    public void setDataset(DataSet dataset) {
        if (this.dataset != null) {
            this.dataset.removeListener(this.listener);
        }
        this.dataset = dataset;
        if (this.dataset != null) {
            this.dataset.addListener(this.listener);
        }
        this.fireInvalidated(new UpdatedDataEvent(this));
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        this.lock().writeLockGuard(() -> other.lock().writeLockGuard(() -> this.setDataset(other)));
        return this.fireInvalidated(new UpdatedDataEvent(this, "set(DataSet, boolean=" + copy + ")"));
    }
}

