/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import de.gsi.dataset.spi.utils.MultiArray;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class MultiArrayDouble
extends MultiArray<double[]> {
    public static MultiArrayDouble wrap(double[] elements) {
        return MultiArrayDouble.wrap(elements, 0, elements.length);
    }

    public static MultiArrayDouble wrap(double[] elements, int offset, int length) {
        return new MultiArray1DDouble(elements, new int[]{length}, offset);
    }

    public static MultiArrayDouble wrap(double[] elements, int[] dimensions) {
        return MultiArrayDouble.wrap(elements, 0, dimensions);
    }

    public static MultiArrayDouble wrap(double[] elements, int offset, int[] dimensions) {
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        AssertUtils.gtOrEqual("Array size", nElements + offset, elements.length);
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DDouble(elements, dimensions, offset);
            }
            case 2: {
                return new MultiArray2DDouble(elements, dimensions, offset);
            }
        }
        return new MultiArrayDouble(elements, dimensions, offset);
    }

    public static MultiArrayDouble allocate(int[] dimensions) {
        switch (dimensions.length) {
            case 1: {
                return new MultiArray1DDouble(new double[dimensions[0]], dimensions, 0);
            }
            case 2: {
                return new MultiArray2DDouble(new double[dimensions[1] * dimensions[0]], dimensions, 0);
            }
        }
        int nElements = 1;
        for (int ni : dimensions) {
            nElements *= ni;
        }
        return new MultiArrayDouble(new double[nElements], dimensions, 0);
    }

    protected MultiArrayDouble(double[] elements, int[] dimensions, int offset) {
        super(elements, dimensions, offset);
    }

    public void setStrided(int index, double value) {
        ((double[])this.elements)[index + this.offset] = value;
    }

    public void set(int[] indices, double value) {
        ((double[])this.elements)[this.getIndex((int[])indices)] = value;
    }

    public double getStrided(int index) {
        return ((double[])this.elements)[index + this.offset];
    }

    public double get(int[] indices) {
        return ((double[])this.elements)[this.getIndex(indices)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultiArrayDouble)) {
            return false;
        }
        MultiArrayDouble that = (MultiArrayDouble)o;
        return Arrays.equals(this.dimensions, that.dimensions) && Arrays.equals((double[])this.elements, this.offset, this.offset + this.getElementsCount(), (double[])that.elements, that.offset, that.offset + this.getElementsCount());
    }

    public int hashCode() {
        int result = 1;
        for (int i = this.offset; i < this.offset + this.getElementsCount(); ++i) {
            result = 31 * result + Double.hashCode(((double[])this.elements)[i]);
        }
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public static class MultiArray2DDouble
    extends MultiArrayDouble {
        private final int stride;

        protected MultiArray2DDouble(double[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
            this.stride = dimensions[1];
        }

        public double get(int row, int column) {
            return ((double[])this.elements)[this.offset + column + row * this.stride];
        }

        public void set(int row, int column, double value) {
            ((double[])this.elements)[this.offset + column + row * this.stride] = value;
        }

        public double[] getRow(int row) {
            int index = row * this.stride + this.offset;
            return Arrays.copyOfRange((double[])this.elements, index, index + this.stride);
        }
    }

    public static class MultiArray1DDouble
    extends MultiArrayDouble {
        protected MultiArray1DDouble(double[] elements, int[] dimensions, int offset) {
            super(elements, dimensions, offset);
        }

        public double get(int index) {
            return this.getStrided(index);
        }

        public void set(int index, double value) {
            this.setStrided(index, value);
        }
    }
}

