/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.locks.DefaultDataSetLock;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ErrorTestDataSet
implements DataSetError {
    private final int nSamples;
    private final ErrorType errorType;
    private final DataSetLock<ErrorTestDataSet> lock = new DefaultDataSetLock<ErrorTestDataSet>(this);
    private final AtomicBoolean autoNotification = new AtomicBoolean();
    private final List<EventListener> eventListeners = new ArrayList<EventListener>();
    private static final double STEP = 0.4;
    private static final int N_STEP_SWEEP = 10;
    private static final int SWEEP_STEPS = 55;
    private static final double OMEGA = 0.1;
    private static final double AMPLITUDE = 3.2;
    private static final double X_ERR_POS = 0.2;
    private static final double X_ERR_NEG = 0.75;
    private static final double Y_ERR_POS = 1.1;
    private static final double Y_ERR_NEG = 2.85;

    public ErrorTestDataSet(int nSamples, ErrorType errorType) {
        this.nSamples = nSamples;
        this.errorType = errorType;
    }

    @Override
    public double get(int dimIndex, int index) {
        switch (dimIndex) {
            case 0: {
                return 0.4 * (double)(55 * (index / 10) + index % 10 * (index % 10 + 1) / 2);
            }
            case 1: {
                return 3.2 * Math.sin(this.get(0, index) * 0.1);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return List.of(this.getAxisDescription(0), this.getAxisDescription(1));
    }

    @Override
    public AxisDescription getAxisDescription(int dim) {
        switch (dim) {
            case 0: {
                return new DefaultAxisDescription(dim, "time", "s", 0.0, 0.4 * ((double)(50 * (this.nSamples / 10)) + Math.pow(this.nSamples % 10, 2.0) / 2.0));
            }
            case 1: {
                return new DefaultAxisDescription(dim, "amplitude", "V", -3.2, 3.2);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getDataCount() {
        return this.nSamples;
    }

    @Override
    public String getDataLabel(int index) {
        return null;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getIndex(int dimIndex, double ... x) {
        if (dimIndex != 0) {
            throw new UnsupportedOperationException("Can only get index of X dimension");
        }
        int n = (int)(x[0] / 0.4);
        return (int)((double)(10 * (n / 55)) + Math.floor(Math.sqrt((double)(n % 55) * 2.0)));
    }

    @Override
    public String getName() {
        return "ErrorTestDataSet(n=" + this.nSamples + ",error=" + this.errorType.name() + ")";
    }

    @Override
    public String getStyle() {
        return null;
    }

    @Override
    public String getStyle(int index) {
        return null;
    }

    @Override
    public double[] getValues(int dimIndex) {
        double[] result = new double[this.nSamples];
        for (int i = 0; i < this.nSamples; ++i) {
            result[i] = this.get(dimIndex, i);
        }
        return result;
    }

    public DataSetLock<ErrorTestDataSet> lock() {
        return this.lock;
    }

    @Override
    public ErrorTestDataSet recomputeLimits(int dimIndex) {
        return this;
    }

    @Override
    public DataSet setStyle(String style) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getValue(int dimIndex, double ... x) {
        AssertUtils.checkArrayDimension("x", x, 1);
        int index1 = this.getIndex(0, x);
        double x1 = this.get(0, index1);
        double y1 = this.get(dimIndex, index1);
        int index2 = x1 < x[0] ? index1 + 1 : index1 - 1;
        index2 = Math.max(0, Math.min(index2, this.getDataCount() - 1));
        double y2 = this.get(dimIndex, index2);
        if (Double.isNaN(y1) || Double.isNaN(y2)) {
            return Double.NaN;
        }
        double x2 = this.get(0, index2);
        if (x1 == x2) {
            return this.get(dimIndex, index1);
        }
        double de1 = this.get(dimIndex, index1);
        return de1 + (this.get(dimIndex, index2) - de1) * (x[0] - x1) / (x2 - x1);
    }

    @Override
    public DataSet set(DataSet other, boolean copy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public DataSet setVisible(boolean visible) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        if (this.getErrorType(dimIndex) == DataSetError.ErrorType.SYMMETRIC) {
            return this.getErrorPositive(dimIndex, index);
        }
        switch (dimIndex) {
            case 0: {
                return 0.75;
            }
            case 1: {
                return 2.85;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        switch (dimIndex) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 1.1;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public DataSetError.ErrorType getErrorType(int dimIndex) {
        return this.errorType.getType(dimIndex);
    }

    @Override
    public AtomicBoolean autoNotification() {
        return this.autoNotification;
    }

    @Override
    public List<EventListener> updateEventListener() {
        return this.eventListeners;
    }

    public static enum ErrorType {
        X_SYM,
        XY_SYM,
        Y_SYM,
        X_ASYM,
        XY_ASYM,
        Y_ASYM,
        X_ASYM_Y_SYM,
        X_SYM_Y_ASYM,
        NO_ERRORS;


        public DataSetError.ErrorType getType(int dimIndex) {
            switch (this) {
                case X_SYM: {
                    return dimIndex == 0 ? DataSetError.ErrorType.SYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case XY_SYM: {
                    return DataSetError.ErrorType.SYMMETRIC;
                }
                case Y_SYM: {
                    return dimIndex == 1 ? DataSetError.ErrorType.SYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case X_ASYM: {
                    return dimIndex == 0 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case XY_ASYM: {
                    return DataSetError.ErrorType.ASYMMETRIC;
                }
                case Y_ASYM: {
                    return dimIndex == 1 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case X_ASYM_Y_SYM: {
                    return dimIndex == 0 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.SYMMETRIC;
                }
                case X_SYM_Y_ASYM: {
                    return dimIndex == 0 ? DataSetError.ErrorType.SYMMETRIC : DataSetError.ErrorType.ASYMMETRIC;
                }
            }
            return DataSetError.ErrorType.NO_ERROR;
        }
    }
}

