/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

public class RingBuffer<E> {
    private final E[] elements;
    private final int capacity;
    private int writePos;
    private int readPos;
    private boolean flipped;

    public RingBuffer(int capacity) {
        this.capacity = capacity;
        this.elements = new Object[capacity];
        this.flipped = false;
    }

    public int available() {
        if (!this.flipped) {
            return this.writePos - this.readPos;
        }
        return this.capacity - this.readPos + this.writePos;
    }

    public boolean put(E element) {
        if (this.flipped) {
            if (this.writePos < this.readPos) {
                this.elements[this.writePos++] = element;
                return true;
            }
            return false;
        }
        if (this.writePos == this.capacity) {
            this.writePos = 0;
            this.flipped = true;
            if (this.writePos < this.readPos) {
                this.elements[this.writePos++] = element;
                return true;
            }
            return false;
        }
        this.elements[this.writePos++] = element;
        return true;
    }

    public int put(E[] newElements, int length) {
        int newElementsReadPos;
        if (!this.flipped) {
            if (length <= this.capacity - this.writePos) {
                for (newElementsReadPos = 0; newElementsReadPos < length; ++newElementsReadPos) {
                    this.elements[this.writePos++] = newElements[newElementsReadPos];
                }
                return newElementsReadPos;
            }
            while (this.writePos < this.capacity) {
                this.elements[this.writePos] = newElements[newElementsReadPos++];
                ++this.writePos;
            }
            this.writePos = 0;
            this.flipped = true;
            int endPos = Math.min(this.readPos, length - newElementsReadPos);
            while (this.writePos < endPos) {
                this.elements[this.writePos] = newElements[newElementsReadPos++];
                ++this.writePos;
            }
            return newElementsReadPos;
        }
        int endPos = Math.min(this.readPos, this.writePos + length);
        while (this.writePos < endPos) {
            this.elements[this.writePos] = newElements[newElementsReadPos++];
            ++this.writePos;
        }
        return newElementsReadPos;
    }

    public int remainingCapacity() {
        if (!this.flipped) {
            return this.capacity - this.writePos;
        }
        return this.readPos - this.writePos;
    }

    public void reset() {
        this.writePos = 0;
        this.readPos = 0;
        this.flipped = false;
    }

    public E take() {
        if (!this.flipped) {
            if (this.readPos < this.writePos) {
                return this.elements[this.readPos++];
            }
            return null;
        }
        if (this.readPos == this.capacity) {
            this.readPos = 0;
            this.flipped = false;
            if (this.readPos < this.writePos) {
                return this.elements[this.readPos++];
            }
            return null;
        }
        return this.elements[this.readPos++];
    }

    public int take(E[] into, int length) {
        int intoWritePos;
        if (!this.flipped) {
            int endPos = Math.min(this.writePos, this.readPos + length);
            while (this.readPos < endPos) {
                into[intoWritePos++] = this.elements[this.readPos];
                ++this.readPos;
            }
            return intoWritePos;
        }
        if (length <= this.capacity - this.readPos) {
            for (intoWritePos = 0; intoWritePos < length; ++intoWritePos) {
                into[intoWritePos] = this.elements[this.readPos++];
            }
            return intoWritePos;
        }
        while (this.readPos < this.capacity) {
            into[intoWritePos++] = this.elements[this.readPos];
            ++this.readPos;
        }
        this.readPos = 0;
        this.flipped = false;
        int endPos = Math.min(this.writePos, length - intoWritePos);
        while (this.readPos < endPos) {
            into[intoWritePos++] = this.elements[this.readPos];
            ++this.readPos;
        }
        return intoWritePos;
    }
}

