/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class SoftKeyHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Object NULL_KEY = new Object();
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    int modCount;
    private transient Set<Map.Entry<K, V>> entrySet;

    public SoftKeyHashMap() {
        this(16, 0.75f);
    }

    public SoftKeyHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SoftKeyHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = this.newTable(capacity);
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public SoftKeyHashMap(Map<? extends K, ? extends V> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(m);
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Entry<K, V>[] tab;
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        for (Entry<K, V> entry : tab = this.getTable()) {
            while (entry != null) {
                Object key = entry.get();
                if (key != null) {
                    action.accept(SoftKeyHashMap.unmaskNull(key), entry.value);
                }
                entry = entry.next;
                if (expectedModCount == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    @Override
    public V get(Object key) {
        Object k = SoftKeyHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = SoftKeyHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == h && SoftKeyHashMap.eq(k, e.get())) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        Object k = SoftKeyHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = SoftKeyHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[i];
        while (e != null) {
            if (h == e.hash && SoftKeyHashMap.eq(k, e.get())) {
                Object oldValue = e.value;
                if (value != oldValue) {
                    e.value = value;
                }
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        e = tab[i];
        tab[i] = new Entry<K, V>(k, value, this.queue, h, e);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> prev;
        Object k = SoftKeyHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = SoftKeyHashMap.indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && SoftKeyHashMap.eq(k, e.get())) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Entry<K, V>[] tab;
        Objects.requireNonNull(function);
        int expectedModCount = this.modCount;
        for (Entry<K, V> entry : tab = this.getTable()) {
            while (entry != null) {
                Object key = entry.get();
                if (key != null) {
                    entry.value = function.apply(SoftKeyHashMap.unmaskNull(key), entry.value);
                }
                entry = entry.next;
                if (expectedModCount == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
        }
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> x;
        while ((x = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> prev;
                Entry e = (Entry)x;
                int i = SoftKeyHashMap.indexFor(e.hash, this.table.length);
                Entry<K, V> p = prev = this.table[i];
                while (p != null) {
                    Entry next = p.next;
                    if (p == e) {
                        if (prev == e) {
                            this.table[i] = next;
                        } else {
                            prev.next = next;
                        }
                        e.value = null;
                        --this.size;
                        break;
                    }
                    prev = p;
                    p = next;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    private Entry<K, V>[] newTable(int n) {
        return new Entry[n];
    }

    private void transfer(Entry<K, V>[] src, Entry<K, V>[] dest) {
        for (int j = 0; j < src.length; ++j) {
            Entry<K, V> e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    int i = SoftKeyHashMap.indexFor(e.hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    Entry<K, V> getEntry(Object key) {
        Object k = SoftKeyHashMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = SoftKeyHashMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (!(e == null || e.hash == h && SoftKeyHashMap.eq(k, e.get()))) {
            e = e.next;
        }
        return e;
    }

    final int hash(Object k) {
        int h = k.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    boolean removeMapping(Object o) {
        Entry<K, V> prev;
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = SoftKeyHashMap.maskNull(entry.getKey());
        int h = this.hash(k);
        int i = SoftKeyHashMap.indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return true;
            }
            prev = e;
            e = next;
        }
        return false;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] newTable = this.newTable(newCapacity);
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private static boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    static final class ValueSpliterator<K, V>
    extends SoftHashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(SoftKeyHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        @Override
        public int characteristics() {
            return 0;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            SoftKeyHashMap m = this.map;
            Entry<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                hi = this.fence = tab.length;
            } else {
                mc = this.expectedModCount;
            }
            if (tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Entry p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    Object x = p.get();
                    Object v = p.value;
                    p = p.next;
                    if (x == null) continue;
                    action.accept(v);
                } while (p != null || i < hi);
            }
            if (m.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] tab = this.map.table;
            int hi = this.getFence();
            if (tab.length >= hi && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object x = this.current.get();
                    Object v = this.current.value;
                    this.current = this.current.next;
                    if (x == null) continue;
                    action.accept(v);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                valueSpliterator = null;
            } else {
                this.index = mid;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }
    }

    static class SoftHashMapSpliterator<K, V> {
        final SoftKeyHashMap<K, V> map;
        Entry<K, V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        SoftHashMapSpliterator(SoftKeyHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            this.map = m;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                SoftKeyHashMap<K, V> m = this.map;
                this.est = m.size();
                this.expectedModCount = m.modCount;
                hi = this.fence = m.table.length;
            }
            return hi;
        }
    }

    static final class KeySpliterator<K, V>
    extends SoftHashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(SoftKeyHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        @Override
        public int characteristics() {
            return 1;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            SoftKeyHashMap m = this.map;
            Entry<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                hi = this.fence = tab.length;
            } else {
                mc = this.expectedModCount;
            }
            if (tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Entry p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    Object x = p.get();
                    p = p.next;
                    if (x == null) continue;
                    Object k = SoftKeyHashMap.unmaskNull(x);
                    action.accept(k);
                } while (p != null || i < hi);
            }
            if (m.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] tab = this.map.table;
            int hi = this.getFence();
            if (tab.length >= hi && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object x = this.current.get();
                    this.current = this.current.next;
                    if (x == null) continue;
                    Object k = SoftKeyHashMap.unmaskNull(x);
                    action.accept(k);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }
    }

    static final class EntrySpliterator<K, V>
    extends SoftHashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(SoftKeyHashMap<K, V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        @Override
        public int characteristics() {
            return 1;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            SoftKeyHashMap m = this.map;
            Entry<K, V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                hi = this.fence = tab.length;
            } else {
                mc = this.expectedModCount;
            }
            if (tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Entry p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    Object x = p.get();
                    Object v = p.value;
                    p = p.next;
                    if (x == null) continue;
                    Object k = SoftKeyHashMap.unmaskNull(x);
                    action.accept(new AbstractMap.SimpleImmutableEntry(k, v));
                } while (p != null || i < hi);
            }
            if (m.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Entry<K, V>[] tab = this.map.table;
            int hi = this.getFence();
            if (tab.length >= hi && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object x = this.current.get();
                    Object v = this.current.value;
                    this.current = this.current.next;
                    if (x == null) continue;
                    Object k = SoftKeyHashMap.unmaskNull(x);
                    action.accept(new AbstractMap.SimpleImmutableEntry(k, v));
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                entrySpliterator = null;
            } else {
                this.index = mid;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }
    }

    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry;
        private Entry<K, V> lastReturned;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = SoftKeyHashMap.this.modCount;
            this.index = SoftKeyHashMap.this.isEmpty() ? 0 : SoftKeyHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] t = SoftKeyHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (SoftKeyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            SoftKeyHashMap.this.remove(this.currentKey);
            this.expectedModCount = SoftKeyHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }

        protected Entry<K, V> nextEntry() {
            if (SoftKeyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public void clear() {
            SoftKeyHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Entry candidate = SoftKeyHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            return SoftKeyHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return SoftKeyHashMap.this.size();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(SoftKeyHashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.deepCopy().toArray(a);
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList list = new ArrayList(this.size());
            this.forEach(e -> list.add(new AbstractMap.SimpleEntry(e)));
            return list;
        }
    }

    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private static class Entry<K, V>
    extends SoftReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object key, V value, ReferenceQueue<Object> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public boolean equals(Object o) {
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            if (Objects.equals(k1, k2 = e.getKey())) {
                V v1 = this.getValue();
                Object v2 = e.getValue();
                return Objects.equals(v1, v2);
            }
            return false;
        }

        @Override
        public K getKey() {
            return (K)SoftKeyHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return Objects.hashCode(k) ^ Objects.hashCode(v);
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

