/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.SplitLocation;
import org.apache.commons.geometry.euclidean.internal.EuclideanUtils;
import org.apache.commons.geometry.euclidean.threed.AffineTransformMatrix3D;
import org.apache.commons.geometry.euclidean.threed.ConvexPolygon3D;
import org.apache.commons.geometry.euclidean.threed.EmbeddedAreaPlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.EmbeddingPlane;
import org.apache.commons.geometry.euclidean.threed.Plane;
import org.apache.commons.geometry.euclidean.threed.PlaneConvexSubset;
import org.apache.commons.geometry.euclidean.threed.PlaneSubset;
import org.apache.commons.geometry.euclidean.threed.SimpleTriangle3D;
import org.apache.commons.geometry.euclidean.threed.Triangle3D;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.VertexListConvexPolygon3D;
import org.apache.commons.geometry.euclidean.threed.line.Line3D;
import org.apache.commons.geometry.euclidean.threed.line.LineConvexSubset3D;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.geometry.euclidean.twod.Line;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.RegionBSPTree2D;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.path.LinePath;
import org.apache.commons.numbers.core.Precision;

public final class Planes {
    private Planes() {
    }

    public static EmbeddingPlane fromPointAndPlaneVectors(Vector3D p, Vector3D u, Vector3D v, Precision.DoubleEquivalence precision) {
        Vector3D.Unit uNorm = u.normalize();
        Vector3D.Unit vNorm = uNorm.orthogonal(v);
        Vector3D.Unit wNorm = uNorm.cross(vNorm).normalize();
        double originOffset = -p.dot(wNorm);
        return new EmbeddingPlane(uNorm, vNorm, wNorm, originOffset, precision);
    }

    public static Plane fromNormal(Vector3D normal, Precision.DoubleEquivalence precision) {
        return Planes.fromPointAndNormal(Vector3D.ZERO, normal, precision);
    }

    public static Plane fromPointAndNormal(Vector3D p, Vector3D normal, Precision.DoubleEquivalence precision) {
        Vector3D.Unit unitNormal = normal.normalize();
        double originOffset = -p.dot(unitNormal);
        return new Plane(unitNormal, originOffset, precision);
    }

    public static Plane fromPoints(Vector3D p1, Vector3D p2, Vector3D p3, Precision.DoubleEquivalence precision) {
        return Planes.fromPoints(Arrays.asList(p1, p2, p3), precision);
    }

    public static Plane fromPoints(Collection<Vector3D> pts, Precision.DoubleEquivalence precision) {
        return new PlaneBuilder(pts, precision).build();
    }

    public static PlaneConvexSubset subsetFromConvexArea(EmbeddingPlane plane, ConvexArea area) {
        if (area.isFinite()) {
            List vertices = plane.toSpace(area.getVertices());
            return Planes.fromConvexPlanarVertices(plane, vertices);
        }
        return new EmbeddedAreaPlaneConvexSubset(plane, area);
    }

    public static ConvexPolygon3D convexPolygonFromVertices(Collection<Vector3D> pts, Precision.DoubleEquivalence precision) {
        Vector3D lastPt;
        ArrayList<Vector3D> vertices = new ArrayList<Vector3D>(pts.size());
        Plane plane = new PlaneBuilder(pts, precision).buildForConvexPolygon(vertices);
        Vector3D firstPt = (Vector3D)vertices.get(0);
        if (firstPt.eq(lastPt = (Vector3D)vertices.get(vertices.size() - 1), precision)) {
            vertices.remove(vertices.size() - 1);
        }
        if (vertices.size() == 3) {
            return new SimpleTriangle3D(plane, (Vector3D)vertices.get(0), (Vector3D)vertices.get(1), (Vector3D)vertices.get(2));
        }
        return new VertexListConvexPolygon3D(plane, vertices);
    }

    public static Triangle3D triangleFromVertices(Vector3D p1, Vector3D p2, Vector3D p3, Precision.DoubleEquivalence precision) {
        Plane plane = Planes.fromPoints(p1, p2, p3, precision);
        return new SimpleTriangle3D(plane, p1, p2, p3);
    }

    public static List<Triangle3D> indexedTriangles(Vector3D[] vertices, int[][] faceIndices, Precision.DoubleEquivalence precision) {
        return Planes.indexedTriangles(Arrays.asList(vertices), faceIndices, precision);
    }

    public static List<Triangle3D> indexedTriangles(List<? extends Vector3D> vertices, int[][] faceIndices, Precision.DoubleEquivalence precision) {
        int numFaces = faceIndices.length;
        ArrayList<Triangle3D> triangles = new ArrayList<Triangle3D>(numFaces);
        for (int i = 0; i < numFaces; ++i) {
            int[] face = faceIndices[i];
            if (face.length != 3) {
                throw new IllegalArgumentException(MessageFormat.format("Invalid number of vertex indices for face at index {0}: expected {1} but found {2}", i, 3, face.length));
            }
            triangles.add(Planes.triangleFromVertices(vertices.get(face[0]), vertices.get(face[1]), vertices.get(face[2]), precision));
        }
        return triangles;
    }

    public static List<ConvexPolygon3D> indexedConvexPolygons(Vector3D[] vertices, int[][] faceIndices, Precision.DoubleEquivalence precision) {
        return Planes.indexedConvexPolygons(Arrays.asList(vertices), faceIndices, precision);
    }

    public static List<ConvexPolygon3D> indexedConvexPolygons(List<? extends Vector3D> vertices, int[][] faceIndices, Precision.DoubleEquivalence precision) {
        int numFaces = faceIndices.length;
        ArrayList<ConvexPolygon3D> polygons = new ArrayList<ConvexPolygon3D>(numFaces);
        ArrayList<Vector3D> faceVertices = new ArrayList<Vector3D>();
        for (int i = 0; i < numFaces; ++i) {
            int[] face = faceIndices[i];
            if (face.length < 3) {
                throw new IllegalArgumentException(MessageFormat.format("Invalid number of vertex indices for face at index {0}: required at least {1} but found {2}", i, 3, face.length));
            }
            for (int vertexIndex : face) {
                faceVertices.add(vertices.get(vertexIndex));
            }
            polygons.add(Planes.convexPolygonFromVertices(faceVertices, precision));
            faceVertices.clear();
        }
        return polygons;
    }

    public static List<PlaneConvexSubset> extrudeVertexLoop(List<Vector2D> vertices, EmbeddingPlane plane, Vector3D extrusionVector, Precision.DoubleEquivalence precision) {
        LinePath path = LinePath.fromVertexLoop(vertices, precision);
        return Planes.extrude(path, plane, extrusionVector, precision);
    }

    public static List<PlaneConvexSubset> extrude(LinePath path, EmbeddingPlane plane, Vector3D extrusionVector, Precision.DoubleEquivalence precision) {
        return Planes.extrude(path.toTree(), plane, extrusionVector, precision);
    }

    public static List<PlaneConvexSubset> extrude(RegionBSPTree2D region, EmbeddingPlane plane, Vector3D extrusionVector, Precision.DoubleEquivalence precision) {
        return new PlaneRegionExtruder(plane, extrusionVector, precision).extrude(region);
    }

    static Vector3D intersection(PlaneSubset planeSubset, Line3D line) {
        Vector3D pt = planeSubset.getPlane().intersection(line);
        return pt != null && planeSubset.contains(pt) ? pt : null;
    }

    static Vector3D intersection(PlaneSubset planeSubset, LineConvexSubset3D lineSubset) {
        Vector3D pt = Planes.intersection(planeSubset, lineSubset.getLine());
        return pt != null && lineSubset.contains(pt) ? pt : null;
    }

    static void validatePlanesEquivalent(Plane expected, Plane actual) {
        if (!expected.eq(actual, expected.getPrecision())) {
            throw new IllegalArgumentException("Arguments do not represent the same plane. Expected " + (Object)((Object)expected) + " but was " + (Object)((Object)actual) + ".");
        }
    }

    static <T extends PlaneSubset> Split<T> subspaceSplit(Plane splitter, T subset, BiFunction<? super EmbeddingPlane, ? super HyperplaneBoundedRegion<Vector2D>, T> factory) {
        EmbeddingPlane thisPlane = subset.getPlane().getEmbedding();
        Line3D intersection = thisPlane.intersection(splitter);
        if (intersection == null) {
            return Planes.getNonIntersectingSplitResult(splitter, subset);
        }
        EmbeddingPlane embeddingPlane = subset.getPlane().getEmbedding();
        Vector3D intersectionOrigin = intersection.getOrigin();
        Vector2D subspaceP1 = embeddingPlane.toSubspace(intersectionOrigin);
        Vector2D subspaceP2 = embeddingPlane.toSubspace(intersectionOrigin.add(intersection.getDirection()));
        Line subspaceSplitter = Lines.fromPoints(subspaceP1, subspaceP2, thisPlane.getPrecision());
        Split split = subset.getEmbedded().getSubspaceRegion().split((Hyperplane)subspaceSplitter);
        SplitLocation subspaceSplitLoc = split.getLocation();
        if (SplitLocation.MINUS == subspaceSplitLoc) {
            return new Split(subset, null);
        }
        if (SplitLocation.PLUS == subspaceSplitLoc) {
            return new Split(null, subset);
        }
        PlaneSubset minus = split.getMinus() != null ? (PlaneSubset)factory.apply((EmbeddingPlane)((EmbeddingPlane)thisPlane), (HyperplaneBoundedRegion<Vector2D>)split.getMinus()) : null;
        PlaneSubset plus = split.getPlus() != null ? (PlaneSubset)factory.apply((EmbeddingPlane)((EmbeddingPlane)thisPlane), (HyperplaneBoundedRegion<Vector2D>)split.getPlus()) : null;
        return new Split((Object)minus, (Object)plus);
    }

    private static <T extends PlaneSubset> Split<T> getNonIntersectingSplitResult(Plane splitter, T subset) {
        Plane plane = subset.getPlane();
        double offset = splitter.offset(plane);
        int comp = plane.getPrecision().compare(offset, 0.0);
        if (comp < 0) {
            return new Split(subset, null);
        }
        if (comp > 0) {
            return new Split(null, subset);
        }
        return new Split(null, null);
    }

    static ConvexPolygon3D fromConvexPlanarVertices(Plane plane, List<Vector3D> vertices) {
        int size = vertices.size();
        if (size == 3) {
            return new SimpleTriangle3D(plane, vertices.get(0), vertices.get(1), vertices.get(2));
        }
        return new VertexListConvexPolygon3D(plane, vertices);
    }

    static List<Triangle3D> convexPolygonToTriangleFan(Plane plane, List<Vector3D> vertices) {
        return EuclideanUtils.convexPolygonToTriangleFan(vertices, (List<Vector3D> tri) -> new SimpleTriangle3D(plane, (Vector3D)tri.get(0), (Vector3D)tri.get(1), (Vector3D)tri.get(2)));
    }

    private static final class PlaneRegionExtruder {
        private final EmbeddingPlane basePlane;
        private final Vector3D extrusionVector;
        private final boolean extrudingOnPlusSide;
        private final Precision.DoubleEquivalence precision;

        PlaneRegionExtruder(EmbeddingPlane basePlane, Vector3D extrusionVector, Precision.DoubleEquivalence precision) {
            this.basePlane = basePlane;
            EmbeddingPlane extrudedPlane = basePlane.translate(extrusionVector);
            if (basePlane.contains(extrudedPlane)) {
                throw new IllegalArgumentException("Extrusion vector produces regions of zero size: extrusionVector= " + extrusionVector + ",  plane= " + (Object)((Object)basePlane));
            }
            this.extrusionVector = extrusionVector;
            this.extrudingOnPlusSide = basePlane.getNormal().dot(extrusionVector) > 0.0;
            this.precision = precision;
        }

        public List<PlaneConvexSubset> extrude(RegionBSPTree2D subspaceRegion) {
            ArrayList<PlaneConvexSubset> extrudedBoundaries = new ArrayList<PlaneConvexSubset>();
            this.addEnds(subspaceRegion, extrudedBoundaries);
            this.addSides(subspaceRegion, extrudedBoundaries);
            return extrudedBoundaries;
        }

        private void addEnds(RegionBSPTree2D subspaceRegion, List<? super PlaneConvexSubset> result) {
            List<ConvexArea> baseAreas = subspaceRegion.toConvex();
            ArrayList<PlaneConvexSubset> baseList = new ArrayList<PlaneConvexSubset>(baseAreas.size());
            ArrayList<PlaneConvexSubset> extrudedList = new ArrayList<PlaneConvexSubset>(baseAreas.size());
            AffineTransformMatrix3D extrudeTransform = AffineTransformMatrix3D.createTranslation(this.extrusionVector);
            for (ConvexArea area : baseAreas) {
                PlaneConvexSubset base = Planes.subsetFromConvexArea(this.basePlane, area);
                if (this.extrudingOnPlusSide) {
                    base = base.reverse();
                }
                baseList.add(base);
                extrudedList.add(base.transform(extrudeTransform).reverse());
            }
            result.addAll(baseList);
            result.addAll(extrudedList);
        }

        private void addSides(RegionBSPTree2D subspaceRegion, List<? super PlaneConvexSubset> result) {
            for (LinePath path : subspaceRegion.getBoundaryPaths()) {
                for (LineConvexSubset lineSubset : path.getElements()) {
                    Vector2D subStartPt = lineSubset.getStartPoint();
                    Vector2D subEndPt = lineSubset.getEndPoint();
                    PlaneConvexSubset boundary = subStartPt != null && subEndPt != null ? this.extrudeSideFinite(this.basePlane.toSpace(subStartPt), this.basePlane.toSpace(subEndPt)) : this.extrudeSideInfinite(lineSubset);
                    result.add(boundary);
                }
            }
        }

        private ConvexPolygon3D extrudeSideFinite(Vector3D startPt, Vector3D endPt) {
            Vector3D extrudedStartPt = startPt.add(this.extrusionVector);
            Vector3D extrudedEndPt = endPt.add(this.extrusionVector);
            List<Vector3D> vertices = this.extrudingOnPlusSide ? Arrays.asList(startPt, endPt, extrudedEndPt, extrudedStartPt) : Arrays.asList(startPt, extrudedStartPt, extrudedEndPt, endPt);
            return Planes.convexPolygonFromVertices(vertices, this.precision);
        }

        private PlaneConvexSubset extrudeSideInfinite(LineConvexSubset lineSubset) {
            Vector2D subLinePt = lineSubset.getLine().getOrigin();
            Vector2D.Unit subLineDir = lineSubset.getLine().getDirection();
            Vector3D linePt = this.basePlane.toSpace(subLinePt);
            Vector3D lineDir = linePt.vectorTo(this.basePlane.toSpace(subLinePt.add(subLineDir)));
            EmbeddingPlane sidePlane = this.extrudingOnPlusSide ? Planes.fromPointAndPlaneVectors(linePt, lineDir, this.extrusionVector, this.precision) : Planes.fromPointAndPlaneVectors(linePt, this.extrusionVector, lineDir, this.precision);
            Vector2D sideLineOrigin = sidePlane.toSubspace(linePt);
            Vector2D sideLineDir = sideLineOrigin.vectorTo(sidePlane.toSubspace(linePt.add(lineDir)));
            Vector2D extrudedSideLineOrigin = sidePlane.toSubspace(linePt.add(this.extrusionVector));
            Vector2D.Unit sideExtrusionDir = sidePlane.toSubspace(sidePlane.getOrigin().add(this.extrusionVector)).normalize();
            ArrayList<Line> lines = new ArrayList<Line>();
            if (this.extrudingOnPlusSide) {
                lines.add(Lines.fromPointAndDirection(sideLineOrigin, sideLineDir, this.precision));
                lines.add(Lines.fromPointAndDirection(extrudedSideLineOrigin, sideLineDir.negate(), this.precision));
            } else {
                lines.add(Lines.fromPointAndDirection(sideLineOrigin, sideLineDir.negate(), this.precision));
                lines.add(Lines.fromPointAndDirection(extrudedSideLineOrigin, sideLineDir, this.precision));
            }
            Vector2D startPt = lineSubset.getStartPoint();
            Vector2D endPt = lineSubset.getEndPoint();
            if (startPt != null) {
                lines.add(Lines.fromPointAndDirection(sidePlane.toSubspace(this.basePlane.toSpace(startPt)), this.extrudingOnPlusSide ? ((Vector2D)sideExtrusionDir).negate() : sideExtrusionDir, this.precision));
            } else if (endPt != null) {
                lines.add(Lines.fromPointAndDirection(sidePlane.toSubspace(this.basePlane.toSpace(endPt)), this.extrudingOnPlusSide ? sideExtrusionDir : ((Vector2D)sideExtrusionDir).negate(), this.precision));
            }
            return Planes.subsetFromConvexArea(sidePlane, ConvexArea.fromBounds(lines));
        }
    }

    private static final class PlaneBuilder {
        private final Collection<? extends Vector3D> pts;
        private final Precision.DoubleEquivalence precision;
        private Vector3D startPt;
        private Vector3D prevPt;
        private Vector3D prevVector;
        private Vector3D.Unit normal;
        private double crossSumX;
        private double crossSumY;
        private double crossSumZ;
        private boolean requireConvex;
        private List<? super Vector3D> uniqueVertexOutput;

        PlaneBuilder(Collection<? extends Vector3D> pts, Precision.DoubleEquivalence precision) {
            this.pts = pts;
            this.precision = precision;
        }

        Plane build() {
            if (this.pts.size() < 3) {
                throw this.nonPlanar();
            }
            this.pts.forEach(this::processPoint);
            return this.createPlane();
        }

        Plane buildForConvexPolygon(List<? super Vector3D> vertexOutput) {
            this.requireConvex = true;
            this.uniqueVertexOutput = vertexOutput;
            return this.build();
        }

        private void processPoint(Vector3D pt) {
            if (this.prevPt == null) {
                this.startPt = pt;
                this.prevPt = pt;
                if (this.uniqueVertexOutput != null) {
                    this.uniqueVertexOutput.add(pt);
                }
            } else if (!this.prevPt.eq(pt, this.precision)) {
                Vector3D vec = this.startPt.vectorTo(pt);
                if (this.prevVector != null) {
                    this.processCrossProduct(this.prevVector.cross(vec));
                }
                if (this.uniqueVertexOutput != null) {
                    this.uniqueVertexOutput.add(pt);
                }
                this.prevPt = pt;
                this.prevVector = vec;
            }
        }

        private void processCrossProduct(Vector3D cross) {
            this.crossSumX += cross.getX();
            this.crossSumY += cross.getY();
            this.crossSumZ += cross.getZ();
            double crossNorm = cross.norm();
            if (!this.precision.eqZero(crossNorm)) {
                if (this.normal == null) {
                    this.normal = cross.normalize();
                } else {
                    double crossDot = this.normal.dot(cross) / crossNorm;
                    if (!this.precision.eq(1.0, Math.abs(crossDot))) {
                        throw this.nonPlanar();
                    }
                    if (this.requireConvex && crossDot < 0.0) {
                        throw this.nonConvex();
                    }
                }
            }
        }

        private Plane createPlane() {
            if (this.normal == null) {
                throw this.nonPlanar();
            }
            if (this.normal.dot(Vector3D.of(this.crossSumX, this.crossSumY, this.crossSumZ)) < 0.0) {
                this.normal = this.normal.negate();
            }
            double originOffset = -this.startPt.dot(this.normal);
            return new Plane(this.normal, originOffset, this.precision);
        }

        private IllegalArgumentException nonPlanar() {
            return new IllegalArgumentException("Points do not define a plane: " + this.pts);
        }

        private IllegalArgumentException nonConvex() {
            return new IllegalArgumentException("Points do not define a convex region: " + this.pts);
        }
    }
}

