/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.trv_traffic_information;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.trixon.trv_traffic_information.road.trafficsafetycamera.v1.RESPONSE;
import se.trixon.trv_traffic_information.road.trafficsafetycamera.v1.RESULT;

public class TrafficInformation {
    private final ConcurrentHashMap<Class, Unmarshaller> mClassToUnmarshallerLocal = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class, Unmarshaller> mClassToUnmarshallerRemote = new ConcurrentHashMap();
    private final HttpClient mHttpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private String mKey = "";
    private final Railroad mRailroad = new Railroad();
    private final Road mRoad = new Road();
    private int mTimeout = 30000;
    private String mUrl = "https://api.trafikinfo.trafikverket.se/v2/data.xml";
    private final String requestTemplate = "<REQUEST>\n  <LOGIN authenticationkey=\"%s\" />\n  <QUERY%s>\n    %s\n  </QUERY>\n</REQUEST>";

    public TrafficInformation() {
    }

    public TrafficInformation(String key) {
        this.mKey = key;
    }

    public TreeMap<String, String> createQueryAttributes() {
        return new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    }

    public String getKey() {
        return this.mKey;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Railroad railroad() {
        return this.mRailroad;
    }

    public Road road() {
        return this.mRoad;
    }

    public void setKey(String key) {
        this.mKey = key;
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    private HttpResponse<String> getHttpResponse(String requestString) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(requestString)).uri(URI.create(this.mUrl)).header("Content-Type", "text/xml").timeout(Duration.ofMillis(this.mTimeout)).build();
        HttpResponse<String> response = this.mHttpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return response;
    }

    private String getRequest(TreeMap<String, String> queryAttributes, String objecttype, String schemaversion, String queryDetails) {
        if (queryAttributes == null) {
            queryAttributes = this.createQueryAttributes();
        }
        queryAttributes.putIfAbsent("objecttype", objecttype);
        queryAttributes.putIfAbsent("schemaversion", schemaversion);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : queryAttributes.entrySet()) {
            sb.append(String.format(" %s=\"%s\"", entry.getKey(), entry.getValue()));
        }
        if (queryDetails == null) {
            queryDetails = "";
        }
        return String.format("<REQUEST>\n  <LOGIN authenticationkey=\"%s\" />\n  <QUERY%s>\n    %s\n  </QUERY>\n</REQUEST>", this.mKey, sb.toString(), queryDetails);
    }

    private <T> T getResponse(Class<T> clazz, File file) throws IOException, InterruptedException, JAXBException {
        return (T)((JAXBElement)this.getUnmarshaller(clazz, this.mClassToUnmarshallerLocal).unmarshal(file)).getValue();
    }

    private <T> T getResponse(Class<T> clazz, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
        HttpResponse<String> r = this.getHttpResponse(queryDetails);
        String s = r.body();
        if (file != null) {
            Files.writeString(file.toPath(), (CharSequence)s, Charset.forName("utf-8"), new OpenOption[0]);
        }
        return (T)((JAXBElement)this.getUnmarshaller(clazz, this.mClassToUnmarshallerRemote).unmarshal((Reader)new StringReader(s))).getValue();
    }

    private Unmarshaller getUnmarshaller(Class clazz, ConcurrentHashMap<Class, Unmarshaller> classToUnmarshaller) {
        Unmarshaller unmarshaller = classToUnmarshaller.computeIfAbsent(clazz, k -> {
            try {
                return JAXBContext.newInstance((Class[])new Class[]{k}).createUnmarshaller();
            }
            catch (JAXBException ex) {
                Logger.getLogger(TrafficInformation.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        });
        return unmarshaller;
    }

    public class Railroad {
        private Railroad() {
        }

        public List<se.trixon.trv_traffic_information.railroad.railcrossing.v1_4.RESULT> getRailCrossingResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.railcrossing.v1_4.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "RailCrossing", "1.4", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.railcrossing.v1_4.RESULT> getRailCrossingResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.railcrossing.v1_4.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.reasoncode.v1.RESULT> getReasonCodeResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.reasoncode.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "ReasonCode", "1", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.reasoncode.v1.RESULT> getReasonCodeResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.reasoncode.v1.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.trainannouncement.v1_6.RESULT> getTrainAnnouncementResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.trainannouncement.v1_6.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "TrainAnnouncement", "1.6", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.trainannouncement.v1_6.RESULT> getTrainAnnouncementResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.trainannouncement.v1_6.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.trainmessage.v1_6.RESULT> getTrainMessageResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.trainmessage.v1_6.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "TrainMessage", "1.6", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.trainmessage.v1_6.RESULT> getTrainMessageResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.trainmessage.v1_6.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.trainstation.v1.RESULT> getTrainStationResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.trainstation.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "TrainStation", "1", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.railroad.trainstation.v1.RESULT> getTrainStationResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.railroad.trainstation.v1.RESPONSE.class, file).getRESULT();
        }
    }

    public class Road {
        private final Surface mSurface = new Surface();

        private Road() {
        }

        public List<se.trixon.trv_traffic_information.road.camera.v1.RESULT> getCameraResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.camera.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "Camera", "1", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.camera.v1.RESULT> getCameraResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.camera.v1.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.ferryannonuncement.v1_2.RESULT> getFerryAnnouncementResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.ferryannonuncement.v1_2.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "FerryAnnouncement", "1.2", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.ferryannonuncement.v1_2.RESULT> getFerryAnnouncementResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.ferryannonuncement.v1_2.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.ferryroute.v1_2.RESULT> getFerryRouteResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.ferryroute.v1_2.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "FerryRoute", "1.2", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.ferryroute.v1_2.RESULT> getFerryRouteResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.ferryroute.v1_2.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.icon.v1.RESULT> getIconResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.icon.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "Icon", "1", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.icon.v1.RESULT> getIconResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.icon.v1.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.parking.v1_4.RESULT> getParkingResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.parking.v1_4.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "Parking", "1.4", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.parking.v1_4.RESULT> getParkingResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.parking.v1_4.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.roadconditionoverview.v1.RESULT> getRoadConditionOverviewResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.roadconditionoverview.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "RoadConditionOverview", "1", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.roadconditionoverview.v1.RESULT> getRoadConditionOverviewResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.roadconditionoverview.v1.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.roadcondition.v1_2.RESULT> getRoadConditionResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.roadcondition.v1_2.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "RoadCondition", "1.2", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.roadcondition.v1_2.RESULT> getRoadConditionResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.roadcondition.v1_2.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.situation.v1_4.RESULT> getSituationResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.situation.v1_4.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "Situation", "1.4", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.situation.v1_4.RESULT> getSituationResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.situation.v1_4.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.trafficflow.v1_4.RESULT> getTrafficFlowResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.trafficflow.v1_4.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "TrafficFlow", "1.4", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.trafficflow.v1_4.RESULT> getTrafficFlowResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.trafficflow.v1_4.RESPONSE.class, file).getRESULT();
        }

        public List<RESULT> getTrafficSafetyCameraResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "TrafficSafetyCamera", "1", queryDetails), file).getRESULT();
        }

        public List<RESULT> getTrafficSafetyCameraResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.traveltimeroute.v1_5.RESULT> getTravelTimeRouteResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.traveltimeroute.v1_5.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "TravelTimeRoute", "1.5", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.traveltimeroute.v1_5.RESULT> getTravelTimeRouteResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.traveltimeroute.v1_5.RESPONSE.class, file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.weatherstation.v1.RESULT> getWeatherStationResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.weatherstation.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "WeatherStation", "1", queryDetails), file).getRESULT();
        }

        public List<se.trixon.trv_traffic_information.road.weatherstation.v1.RESULT> getWeatherStationResults(File file) throws IOException, InterruptedException, JAXBException {
            return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.weatherstation.v1.RESPONSE.class, file).getRESULT();
        }

        public Surface surface() {
            return this.mSurface;
        }

        public class Surface {
            private Surface() {
            }

            public List<se.trixon.trv_traffic_information.road.surface.measurementdata100.v1.RESULT> getMeasurementData100Results(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.measurementdata100.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "MeasurementData100", "1", queryDetails), file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.measurementdata100.v1.RESULT> getMeasurementData100Results(File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.measurementdata100.v1.RESPONSE.class, file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.measurementdata20.v1.RESULT> getMeasurementData20Results(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.measurementdata20.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "MeasurementData20", "1", queryDetails), file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.measurementdata20.v1.RESULT> getMeasurementData20Results(File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.measurementdata20.v1.RESPONSE.class, file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.pavementdata.v1.RESULT> getPavementDataResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.pavementdata.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "PavementData", "1", queryDetails), file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.pavementdata.v1.RESULT> getPavementDataResults(File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.pavementdata.v1.RESPONSE.class, file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.roaddata.v1.RESULT> getRoadDataResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.roaddata.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "RoadData", "1", queryDetails), file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.roaddata.v1.RESULT> getRoadDataResults(File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.roaddata.v1.RESPONSE.class, file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.roadgeometry.v1.RESULT> getRoadGeometryResults(TreeMap<String, String> queryAttributes, String queryDetails, File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.roadgeometry.v1.RESPONSE.class, TrafficInformation.this.getRequest(queryAttributes, "RoadGeometry", "1", queryDetails), file).getRESULT();
            }

            public List<se.trixon.trv_traffic_information.road.surface.roadgeometry.v1.RESULT> getRoadGeometryResults(File file) throws IOException, InterruptedException, JAXBException {
                return TrafficInformation.this.getResponse(se.trixon.trv_traffic_information.road.surface.roadgeometry.v1.RESPONSE.class, file).getRESULT();
            }
        }
    }
}

