/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelFormatter;
import de.gsi.chart.axes.AxisLabelOverlapPolicy;
import de.gsi.chart.axes.spi.AbstractAxisParameter;
import de.gsi.chart.axes.spi.AxisRange;
import de.gsi.chart.axes.spi.TickMark;
import de.gsi.chart.axes.spi.format.DefaultFormatter;
import de.gsi.chart.axes.spi.format.DefaultLogFormatter;
import de.gsi.chart.axes.spi.format.DefaultTimeFormatter;
import de.gsi.chart.ui.ResizableCanvas;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.AxisChangeEvent;
import de.gsi.dataset.event.EventSource;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.utils.SoftHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import javafx.util.StringConverter;

public abstract class AbstractAxis
extends AbstractAxisParameter
implements Axis {
    protected static final double MIN_NARROW_FONT_SCALE = 0.7;
    protected static final double MAX_NARROW_FONT_SCALE = 1.0;
    protected static final int RANGE_ANIMATION_DURATION_MS = 700;
    protected static final int BURST_LIMIT_CSS_MS = 3000;
    private long lastCssUpdate;
    private boolean callCssUpdater;
    private final transient Canvas canvas = new ResizableCanvas();
    protected boolean labelOverlap;
    protected double scaleFont = 1.0;
    protected final ReentrantLock lock = new ReentrantLock();
    protected double maxLabelHeight;
    protected double maxLabelWidth;
    private final transient ObjectProperty<AxisLabelFormatter> axisFormatter = new SimpleObjectProperty<AxisLabelFormatter>((Object)this, "axisLabelFormatter", null){
        private final AxisLabelFormatter defaultFormatter;
        private final AxisLabelFormatter defaultLogFormatter;
        private final AxisLabelFormatter defaultTimeFormatter;
        private final AxisLabelFormatter defaultLogTimeFormatter;
        {
            this.defaultFormatter = new DefaultFormatter(AbstractAxis.this);
            this.defaultLogFormatter = new DefaultLogFormatter(AbstractAxis.this);
            this.defaultTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
            this.defaultLogTimeFormatter = new DefaultTimeFormatter(AbstractAxis.this);
        }

        public AxisLabelFormatter get() {
            AxisLabelFormatter superImpl = (AxisLabelFormatter)super.get();
            if (superImpl != null) {
                return superImpl;
            }
            if (AbstractAxis.this.isTimeAxis()) {
                if (AbstractAxis.this.isLogAxis()) {
                    return this.defaultLogTimeFormatter;
                }
                return this.defaultTimeFormatter;
            }
            if (AbstractAxis.this.isLogAxis()) {
                return this.defaultLogFormatter;
            }
            return this.defaultFormatter;
        }

        protected void invalidated() {
            AbstractAxis.this.invalidateCaches();
            AbstractAxis.this.invalidate();
            AbstractAxis.this.requestAxisLayout();
        }
    };
    protected final transient Map<String, TickMark> tickMarkStringCache = new SoftHashMap(20);
    protected final transient Map<Double, TickMark> tickMarkDoubleCache = new SoftHashMap(200);

    protected AbstractAxis() {
        this.setMouseTransparent(false);
        this.setPickOnBounds(true);
        this.canvas.setMouseTransparent(false);
        this.canvas.toFront();
        if (!this.canvas.isCache()) {
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
        }
        this.getChildren().add((Object)this.canvas);
        ChangeListener axisSizeChangeListener = (c, o, n) -> {
            double padding = this.getAxisPadding();
            if (this.getSide().isHorizontal()) {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight());
                this.canvas.setLayoutX(-padding);
            } else {
                this.canvas.resize(this.getWidth(), this.getHeight() + 2.0 * padding);
                this.canvas.setLayoutY(-padding);
            }
            this.invalidate();
            this.requestLayout();
        };
        this.axisPaddingProperty().addListener((ch, o, n) -> {
            double padding = this.getAxisPadding();
            if (this.getSide().isHorizontal()) {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight());
                this.canvas.setLayoutX(-padding);
            } else {
                this.canvas.resize(this.getWidth() + 2.0 * padding, this.getHeight() + 2.0 * padding);
                this.canvas.setLayoutY(-padding);
            }
        });
        this.widthProperty().addListener(axisSizeChangeListener);
        this.heightProperty().addListener(axisSizeChangeListener);
        this.sideProperty().addListener((ch, o, n) -> {
            switch (n) {
                case CENTER_VER: 
                case CENTER_HOR: {
                    this.getAxisLabel().setTextAlignment(TextAlignment.RIGHT);
                    break;
                }
                default: {
                    this.getAxisLabel().setTextAlignment(TextAlignment.CENTER);
                }
            }
        });
        this.invertAxisProperty().addListener((ch, o, n) -> Platform.runLater(() -> {
            this.invalidateCaches();
            this.forceRedraw();
        }));
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
    }

    protected AbstractAxis(double lowerBound, double upperBound) {
        this();
        this.set(lowerBound, upperBound);
        this.setAutoRanging(false);
    }

    public ObjectProperty<AxisLabelFormatter> axisLabelFormatterProperty() {
        return this.axisFormatter;
    }

    public abstract double computePreferredTickUnit(double var1);

    @Override
    public void drawAxis(GraphicsContext gc, double axisWidth, double axisHeight) {
        double axisLength;
        if (gc == null || this.getSide() == null) {
            return;
        }
        this.drawAxisPre();
        this.updateCSS();
        double d = axisLength = this.getSide().isHorizontal() ? axisWidth : axisHeight;
        if (!this.isTickMarkVisible()) {
            this.drawAxisLabel(gc, axisWidth, axisHeight, this.getAxisLabel(), null, this.getTickLength());
            this.drawAxisLine(gc, axisLength, axisWidth, axisHeight);
            this.drawAxisPost();
            return;
        }
        ObservableList<TickMark> majorTicks = this.getTickMarks();
        ObservableList<TickMark> minorTicks = this.getMinorTickMarks();
        double neededLength = (double)(this.getTickMarks().size() + minorTicks.size()) * 2.0;
        if (this.isMinorTickVisible() && axisLength > neededLength) {
            this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, minorTicks, this.getMinorTickLength(), this.getMinorTickStyle());
            this.drawTickLabels(gc, axisWidth, axisHeight, minorTicks, this.getMinorTickLength());
        }
        this.drawTickMarks(gc, axisLength, axisWidth, axisHeight, majorTicks, this.getTickLength(), this.getMajorTickStyle());
        this.drawTickLabels(gc, axisWidth, axisHeight, majorTicks, this.getTickLength());
        this.drawAxisLabel(gc, axisWidth, axisHeight, this.getAxisLabel(), majorTicks, this.getTickLength());
        this.drawAxisLine(gc, axisLength, axisWidth, axisHeight);
        this.drawAxisPost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireInvalidated() {
        AtomicBoolean atomicBoolean = this.autoNotification();
        synchronized (atomicBoolean) {
            if (!this.autoNotification().get() || this.updateEventListener().isEmpty()) {
                return;
            }
        }
        if (Platform.isFxApplicationThread()) {
            this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this), false);
        } else {
            Platform.runLater(() -> this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this), false));
        }
    }

    @Override
    public void forceRedraw() {
        this.invalidateCaches();
        this.recomputeTickMarks();
        this.invalidate();
        this.layoutChildren();
    }

    public AxisLabelFormatter getAxisLabelFormatter() {
        return (AxisLabelFormatter)this.axisFormatter.get();
    }

    @Override
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Override
    public double getDisplayPosition(double value) {
        return this.cachedOffset + (value - this.getMin()) * this.getScale();
    }

    public GraphicsContext getGraphicsContext() {
        return this.canvas.getGraphicsContext2D();
    }

    public TickMark getNewTickMark(Double tickValue, double tickPosition, String tickMarkLabel) {
        TickMark tick;
        if (tickMarkLabel.isEmpty()) {
            tick = this.tickMarkDoubleCache.computeIfAbsent(tickValue, k -> new TickMark(this.getSide(), tickValue, tickPosition, this.getTickLabelRotation(), ""));
        } else {
            tick = this.tickMarkStringCache.computeIfAbsent(tickMarkLabel, k -> new TickMark(this.getSide(), tickValue, tickPosition, this.getTickLabelRotation(), (String)k));
            tick.setValue(tickValue);
        }
        tick.setFill(this.getTickLabelFill());
        tick.setFont(this.getTickLabelFont());
        tick.setPosition(tickPosition);
        tick.setVisible(true);
        return tick;
    }

    @Override
    public String getTickMarkLabel(double value) {
        double scaledValue = value / this.getUnitScaling();
        StringConverter<Number> formatter = this.getTickLabelFormatter();
        if (formatter != null) {
            return formatter.toString((Object)scaledValue);
        }
        return this.getAxisLabelFormatter().toString(scaledValue);
    }

    @Override
    public double getZeroPosition() {
        if (0.0 < this.getMin() || 0.0 > this.getMax()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    public void invalidateCaches() {
        this.getTickMarkValues().clear();
        this.getMinorTickMarkValues().clear();
        this.getTickMarks().clear();
        this.getMinorTickMarks().clear();
        this.tickMarkStringCache.clear();
        this.tickMarkDoubleCache.clear();
    }

    @Override
    public void invalidateRange(List<Number> data) {
        boolean oldState = this.autoNotification().getAndSet(false);
        AxisRange autoRange = this.autoRange(this.getLength());
        if (this.set(autoRange.getMin(), autoRange.getMax())) {
            this.getAutoRange().setAxisLength(this.getLength() == 0.0 ? 1.0 : this.getLength(), this.getSide());
            this.setScale(this.calculateNewScale(this.getLength(), autoRange.getMin(), autoRange.getMax()));
            this.updateAxisLabelAndUnit();
            this.updateCachedVariables();
            this.invalidate();
        }
        this.autoNotification().set(oldState);
        this.invokeListener((UpdateEvent)new AxisChangeEvent((EventSource)this));
    }

    public boolean isLabelOverlapping() {
        return this.labelOverlap;
    }

    @Override
    public boolean isValueOnAxis(double value) {
        return Double.isFinite(value) && value >= this.getMin() && value <= this.getMax();
    }

    public void recomputeTickMarks() {
        double axisLength = this.getSide().isVertical() ? this.getHeight() : this.getWidth();
        AxisRange newAxisRange = this.getRange();
        double mTickUnit = this.computePreferredTickUnit(axisLength);
        if (this.getRange().getMin() != this.getMin() || this.getRange().getMax() != this.getMax()) {
            this.set(this.getRange().getMin(), this.getRange().getMax());
        }
        newAxisRange.tickUnit = mTickUnit;
        this.setTickUnit(mTickUnit);
        newAxisRange.tickUnit = this.getTickUnit();
        this.updateAxisLabelAndUnit();
        this.recomputeTickMarks(newAxisRange);
    }

    @Override
    public AxisRange getRange() {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            return this.autoRange(this.getLength());
        }
        return this.getUserRange();
    }

    @Override
    public void requestAxisLayout() {
        super.requestLayout();
    }

    public void setAxisLabelFormatter(AxisLabelFormatter value) {
        this.axisFormatter.set((Object)value);
    }

    @Override
    public boolean setMax(double value) {
        if (this.isLogAxis() && (value <= 0.0 || !Double.isFinite(value))) {
            if (this.getMin() >= 0.0) {
                return super.setMax(this.getMin() * 1000000.0);
            }
            return false;
        }
        return super.setMax(value);
    }

    @Override
    public boolean setMin(double value) {
        if (this.isLogAxis() && (value <= 0.0 || !Double.isFinite(value))) {
            if (this.getMax() > 0.0) {
                return super.setMin(this.getMax() / 1000000.0);
            }
            return false;
        }
        return super.setMin(value);
    }

    protected AxisRange autoRange(double length) {
        if (this.isAutoRanging() || this.isAutoGrowRanging()) {
            double labelSize = this.getTickLabelFont().getSize() * 1.2;
            return this.autoRange(this.getAutoRange().getMin(), this.getAutoRange().getMax(), length, labelSize);
        }
        return this.getRange();
    }

    protected abstract AxisRange autoRange(double var1, double var3, double var5, double var7);

    protected abstract List<Double> calculateMajorTickValues(double var1, AxisRange var3);

    protected abstract List<Double> calculateMinorTickValues();

    protected double calculateNewScale(double length, double lowerBound, double upperBound) {
        Side side = this.getSide();
        double diff = upperBound - lowerBound;
        double newScale = side.isVertical() ? (diff == 0.0 ? -length : -(length / diff)) : (upperBound - lowerBound == 0.0 ? length : length / diff);
        return newScale == 0.0 ? -1.0 : newScale;
    }

    protected void clearAxisCanvas(GraphicsContext gc, double width, double height) {
        gc.clearRect(0.0, 0.0, width, height);
    }

    protected double computePrefHeight(double width) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_HOR || side.isVertical()) {
            return 150.0;
        }
        if (this.getTickMarks().isEmpty()) {
            AxisRange range = this.autoRange(width);
            this.computeTickMarks(range, true);
            this.invalidate();
        }
        double maxLabelHeightLocal = this.isTickLabelsVisible() ? this.maxLabelHeight : 0.0;
        double tickMarkLength = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        Text axisLabel = this.getAxisLabel();
        String axisLabelText = axisLabel.getText();
        double labelHeight = axisLabelText == null || axisLabelText.isEmpty() ? 0.0 : axisLabel.prefHeight(-1.0) + 2.0 * this.getAxisLabelGap();
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? labelHeight : 0.0;
        return tickMarkLength + maxLabelHeightLocal + labelHeight + shiftedLabels;
    }

    protected double computePrefWidth(double height) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_VER || side.isHorizontal()) {
            return 150.0;
        }
        if (this.getTickMarks().isEmpty()) {
            AxisRange range = this.autoRange(height);
            this.computeTickMarks(range, true);
            this.invalidate();
        }
        double maxLabelWidthLocal = this.isTickLabelsVisible() ? this.maxLabelWidth : 0.0;
        double tickMarkLength = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        Text axisLabel = this.getAxisLabel();
        String axisLabelText = axisLabel.getText();
        double labelHeight = axisLabelText == null || axisLabelText.isEmpty() ? 0.0 : axisLabel.prefHeight(-1.0) + 2.0 * this.getAxisLabelGap();
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? labelHeight : 0.0;
        return maxLabelWidthLocal + tickMarkLength + labelHeight + shiftedLabels;
    }

    protected abstract AxisRange computeRange(double var1, double var3, double var5, double var7);

    protected List<TickMark> computeTickMarks(AxisRange range, boolean majorTickMark) {
        List<Double> newTickValues;
        ObservableList<TickMark> oldTickMarks;
        Side side = this.getSide();
        ObservableList<TickMark> observableList = oldTickMarks = majorTickMark ? this.getTickMarks() : this.getMinorTickMarks();
        if (side == null) {
            return oldTickMarks;
        }
        double width = this.getWidth();
        double height = this.getHeight();
        double axisLength = side.isVertical() ? height : width;
        ObservableList<Double> oldTickValues = majorTickMark ? this.getTickMarkValues() : this.getMinorTickMarkValues();
        List<Double> list = newTickValues = majorTickMark ? this.calculateMajorTickValues(axisLength, range) : this.calculateMinorTickValues();
        if (!oldTickValues.isEmpty() && !oldTickMarks.isEmpty() && newTickValues.equals(oldTickValues)) {
            return oldTickMarks;
        }
        if (majorTickMark) {
            this.getAxisLabelFormatter().updateFormatter(newTickValues, this.getUnitScaling());
        }
        if (newTickValues.size() > 2) {
            if (majorTickMark) {
                this.getTickMarkValues().setAll(newTickValues);
            } else {
                this.getMinorTickMarkValues().setAll(newTickValues);
            }
        }
        if (majorTickMark) {
            this.maxLabelHeight = 0.0;
            this.maxLabelWidth = 0.0;
        }
        LinkedList<TickMark> newTickMarkList = new LinkedList<TickMark>();
        newTickValues.forEach(tickValue -> {
            double tickPosition = this.getDisplayPosition((double)tickValue);
            String tickMarkLabel = majorTickMark ? this.getTickMarkLabel((double)tickValue) : "";
            TickMark tick = this.getNewTickMark((Double)tickValue, tickPosition, tickMarkLabel);
            newTickMarkList.add(tick);
            this.maxLabelHeight = Math.max(this.maxLabelHeight, tick.getHeight());
            this.maxLabelWidth = Math.max(this.maxLabelWidth, tick.getWidth());
            if (majorTickMark && this.shouldAnimate()) {
                tick.setOpacity(0.0);
                FadeTransition ft = new FadeTransition(Duration.millis((double)750.0), (Node)tick);
                tick.opacityProperty().addListener((ch, o, n) -> {
                    this.clearAxisCanvas(this.canvas.getGraphicsContext2D(), width, height);
                    this.drawAxis(this.canvas.getGraphicsContext2D(), width, height);
                });
                ft.setFromValue(0.0);
                ft.setToValue(1.0);
                ft.play();
            }
        });
        return newTickMarkList;
    }

    protected void drawAxisLabel(GraphicsContext gc, double axisWidth, double axisHeight, Text axisName, ObservableList<TickMark> tickMarks, double tickLength) {
        double y;
        double x;
        double labelGap;
        double labelPosition;
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        boolean isHorizontal = this.getSide().isHorizontal();
        double tickLabelGap = this.getTickLabelGap();
        double axisLabelGap = this.getAxisLabelGap();
        double axisCentre = this.getAxisCenterPosition();
        switch (axisName.getTextAlignment()) {
            case LEFT: {
                labelPosition = 0.0;
                labelGap = tickLabelGap;
                break;
            }
            case RIGHT: {
                labelPosition = 1.0;
                labelGap = -tickLabelGap;
                break;
            }
            default: {
                labelPosition = 0.5;
                labelGap = 0.0;
            }
        }
        double tickLabelSize = isHorizontal ? this.maxLabelHeight : this.maxLabelWidth;
        double shiftedLabels = this.getOverlapPolicy() == AxisLabelOverlapPolicy.SHIFT_ALT && this.isLabelOverlapping() || this.getOverlapPolicy() == AxisLabelOverlapPolicy.FORCED_SHIFT_ALT ? tickLabelSize + tickLabelGap : 0.0;
        gc.save();
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                gc.setTextBaseline(VPos.BASELINE);
                x = axisWidth - tickLength - 2.0 * tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                y = (1.0 - labelPosition) * axisHeight - labelGap;
                axisName.setRotate(-90.0);
                break;
            }
            case RIGHT: {
                gc.setTextBaseline(VPos.TOP);
                axisName.setRotate(-90.0);
                x = tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                y = (1.0 - labelPosition) * axisHeight - labelGap;
                break;
            }
            case TOP: {
                gc.setTextBaseline(VPos.BOTTOM);
                x = labelPosition * axisWidth + labelGap;
                y = axisHeight - tickLength - tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                break;
            }
            case BOTTOM: {
                gc.setTextBaseline(VPos.TOP);
                x = labelPosition * axisWidth + labelGap;
                y = tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                break;
            }
            case CENTER_VER: {
                gc.setTextBaseline(VPos.TOP);
                axisName.setRotate(-90.0);
                x = axisCentre * axisWidth - tickLength - 2.0 * tickLabelGap - tickLabelSize - axisLabelGap - shiftedLabels;
                y = (1.0 - labelPosition) * axisHeight - labelGap;
                break;
            }
            case CENTER_HOR: {
                gc.setTextBaseline(VPos.TOP);
                x = labelPosition * axisWidth + labelGap;
                y = axisCentre * axisHeight + tickLength + tickLabelGap + tickLabelSize + axisLabelGap + shiftedLabels;
                break;
            }
            default: {
                throw new IllegalStateException("unknown axis side " + this.getSide());
            }
        }
        AbstractAxis.drawAxisLabel(gc, x, y, axisName);
        gc.restore();
    }

    protected void drawAxisLine(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight) {
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getAxisCenterPosition();
        Path tickStyle = this.getMajorTickStyle();
        gc.save();
        gc.setStroke(tickStyle.getStroke());
        gc.setFill(tickStyle.getFill());
        gc.setLineWidth(tickStyle.getStrokeWidth());
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                gc.strokeLine(AbstractAxis.snap(axisWidth) - 1.0, AbstractAxis.snap(0.0), AbstractAxis.snap(axisWidth) - 1.0, AbstractAxis.snap(axisLength));
                break;
            }
            case RIGHT: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(axisLength));
                break;
            }
            case TOP: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(axisHeight) - 1.0, AbstractAxis.snap(axisLength), AbstractAxis.snap(axisHeight) - 1.0);
                break;
            }
            case BOTTOM: {
                gc.strokeLine(AbstractAxis.snap(0.0), AbstractAxis.snap(0.0), AbstractAxis.snap(axisLength), AbstractAxis.snap(0.0));
                break;
            }
            case CENTER_HOR: {
                gc.strokeLine(AbstractAxis.snap(0.0), axisCentre * axisHeight, AbstractAxis.snap(axisLength), AbstractAxis.snap(axisCentre * axisHeight));
                break;
            }
            case CENTER_VER: {
                gc.strokeLine(AbstractAxis.snap(axisCentre * axisWidth), AbstractAxis.snap(0.0), AbstractAxis.snap(axisCentre * axisWidth), AbstractAxis.snap(axisLength));
                break;
            }
        }
        gc.restore();
    }

    protected void drawAxisPost() {
    }

    protected void drawAxisPre() {
    }

    protected void drawTickLabels(GraphicsContext gc, double axisWidth, double axisHeight, ObservableList<TickMark> tickMarks, double tickLength) {
        if (tickLength <= 0.0 || tickMarks.isEmpty()) {
            return;
        }
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getAxisCenterPosition();
        AxisLabelOverlapPolicy overlapPolicy = this.getOverlapPolicy();
        double tickLabelGap = this.getTickLabelGap();
        gc.save();
        gc.translate(paddingX, paddingY);
        TickMark firstTick = (TickMark)((Object)tickMarks.get(0));
        gc.setGlobalAlpha(firstTick.getOpacity());
        int counter = (int)firstTick.getValue() % 2;
        switch (this.getSide()) {
            case LEFT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = axisWidth - tickLength - tickLabelGap;
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, x, position, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                x -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, x, position, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, x -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), position, this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, x, position, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
            case RIGHT: 
            case CENTER_VER: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double x = tickLength + tickLabelGap;
                    if (this.getSide().equals((Object)Side.CENTER_VER)) {
                        x += axisCentre * axisWidth;
                    }
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, x, position, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                x += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, x, position, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, x += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), position, this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, x, position, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
            case TOP: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double y = axisHeight - tickLength - tickLabelGap;
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, position, y, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                y -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, position, y, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, position, y -= (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, position, y, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
            case BOTTOM: 
            case CENTER_HOR: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (!tickMark.isVisible()) continue;
                    double y = tickLength + tickLabelGap;
                    if (this.getSide().equals((Object)Side.CENTER_HOR)) {
                        y += axisCentre * axisHeight;
                    }
                    switch (overlapPolicy) {
                        case DO_NOTHING: {
                            AbstractAxis.drawTickMarkLabel(gc, position, y, this.scaleFont, tickMark);
                            break;
                        }
                        case SHIFT_ALT: {
                            if (this.isLabelOverlapping()) {
                                y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize();
                            }
                            AbstractAxis.drawTickMarkLabel(gc, position, y, this.scaleFont, tickMark);
                            break;
                        }
                        case FORCED_SHIFT_ALT: {
                            AbstractAxis.drawTickMarkLabel(gc, position, y += (double)(counter % 2) * tickLabelGap + (double)(counter % 2) * tickMark.getFont().getSize(), this.scaleFont, tickMark);
                            break;
                        }
                        default: {
                            if (counter % 2 != 0 && this.isLabelOverlapping() && !(this.scaleFont < 1.0)) break;
                            AbstractAxis.drawTickMarkLabel(gc, position, y, this.scaleFont, tickMark);
                        }
                    }
                    ++counter;
                }
                break;
            }
        }
        gc.restore();
    }

    protected void drawTickMarks(GraphicsContext gc, double axisLength, double axisWidth, double axisHeight, ObservableList<TickMark> tickMarks, double tickLength, Path tickStyle) {
        if (tickLength <= 0.0) {
            return;
        }
        double paddingX = this.getSide().isHorizontal() ? this.getAxisPadding() : 0.0;
        double paddingY = this.getSide().isVertical() ? this.getAxisPadding() : 0.0;
        double axisCentre = this.getAxisCenterPosition();
        gc.save();
        gc.setStroke(tickStyle.getStroke());
        gc.setFill(tickStyle.getFill());
        gc.setLineWidth(tickStyle.getStrokeWidth());
        gc.translate(paddingX, paddingY);
        switch (this.getSide()) {
            case LEFT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(axisWidth - tickLength);
                    double x1 = AbstractAxis.snap(axisWidth);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
            case RIGHT: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(0.0);
                    double x1 = AbstractAxis.snap(tickLength);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
            case TOP: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(axisHeight);
                    double y1 = AbstractAxis.snap(axisHeight - tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case BOTTOM: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(0.0);
                    double y1 = AbstractAxis.snap(tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case CENTER_HOR: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x = AbstractAxis.snap(position);
                    double y0 = AbstractAxis.snap(axisCentre * axisHeight - tickLength);
                    double y1 = AbstractAxis.snap(axisCentre * axisHeight + tickLength);
                    gc.strokeLine(x, y0, x, y1);
                }
                break;
            }
            case CENTER_VER: {
                for (TickMark tickMark : tickMarks) {
                    double position = tickMark.getPosition();
                    if (position < 0.0 || position > axisLength) continue;
                    double x0 = AbstractAxis.snap(axisCentre * axisWidth - tickLength);
                    double x1 = AbstractAxis.snap(axisCentre * axisWidth + tickLength);
                    double y = AbstractAxis.snap(position);
                    gc.strokeLine(x0, y, x1, y);
                }
                break;
            }
        }
        gc.restore();
    }

    protected void layoutChildren() {
        if (this.isValid() && !super.isNeedsLayout()) {
            super.layoutChildren();
            return;
        }
        Side side = this.getSide();
        if (side == null) {
            return;
        }
        double axisWidth = this.getWidth();
        double axisHeight = this.getHeight();
        double axisLength = side.isVertical() ? axisHeight : axisWidth;
        double preferredTickUnit = this.computePreferredTickUnit(axisLength);
        boolean tickUnitDiffers = this.getTickUnit() != preferredTickUnit;
        boolean lengthDiffers = this.oldAxisLength != axisLength;
        boolean rangeDiffers = this.oldAxisMin != this.getMin() || this.oldAxisMax != this.getMax() || this.oldTickUnit != this.getTickUnit();
        boolean recomputedTicks = false;
        if (lengthDiffers || rangeDiffers || tickUnitDiffers) {
            recomputedTicks = true;
            this.recomputeTickMarks();
            this.oldAxisLength = axisLength;
            this.oldAxisMin = this.getMin();
            this.oldAxisMax = this.getMax();
            this.oldTickUnit = this.getTickUnit();
            this.updateCachedVariables();
            this.getTickMarks().forEach(mark -> {
                mark.setPosition(this.getDisplayPosition(mark.getValue()));
                mark.setVisible(true);
            });
            this.getMinorTickMarks().forEach(mark -> {
                mark.setPosition(this.getDisplayPosition(mark.getValue()));
                mark.setVisible(true);
            });
            double totalLabelsSize = 0.0;
            double maxLabelSize = 0.0;
            for (TickMark m : this.getTickMarks()) {
                double tickSize = (side.isHorizontal() ? m.getWidth() : m.getHeight()) + 2.0 * this.getTickLabelSpacing();
                totalLabelsSize += tickSize;
                maxLabelSize = Math.round(Math.max(maxLabelSize, tickSize));
            }
            this.labelOverlap = false;
            double projectedLengthFromIndividualMarks = (double)(this.majorTickMarks.size() + 1) * maxLabelSize;
            switch (this.getOverlapPolicy()) {
                case NARROW_FONT: {
                    double scale = axisLength / projectedLengthFromIndividualMarks;
                    if (scale >= 0.7 && scale <= 1.0) {
                        this.scaleFont = scale;
                        break;
                    }
                    this.scaleFont = Math.min(Math.max(scale, 0.7), 1.0);
                }
                case SKIP_ALT: {
                    int numLabelsToSkip = 0;
                    if (maxLabelSize > 0.0 && axisLength < totalLabelsSize) {
                        numLabelsToSkip = (int)(projectedLengthFromIndividualMarks / axisLength);
                        this.labelOverlap = true;
                    }
                    if (numLabelsToSkip <= 0) break;
                    int tickIndex = 0;
                    for (TickMark m : this.majorTickMarks) {
                        if (!m.isVisible()) continue;
                        m.setVisible(tickIndex++ % numLabelsToSkip == 0);
                    }
                    break;
                }
            }
            switch (this.getOverlapPolicy()) {
                case SHIFT_ALT: {
                    this.labelOverlap = AbstractAxis.checkOverlappingLabels(0, 1, (ObservableList<TickMark>)this.majorTickMarks, this.getSide(), this.getTickLabelGap(), this.isInvertedAxis(), false);
                    if (!this.labelOverlap) break;
                }
                case FORCED_SHIFT_ALT: {
                    this.labelOverlap = true;
                    AbstractAxis.checkOverlappingLabels(0, 2, (ObservableList<TickMark>)this.majorTickMarks, this.getSide(), this.getTickLabelGap(), this.isInvertedAxis(), true);
                    AbstractAxis.checkOverlappingLabels(1, 2, (ObservableList<TickMark>)this.majorTickMarks, this.getSide(), this.getTickLabelGap(), this.isInvertedAxis(), true);
                    break;
                }
                default: {
                    AbstractAxis.checkOverlappingLabels(0, 1, (ObservableList<TickMark>)this.majorTickMarks, this.getSide(), this.getTickLabelGap(), this.isInvertedAxis(), true);
                }
            }
            this.tickMarksUpdated();
        }
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        this.clearAxisCanvas(gc, this.canvas.getWidth(), this.canvas.getHeight());
        this.drawAxis(gc, axisWidth, axisHeight);
        if (recomputedTicks) {
            this.fireInvalidated();
        }
        super.layoutChildren();
        this.validProperty().set(true);
    }

    private static boolean checkOverlappingLabels(int start, int stride, ObservableList<TickMark> majorTickMarks, Side side, double gap, boolean isInverted, boolean makeInvisible) {
        boolean labelHidden = false;
        TickMark lastVisible = null;
        for (int i = start; i < majorTickMarks.size(); i += stride) {
            TickMark current = (TickMark)((Object)majorTickMarks.get(i));
            if (!current.isVisible()) continue;
            if (lastVisible == null || !AbstractAxis.isTickLabelsOverlap(side, isInverted, lastVisible, current, gap)) {
                lastVisible = current;
                continue;
            }
            labelHidden = true;
            current.setVisible(!makeInvisible);
        }
        return labelHidden;
    }

    protected double measureTickMarkLength(Double major) {
        TickMark tick = this.getNewTickMark(major, 0.0, this.getTickMarkLabel(major));
        return this.getSide().isHorizontal() ? tick.getWidth() : tick.getHeight();
    }

    protected void recomputeTickMarks(AxisRange range) {
        if (this.getSide() == null) {
            return;
        }
        if (this.isTickMarkVisible() && this.isTickLabelsVisible()) {
            List<TickMark> majorTicks = this.computeTickMarks(range, true);
            if (!this.getTickMarks().equals(majorTicks) && !majorTicks.isEmpty()) {
                this.getTickMarks().setAll(majorTicks);
            }
        } else if (!this.getTickMarks().isEmpty()) {
            this.getTickMarks().clear();
        }
        if (this.isTickMarkVisible() && this.isMinorTickVisible()) {
            List<TickMark> minorTicks = this.computeTickMarks(range, false);
            if (!this.getMinorTickMarks().equals(minorTicks) && !minorTicks.isEmpty()) {
                this.getMinorTickMarks().setAll(minorTicks);
            }
        } else if (!this.getMinorTickMarks().isEmpty()) {
            this.getMinorTickMarks().clear();
        }
    }

    protected boolean shouldAnimate() {
        return this.isAnimated() && this.getScene() != null;
    }

    protected void tickMarksUpdated() {
    }

    protected void updateCSS() {
        long now = System.nanoTime();
        double diffMillisSinceLastUpdate = TimeUnit.NANOSECONDS.toMillis(now - this.lastCssUpdate);
        if (diffMillisSinceLastUpdate < 3000.0) {
            if (!this.callCssUpdater) {
                this.callCssUpdater = true;
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)20.0), e -> this.requestLayout(), new KeyValue[0]);
                Timeline timeline = new Timeline(new KeyFrame[]{kf1});
                Platform.runLater(() -> ((Timeline)timeline).play());
            }
            return;
        }
        this.lastCssUpdate = now;
        this.callCssUpdater = false;
        this.getMajorTickStyle().applyCss();
        this.getMinorTickStyle().applyCss();
        this.getAxisLabel().applyCss();
    }

    private static boolean isTickLabelsOverlap(Side side, boolean isInverted, TickMark m1, TickMark m2, double gap) {
        double m1Size = side.isHorizontal() ? m1.getWidth() : m1.getHeight();
        double m2Size = side.isHorizontal() ? m2.getWidth() : m2.getHeight();
        double m1Start = m1.getPosition() - m1Size / 2.0;
        double m1End = m1.getPosition() + m1Size / 2.0;
        double m2Start = m2.getPosition() - m2Size / 2.0;
        double m2End = m2.getPosition() + m2Size / 2.0;
        return side.isVertical() && !isInverted ? Math.abs(m1Start - m2End) <= gap : Math.abs(m2Start - m1End) <= gap;
    }

    protected static void drawAxisLabel(GraphicsContext gc, double x, double y, Text label) {
        gc.save();
        gc.setTextAlign(label.getTextAlignment());
        gc.setFont(label.getFont());
        gc.setFill(label.getFill());
        gc.setStroke(label.getStroke());
        gc.setLineWidth(label.getStrokeWidth());
        gc.translate(x, y);
        gc.rotate(label.getRotate());
        gc.fillText(label.getText(), 0.0, 0.0);
        gc.restore();
    }

    protected static void drawTickMarkLabel(GraphicsContext gc, double x, double y, double scaleFont, TickMark tickMark) {
        gc.save();
        gc.setFont(tickMark.getFont());
        gc.setFill(tickMark.getFill());
        gc.setTextAlign(tickMark.getTextAlignment());
        gc.setTextBaseline(tickMark.getTextOrigin());
        gc.translate(x, y);
        if (tickMark.getRotate() != 0.0) {
            gc.rotate(tickMark.getRotate());
        }
        gc.setGlobalAlpha(tickMark.getOpacity());
        if (scaleFont != 1.0) {
            gc.scale(scaleFont, 1.0);
        }
        gc.fillText(tickMark.getText(), 0.0, 0.0);
        gc.restore();
    }

    protected static double snap(double coordinate) {
        return (double)Math.round(coordinate) + 0.5;
    }
}

