/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi;

import de.gsi.chart.ui.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class TickMark
extends Text {
    private final Side side;
    private double tickValue;
    private double tickPosition;
    private double tickRotation;

    public TickMark(Side side, double tickValue, double tickPosition, double tickRotation, String tickMarkLabel) {
        this.side = side;
        this.tickValue = tickValue;
        this.tickPosition = tickPosition;
        this.tickRotation = tickRotation;
        this.setText(tickMarkLabel);
        this.setRotate(tickRotation);
        this.recomputeAlignment();
        this.fontProperty().addListener((ch, o, n) -> this.applyCss());
        this.fillProperty().addListener((ch, o, n) -> this.applyCss());
        this.visibleProperty().addListener((ch, o, n) -> this.applyCss());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TickMark)) {
            return false;
        }
        TickMark other = (TickMark)((Object)obj);
        return this.tickPosition == other.tickPosition && this.tickRotation == other.tickRotation && this.tickValue == other.tickValue;
    }

    public double getHeight() {
        return this.getBoundsInParent().getHeight();
    }

    public double getPosition() {
        return this.tickPosition;
    }

    public double getRotation() {
        return this.tickRotation;
    }

    public Side getSide() {
        return this.side;
    }

    public double getValue() {
        return this.tickValue;
    }

    public double getWidth() {
        return this.getBoundsInParent().getWidth();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.tickPosition);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.tickRotation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.tickValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public void recomputeAlignment() {
        int rotation = (int)this.getRotation() % 360;
        switch (this.side) {
            case TOP: {
                this.setTextAlignment(TextAlignment.CENTER);
                this.setTextOrigin(VPos.BOTTOM);
                if (rotation != 0 && rotation % 90 == 0) {
                    this.setTextAlignment(TextAlignment.LEFT);
                    this.setTextOrigin(VPos.CENTER);
                    break;
                }
                if (rotation % 90 == 0) break;
                this.setTextAlignment(TextAlignment.LEFT);
                this.setTextOrigin(VPos.BOTTOM);
                break;
            }
            case BOTTOM: 
            case CENTER_HOR: {
                this.setTextAlignment(TextAlignment.CENTER);
                this.setTextOrigin(VPos.TOP);
                if (rotation != 0 && rotation % 90 == 0) {
                    this.setTextAlignment(TextAlignment.LEFT);
                    this.setTextOrigin(VPos.CENTER);
                    break;
                }
                if (rotation % 90 == 0) break;
                this.setTextAlignment(TextAlignment.LEFT);
                this.setTextOrigin(VPos.TOP);
                break;
            }
            case LEFT: {
                this.setTextAlignment(TextAlignment.RIGHT);
                this.setTextOrigin(VPos.CENTER);
                if (rotation == 0 || rotation % 90 != 0) break;
                this.setTextAlignment(TextAlignment.CENTER);
                this.setTextOrigin(VPos.BOTTOM);
                break;
            }
            case RIGHT: 
            case CENTER_VER: {
                this.setTextAlignment(TextAlignment.LEFT);
                this.setTextOrigin(VPos.CENTER);
                if (rotation == 0 || rotation % 90 != 0) break;
                this.setTextAlignment(TextAlignment.CENTER);
                this.setTextOrigin(VPos.TOP);
                break;
            }
        }
    }

    public void setPosition(double value) {
        this.tickPosition = value;
    }

    public void setRotation(double value) {
        this.tickRotation = value;
        this.setRotate(this.tickRotation);
        this.recomputeAlignment();
    }

    public void setValue(Double newValue) {
        this.tickValue = newValue;
    }
}

