/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.format;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.TickUnitSupplier;
import de.gsi.chart.axes.spi.format.AbstractFormatter;
import de.gsi.chart.axes.spi.format.DefaultTickUnitSupplier;
import de.gsi.chart.utils.NumberFormatter;
import java.text.DecimalFormat;
import java.text.ParseException;
import javafx.util.StringConverter;

public class DefaultLogFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private static final String FORMAT_SMALL_SCALE = "0.######";
    private static final String FORMAT_LARGE_SCALE = "0.0E0";
    public static final int DEFAULT_SMALL_LOG_AXIS = 4;
    private final DecimalFormat formatterSmall = new DecimalFormat("0.######");
    private final DecimalFormat formatterLarge = new DecimalFormat("0.0E0");
    private final MyDecimalFormat formatter = new MyDecimalFormat(this.formatterSmall);

    public DefaultLogFormatter() {
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
    }

    public DefaultLogFormatter(Axis axis) {
        super(axis);
    }

    @Override
    public Number fromString(String string) {
        return null;
    }

    @Override
    protected double getLogRange() {
        return Math.abs(Math.log10(this.rangeMin)) + Math.abs(Math.log10(this.rangeMax));
    }

    @Override
    protected void rangeUpdated() {
        boolean smallScale = this.getLogRange() <= 4.0;
        DecimalFormat oldFormatter = this.formatter.getFormatter();
        if (smallScale) {
            this.formatter.setFormatter(this.formatterSmall);
            if (!this.formatter.getFormatter().equals(oldFormatter)) {
                this.labelCache.clear();
            }
            return;
        }
        this.formatter.setFormatter(this.formatterLarge);
        if (!this.formatter.getFormatter().equals(oldFormatter)) {
            this.labelCache.clear();
        }
    }

    @Override
    public String toString(Number object) {
        return this.labelCache.get(this.formatter, object.doubleValue());
    }

    private static class MyDecimalFormat
    extends StringConverter<Number>
    implements NumberFormatter {
        private DecimalFormat localFormatter;

        public MyDecimalFormat(DecimalFormat formatter) {
            this.localFormatter = formatter;
        }

        public Number fromString(String source) {
            try {
                return this.localFormatter.parse(source);
            }
            catch (ParseException e) {
                return Double.NaN;
            }
        }

        private DecimalFormat getFormatter() {
            return this.localFormatter;
        }

        @Override
        public int getPrecision() {
            return 0;
        }

        @Override
        public boolean isExponentialForm() {
            return false;
        }

        @Override
        public NumberFormatter setExponentialForm(boolean state) {
            return this;
        }

        private void setFormatter(DecimalFormat formatter) {
            this.localFormatter = formatter;
        }

        @Override
        public NumberFormatter setPrecision(int precision) {
            return this;
        }

        @Override
        public String toString(double val) {
            return this.localFormatter.format(val);
        }

        public String toString(Number object) {
            return this.localFormatter.format(object.doubleValue());
        }
    }
}

