/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.axes.spi.transforms;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.transforms.AbstractAxisTransform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogarithmicAxisTransform
extends AbstractAxisTransform {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogarithmicAxisTransform.class);
    public static final double DEFAULT_LOGARITHM_BASE = 10.0;
    public static final double DEFAULT_LOG_MIN_VALUE = 1.0E-6;
    public static final double DB20_LOGARITHM_BASE = Math.exp(Math.log10(10.0) / 20.0);
    public static final double DB10_LOGARITHM_BASE = Math.exp(Math.log10(10.0) / 10.0);
    private double logarithmBaseCache = 10.0;
    private double logBaseCache = Math.log10(this.logarithmBaseCache);
    private final DoubleProperty logarithmBase = new SimpleDoubleProperty(this, "logarithmBase", this.logarithmBaseCache){

        protected void invalidated() {
            if (this.get() <= 1.0) {
                throw new IllegalArgumentException("logarithmBase must be grater than 1");
            }
            LogarithmicAxisTransform.this.logarithmBaseCache = this.get();
            LogarithmicAxisTransform.this.logBaseCache = Math.log10(LogarithmicAxisTransform.this.logarithmBaseCache);
        }
    };

    public LogarithmicAxisTransform(Axis axis) {
        super(axis);
        this.rangeMin = 1.0E-6;
    }

    @Override
    public double backward(double val) {
        return this.pow(val);
    }

    @Override
    public double forward(double val) {
        return this.log(val);
    }

    public double getLogarithmBase() {
        return this.logarithmBase.get();
    }

    @Override
    public double getRoundedMaximumRange(double max) {
        return this.backward(Math.ceil(this.forward(max)));
    }

    @Override
    public double getRoundedMinimumRange(double min) {
        return min <= 0.0 ? this.rangeMin : this.backward(Math.floor(this.forward(min)));
    }

    protected double log(double value) {
        if (value <= 0.0) {
            return Double.NaN;
        }
        return Math.log10(value) / this.logBaseCache;
    }

    public DoubleProperty logarithmBaseProperty() {
        return this.logarithmBase;
    }

    protected double pow(double value) {
        return Math.pow(this.logarithmBaseCache, value);
    }

    public void setLogarithmBase(double value) {
        this.logarithmBaseProperty().set(value);
    }

    @Override
    public void setMaximumRange(double val) {
        if (val <= 0.0) {
            LOGGER.warn(String.format("%s::setMaximumRange(%f) - rejected", LogarithmicAxisTransform.class.getSimpleName(), val));
            return;
        }
        this.axis.maxProperty().set(val);
    }

    @Override
    public void setMinimumRange(double val) {
        if (val <= 0.0) {
            LOGGER.warn(String.format("%s::setMinimumRange(%f) - rejected", LogarithmicAxisTransform.class.getSimpleName(), val));
            return;
        }
        this.axis.minProperty().set(val);
    }
}

