/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.Chart;
import de.gsi.chart.XYChart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.spi.MetricPrefix;
import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.renderer.Renderer;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.spi.utils.Tuple;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Orientation;
import javafx.util.StringConverter;

public abstract class AbstractDataFormattingPlugin
extends ChartPlugin {
    private final ObjectProperty<StringConverter<Number>> xValueFormatter = new SimpleObjectProperty((Object)this, "xValueFormatter");
    private final ObjectProperty<StringConverter<Number>> yValueFormatter = new SimpleObjectProperty((Object)this, "yValueFormatter");
    private StringConverter<Number> defaultXValueFormatter;
    private StringConverter<Number> defaultYValueFormatter;

    protected AbstractDataFormattingPlugin() {
        this.chartProperty().addListener((obs, oldChart, newChart) -> {
            if (newChart != null) {
                if (!(newChart instanceof XYChart)) {
                    throw new IllegalArgumentException("cannot use chart of type '" + ((Object)newChart).getClass().getSimpleName() + "' for this plug-ing");
                }
                this.defaultXValueFormatter = AbstractDataFormattingPlugin.createDefaultFormatter(newChart.getFirstAxis(Orientation.HORIZONTAL));
                this.defaultYValueFormatter = AbstractDataFormattingPlugin.createDefaultFormatter(newChart.getFirstAxis(Orientation.VERTICAL));
            }
        });
    }

    public final StringConverter<Number> getXValueFormatter() {
        return (StringConverter)this.xValueFormatterProperty().get();
    }

    public final StringConverter<Number> getYValueFormatter() {
        return (StringConverter)this.yValueFormatterProperty().get();
    }

    public final void setXValueFormatter(StringConverter<Number> formatter) {
        this.xValueFormatterProperty().set(formatter);
    }

    public final void setYValueFormatter(StringConverter<Number> formatter) {
        this.yValueFormatterProperty().set(formatter);
    }

    public final ObjectProperty<StringConverter<Number>> xValueFormatterProperty() {
        return this.xValueFormatter;
    }

    public final ObjectProperty<StringConverter<Number>> yValueFormatterProperty() {
        return this.yValueFormatter;
    }

    private StringConverter<Number> getValueFormatter(Axis axis, StringConverter<Number> formatter, StringConverter<Number> defaultFormatter) {
        StringConverter<Number> valueFormatter = formatter;
        if (valueFormatter == null) {
            valueFormatter = axis.getTickLabelFormatter();
        }
        if (valueFormatter == null) {
            valueFormatter = defaultFormatter;
        }
        return valueFormatter;
    }

    private StringConverter<Number> getXValueFormatter(Axis xAxis) {
        return this.getValueFormatter(xAxis, this.getXValueFormatter(), this.defaultXValueFormatter);
    }

    private StringConverter<Number> getYValueFormatter(Axis yAxis) {
        return this.getValueFormatter(yAxis, this.getYValueFormatter(), this.defaultYValueFormatter);
    }

    protected String formatData(Chart chart, Tuple<Number, Number> data) {
        if (chart.getAxes().size() == 2) {
            Axis xAxis = chart.getFirstAxis(Orientation.HORIZONTAL);
            Axis yAxis = chart.getFirstAxis(Orientation.VERTICAL);
            return this.getXValueFormatter(xAxis).toString((Object)((Number)data.getXValue())) + ", " + this.getYValueFormatter(yAxis).toString((Object)((Number)data.getYValue()));
        }
        StringBuilder result = new StringBuilder();
        for (Axis axis : chart.getAxes()) {
            Side side = axis.getSide();
            if (side == null) continue;
            String axisPrimaryLabel = axis.getName();
            String axisUnit = axis.getUnit();
            String axisPrefix = MetricPrefix.getShortPrefix(axis.getUnitScaling());
            boolean isAutoScaling = axis.isAutoUnitScaling();
            if (isAutoScaling && axisUnit == null) {
                axisUnit = " a.u.";
            }
            result.append(axisPrimaryLabel).append(" = ");
            result.append(side.isHorizontal() ? this.getXValueFormatter(axis).toString((Object)((Number)data.getXValue())) : this.getYValueFormatter(axis).toString((Object)((Number)data.getYValue())));
            if (axisUnit != null) {
                result.append(axisPrimaryLabel).append(" [").append(axisPrefix).append(axisUnit).append(']');
            }
            result.append('\n');
        }
        return result.toString();
    }

    protected String formatData(Renderer renderer, Tuple<Number, Number> data) {
        if (renderer.getAxes().size() == 2) {
            Axis xAxis = renderer.getAxes().stream().filter(ax -> ax.getSide().isHorizontal()).findFirst().orElse(null);
            Axis yAxis = renderer.getAxes().stream().filter(ax -> ax.getSide().isVertical()).findFirst().orElse(null);
            if (xAxis == null || yAxis == null) {
                return String.format("DataPoint@(%.3f,%.3f)", ((Number)data.getXValue()).doubleValue(), ((Number)data.getYValue()).doubleValue());
            }
            return this.getXValueFormatter(xAxis).toString((Object)((Number)data.getXValue())) + ", " + this.getYValueFormatter(yAxis).toString((Object)((Number)data.getYValue()));
        }
        StringBuilder result = new StringBuilder();
        for (Axis axis : renderer.getAxes()) {
            Side side = axis.getSide();
            if (side == null) continue;
            String axisPrimaryLabel = axis.getName();
            String axisUnit = axis.getUnit();
            String axisPrefix = MetricPrefix.getShortPrefix(axis.getUnitScaling());
            boolean isAutoScaling = axis.isAutoUnitScaling();
            if (isAutoScaling && axisUnit == null) {
                axisUnit = " a.u.";
            }
            result.append(axisPrimaryLabel).append(" = ");
            result.append(side.isHorizontal() ? this.getXValueFormatter(axis).toString((Object)((Number)data.getXValue())) : this.getYValueFormatter(axis).toString((Object)((Number)data.getYValue())));
            if (axisUnit != null) {
                result.append(axisPrimaryLabel).append(" [").append(axisPrefix).append(axisUnit).append(']');
            }
            result.append('\n');
        }
        return result.toString();
    }

    private static StringConverter<Number> createDefaultFormatter(Axis axis) {
        return new DefaultFormatter<Number>();
    }

    private static class DefaultFormatter<T>
    extends StringConverter<T> {
        private DefaultFormatter() {
        }

        public final T fromString(String string) {
            throw new UnsupportedOperationException();
        }

        public String toString(T value) {
            return String.valueOf(value);
        }
    }
}

