/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractDataFormattingPlugin;
import de.gsi.dataset.spi.utils.Tuple;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Text;

public class CrosshairIndicator
extends AbstractDataFormattingPlugin {
    public static final String STYLE_CLASS_PATH = "chart-crosshair-path";
    public static final String STYLE_CLASS_LABEL = "chart-crosshair-label";
    private static final int LABEL_X_OFFSET = 15;
    private static final int LABEL_Y_OFFSET = 5;
    protected final Path crosshairPath = new Path();
    protected final Text coordinatesLabel = new Text();

    public CrosshairIndicator() {
        this.crosshairPath.getStyleClass().add((Object)STYLE_CLASS_PATH);
        this.crosshairPath.setManaged(false);
        this.crosshairPath.setId("crosshairIndicator-Path");
        this.coordinatesLabel.getStyleClass().add((Object)STYLE_CLASS_LABEL);
        this.coordinatesLabel.setManaged(false);
        this.coordinatesLabel.setId("crosshairIndicator-Label");
        EventHandler mouseMoveHandler = event -> {
            if (!this.isMouseEventWithinCanvas((MouseEvent)event)) {
                this.getChartChildren().remove((Object)this.crosshairPath);
                this.getChartChildren().remove((Object)this.coordinatesLabel);
                return;
            }
            Bounds plotAreaBounds = this.getChart().getBoundsInLocal();
            this.updatePath((MouseEvent)event, plotAreaBounds);
            this.updateLabel((MouseEvent)event, plotAreaBounds);
            if (!this.getChartChildren().contains((Object)this.crosshairPath)) {
                this.getChartChildren().addAll((Object[])new Node[]{this.crosshairPath, this.coordinatesLabel});
            }
        };
        this.registerInputEventHandler(MouseEvent.ANY, mouseMoveHandler);
    }

    private String formatLabelText(Point2D displayPointInPlotArea) {
        Axis yAxis = this.getChart().getFirstAxis(Orientation.VERTICAL);
        if (yAxis == null) {
            return this.getChart() + " - no y-axis present to translate point " + displayPointInPlotArea;
        }
        Tuple<Number, Number> tuple = this.toDataPoint(yAxis, displayPointInPlotArea);
        if (tuple == null) {
            return "unknown coordinate";
        }
        return this.formatData(this.getChart(), tuple);
    }

    private void updateLabel(MouseEvent event, Bounds plotAreaBounds) {
        this.coordinatesLabel.setText(this.formatLabelText(this.getLocationInPlotArea(event)));
        double width = this.coordinatesLabel.prefWidth(-1.0);
        double height = this.coordinatesLabel.prefHeight(width);
        double xLocation = event.getX() + 15.0;
        double yLocation = event.getY() + 5.0;
        if (xLocation + width > plotAreaBounds.getMaxX()) {
            xLocation = event.getX() - 15.0 - width;
        }
        if (yLocation + height > plotAreaBounds.getMaxY()) {
            yLocation = event.getY() - 5.0 - height;
        }
        this.coordinatesLabel.resizeRelocate(xLocation, yLocation, width, height);
    }

    private void updatePath(MouseEvent event, Bounds plotAreaBounds) {
        ObservableList path = this.crosshairPath.getElements();
        path.clear();
        path.add((Object)new MoveTo(plotAreaBounds.getMinX() + 1.0, event.getY()));
        path.add((Object)new LineTo(plotAreaBounds.getMaxX(), event.getY()));
        path.add((Object)new MoveTo(event.getX(), plotAreaBounds.getMinY() + 1.0));
        path.add((Object)new LineTo(event.getX(), plotAreaBounds.getMaxY()));
    }
}

