/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.plugins.ChartPlugin;
import de.gsi.chart.utils.WriteFxImage;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.DataSetUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import org.kordamp.ikonli.javafx.FontIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Screenshot
extends ChartPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Screenshot.class);
    private static final String ICON_CAMERA = "fas-camera-retro:20";
    private static final String ICON_CLIPBOARD = "far-clipboard:20";
    private static final String ICON_CLIPBOARD_SMALL = "far-clipboard:11";
    private static final String ICON_FILE = "fa-files-o:20";
    private static final String ICON_FILE_SMALL = "fa-files-o:11";
    private static final String ICON_WRENCH = "fa-wrench:20";
    private final HBox screenshotButtons = this.getScreenshotInteractorBar();
    private final StringProperty pattern = new SimpleStringProperty((Object)this, "pattern", "");
    private final StringProperty directory = new SimpleStringProperty((Object)this, "directory", System.getProperty("user.home"));
    private boolean toFile = false;

    public Screenshot() {
        this.chartProperty().addListener((change, o, n) -> {
            if (o != null) {
                o.getToolBar().getChildren().remove((Object)this.screenshotButtons);
            }
            if (n != null && this.isAddButtonsToToolBar()) {
                n.getToolBar().getChildren().add((Object)this.screenshotButtons);
            }
        });
    }

    public StringProperty patternProperty() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.patternProperty().set((Object)pattern);
    }

    public String getPattern() {
        return (String)this.patternProperty().get();
    }

    public StringProperty directoryProperty() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directoryProperty().set((Object)directory);
    }

    public String getDirectory() {
        return (String)this.directoryProperty().get();
    }

    public HBox getScreenshotInteractorBar() {
        HBox buttonBar = new HBox();
        Separator separator = new Separator();
        separator.setOrientation(Orientation.VERTICAL);
        SplitMenuButton button = new SplitMenuButton();
        button.setGraphic((Node)new HBox(0.1, new Node[]{new FontIcon(ICON_CAMERA), new FontIcon(ICON_CLIPBOARD_SMALL)}));
        button.setOnAction(evt -> {
            if (this.toFile) {
                this.screenshotToFile(true);
            } else {
                this.screenshotToClipboard();
            }
        });
        MenuItem toClipMenu = new MenuItem("Screenshot to clipboard", (Node)new FontIcon(ICON_CLIPBOARD));
        toClipMenu.setOnAction(evt -> {
            this.toFile = false;
            button.setGraphic((Node)new HBox(0.1, new Node[]{new FontIcon(ICON_CAMERA), new FontIcon(ICON_CLIPBOARD_SMALL)}));
            button.setTooltip(new Tooltip("Copy screenshot of plot to Clipboard"));
            this.screenshotToClipboard();
        });
        MenuItem toFileMenu = new MenuItem("Screenshot to file", (Node)new FontIcon(ICON_FILE));
        toFileMenu.setOnAction(evt -> {
            this.toFile = true;
            button.setGraphic((Node)new HBox(0.1, new Node[]{new FontIcon(ICON_CAMERA), new FontIcon(ICON_FILE_SMALL)}));
            button.setTooltip(new Tooltip("Save plot as image"));
            this.screenshotToFile(true);
        });
        MenuItem settingsMenu = new MenuItem("Screenshot settings", (Node)new FontIcon(ICON_WRENCH));
        settingsMenu.setOnAction(evt -> {
            ScreenshotDialog alert = new ScreenshotDialog();
            alert.showAndWait().filter(response -> response == ButtonType.OK).ifPresent(response -> {
                this.directory.set((Object)alert.getDirectory());
                this.pattern.set((Object)alert.getPattern());
            });
        });
        button.getItems().addAll((Object[])new MenuItem[]{toClipMenu, toFileMenu, new SeparatorMenuItem(), settingsMenu});
        buttonBar.getChildren().addAll((Object[])new Node[]{separator, button});
        return buttonBar;
    }

    public void screenshotToClipboard() {
        Image image = this.getScreenshot();
        Clipboard clipboard = Clipboard.getSystemClipboard();
        ClipboardContent content = new ClipboardContent();
        content.putImage(image);
        clipboard.setContent((Map)content);
        LOGGER.atInfo().log("Copied screenshot to clipboard");
    }

    public void screenshotToFile(boolean showDialog) {
        File file;
        Image image = this.getScreenshot();
        File file2 = file = showDialog ? this.showFileDialog(this.generateScreenshotName()) : new File(this.getDirectory(), this.generateScreenshotName());
        if (file == null) {
            return;
        }
        Screenshot.saveImage(image, file);
        LOGGER.atInfo().addArgument((Object)file.getName()).log("Saved screenshot to {}");
    }

    public String generateScreenshotName() {
        String initName = !this.getPattern().isEmpty() ? (this.getChart().getAllDatasets().isEmpty() ? DataSetUtils.getFileName(null, (String)this.getPattern()) : DataSetUtils.getFileName((DataSet)((DataSet)this.getChart().getAllDatasets().get(0)), (String)this.getPattern())) : (this.getChart().getTitle() != null && !this.getChart().getTitle().isBlank() ? this.getChart().getTitle() : (!this.getChart().getAllDatasets().isEmpty() && ((DataSet)this.getChart().getAllDatasets().get(0)).getName() != null && !((DataSet)this.getChart().getAllDatasets().get(0)).getName().isBlank() ? ((DataSet)this.getChart().getAllDatasets().get(0)).getName() : (this.getChart().getId() != null && !this.getChart().getId().isBlank() ? this.getChart().getId() : "UnknownChart")));
        return initName;
    }

    public Image getScreenshot() {
        SnapshotParameters snapParams = new SnapshotParameters();
        boolean oldval = this.getChart().getToolBar().isVisible();
        this.getChart().getToolBar().setVisible(false);
        WritableImage result = this.getChart().snapshot(snapParams, null);
        this.getChart().getToolBar().setVisible(oldval);
        return result;
    }

    private static void saveImage(Image image, File file) {
        try {
            WriteFxImage.savePng(image, file);
        }
        catch (IOException e) {
            LOGGER.atError().addArgument((Object)file.getName()).log("Error saving screenshot to {}");
        }
    }

    private File showFileDialog(String initName) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().setAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("PNG-Image", new String[]{"*.png"})});
        fileChooser.setInitialDirectory(new File((String)this.directory.get()));
        fileChooser.setInitialFileName(initName);
        File file = fileChooser.showSaveDialog(this.getChart().getScene().getWindow());
        if (file != null && !this.directory.isBound()) {
            this.directory.set((Object)file.getParent());
        }
        return file;
    }

    protected class ScreenshotDialog
    extends Alert {
        private final TextField dirTextbox;
        private final TextField patternTextbox;

        public ScreenshotDialog() {
            super(Alert.AlertType.CONFIRMATION, "Screenshot Settings", new ButtonType[0]);
            GridPane gridPane = new GridPane();
            this.dirTextbox = new TextField((String)Screenshot.this.directory.get());
            gridPane.add((Node)new Label("directory: "), 0, 0);
            gridPane.add((Node)this.dirTextbox, 1, 0);
            Button dirButton = new Button("choose...");
            gridPane.add((Node)dirButton, 2, 0);
            this.patternTextbox = new TextField((String)Screenshot.this.pattern.get());
            gridPane.add((Node)new Label("pattern: "), 0, 1);
            gridPane.add((Node)this.patternTextbox, 1, 1, 2, 1);
            this.patternTextbox.setTooltip(new Tooltip("Pattern:\n {datafield;type;format} style placeholders.\nDatafield:\n - systemTime: current system time\n - dataSetName\n - xMin, xMax, yMin, yMax\n - metadata field\ntype:\n - string(default)\n - date\n - int long\n - float/double\nformat:\n - date: e.g. yyyyMMdd_HHmmss\n - numeric data: printf formats e.g. %d, %e"));
            dirButton.setOnAction(evt -> {
                DirectoryChooser directoryChooser = new DirectoryChooser();
                File currentDir = new File(this.dirTextbox.getText());
                if (!currentDir.isDirectory()) {
                    currentDir = new File((String)Screenshot.this.directory.get());
                }
                if (!currentDir.isDirectory()) {
                    currentDir = new File(System.getProperty("user.home"));
                }
                directoryChooser.setInitialDirectory(currentDir);
                File file = directoryChooser.showDialog(Screenshot.this.getChart().getScene().getWindow());
                if (file != null) {
                    this.dirTextbox.setText(file.getPath());
                }
            });
            this.getDialogPane().setContent((Node)gridPane);
        }

        public String getPattern() {
            return this.patternTextbox.getText();
        }

        public String getDirectory() {
            return this.dirTextbox.getText();
        }
    }
}

