/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.ValueIndicator;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.EventSource;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class YValueIndicator
extends AbstractSingleValueIndicator
implements EventSource,
ValueIndicator {
    public YValueIndicator(Axis axis, double value) {
        this(axis, value, null);
    }

    public YValueIndicator(Axis axis, double value, String text) {
        super(axis, value, text);
        this.setLabelHorizontalAnchor(HPos.RIGHT);
        this.setLabelPosition(0.975);
        this.pickLine.setOnMouseDragged(this::handleDragMouseEvent);
        this.triangle.setOnMouseDragged(this::handleDragMouseEvent);
        this.label.setOnMouseDragged(this::handleDragMouseEvent);
    }

    protected void handleDragMouseEvent(MouseEvent mouseEvent) {
        if (!this.isEditable()) {
            return;
        }
        Point2D c = this.getChart().getPlotArea().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        double yPosData = this.getAxis().getValueForDisplay(c.getY() - this.dragDelta.y);
        if (this.getAxis().isValueOnAxis(yPosData)) {
            this.valueProperty().set(yPosData);
        }
        mouseEvent.consume();
    }

    @Override
    public void layoutChildren() {
        double axisPos;
        if (this.getChart() == null) {
            return;
        }
        Bounds plotAreaBounds = this.getChart().getCanvas().getBoundsInLocal();
        double minX = plotAreaBounds.getMinX();
        double maxX = plotAreaBounds.getMaxX();
        double minY = plotAreaBounds.getMinY();
        double maxY = plotAreaBounds.getMaxY();
        double yPos = minY + this.getAxis().getDisplayPosition(this.getValue());
        if (this.getAxis().getSide().equals((Object)Side.RIGHT)) {
            axisPos = this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(0.0, 0.0)).getX() + 2.0;
            this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, 8.0, 8.0, 8.0, -8.0});
        } else {
            axisPos = this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(this.getAxis().getWidth(), 0.0)).getX() - 2.0;
            this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, -8.0, 8.0, -8.0, -8.0});
        }
        double yPosGlobal = this.getChart().getPlotForeground().sceneToLocal(this.getChart().getCanvas().localToScene(0.0, yPos)).getY();
        if (yPos < minY || yPos > maxY) {
            this.getChartChildren().clear();
        } else {
            this.layoutLine(minX, yPos, maxX, yPos);
            this.layoutMarker(axisPos, yPosGlobal, minX, yPos);
            this.layoutLabel((Bounds)new BoundingBox(minX, yPos, maxX - minX, 0.0), this.getLabelPosition(), 0.5);
        }
    }

    @Override
    public void updateStyleClass() {
        this.setStyleClasses((Node)this.label, "y-", "value-indicator-label");
        this.setStyleClasses((Node)this.line, "y-", "value-indicator-line");
        this.setStyleClasses((Node)this.triangle, "x-", "value-indicator-marker");
    }
}

