/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins;

import de.gsi.chart.axes.Axis;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.ValueIndicator;
import de.gsi.chart.ui.geometry.Side;
import de.gsi.dataset.event.EventSource;
import java.util.Arrays;
import java.util.Comparator;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class YWatchValueIndicator
extends AbstractSingleValueIndicator
implements EventSource,
ValueIndicator {
    protected static final String STYLE_CLASS_LABEL = "value-watch-indicator-label";
    protected static final String STYLE_CLASS_LINE = "value-watch-indicator-line";
    protected static final String STYLE_CLASS_MARKER = "value-watch-indicator-marker";
    public static final String WATCH_INDICATOR_PREVENT_OCCLUSION = "WatchIndicatorPreventOcclusion";
    protected String id;

    public YWatchValueIndicator(Axis axis, double value) {
        super(axis, value, axis.getTickMarkLabel(value));
        this.triangle.visibleProperty().unbind();
        this.triangle.visibleProperty().set(true);
        this.pickLine.setOnMouseDragged(this::handleDragMouseEvent);
        this.triangle.setOnMouseDragged(this::handleDragMouseEvent);
        this.label.setOnMouseDragged(this::handleDragMouseEvent);
    }

    public YWatchValueIndicator(Axis axis) {
        this(axis, 0.0);
    }

    @Deprecated
    public YWatchValueIndicator(Axis axis, String format, double value) {
        this(axis, value);
    }

    @Deprecated
    public YWatchValueIndicator(Axis axis, String valueFormat) {
        this(axis, 0.0);
    }

    public void setMarkerValue(double value) {
        this.setText(this.getAxis().getTickMarkLabel(value));
        this.setValue(value);
    }

    public void setLineVisible(boolean lineVisible) {
        this.line.setVisible(lineVisible);
        this.pickLine.setVisible(lineVisible);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected void handleDragMouseEvent(MouseEvent mouseEvent) {
        Point2D c = this.getChart().getPlotArea().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        double yPosData = this.getAxis().getValueForDisplay(c.getY() - this.dragDelta.y);
        if (this.getAxis().isValueOnAxis(yPosData)) {
            this.setMarkerValue(yPosData);
        }
        mouseEvent.consume();
    }

    @Override
    public void layoutChildren() {
        if (this.getChart() == null) {
            return;
        }
        Bounds plotAreaBounds = this.getChart().getCanvas().getBoundsInLocal();
        double minX = plotAreaBounds.getMinX();
        double maxX = plotAreaBounds.getMaxX();
        double minY = plotAreaBounds.getMinY();
        double maxY = plotAreaBounds.getMaxY();
        double halfHeight = this.label.getHeight() / 2.0;
        double width = this.label.getWidth() + 10.0;
        double yPos = minY + this.getAxis().getDisplayPosition(this.getValue());
        boolean isRightSide = this.getAxis().getSide().equals((Object)Side.RIGHT);
        double axisPos = isRightSide ? this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(0.0, 0.0)).getX() + 2.0 : this.getChart().getPlotForeground().sceneToLocal(this.getAxis().getCanvas().localToScene(this.getAxis().getWidth(), 0.0)).getX() - 2.0;
        double yPosGlobal = this.getChart().getPlotForeground().sceneToLocal(this.getChart().getCanvas().localToScene(0.0, yPos)).getY();
        if (yPos < minY || yPos > maxY) {
            this.getChart().getPlotForeground().getChildren().remove((Object)this.triangle);
            this.getChart().getPlotForeground().getChildren().remove((Object)this.label);
            this.getChartChildren().remove((Object)this.line);
            this.getChartChildren().remove((Object)this.pickLine);
        } else {
            this.layoutLine(minX, yPos, maxX, yPos);
            this.layoutMarker(axisPos, yPosGlobal, minX, yPos);
            this.layoutWatchLabel(axisPos, yPosGlobal, isRightSide, halfHeight, width);
        }
    }

    @Override
    protected void layoutLine(double startX, double startY, double endX, double endY) {
        if (!this.line.isVisible()) {
            return;
        }
        super.layoutLine(startX, startY, endX, endY);
    }

    protected void layoutWatchLabel(double x, double y, boolean isRightSide, Double halfHeight, Double width) {
        if (this.label.getText() == null || this.label.getText().isEmpty()) {
            this.getChartChildren().remove((Object)this.label);
            return;
        }
        double labelWidth = this.label.prefWidth(-1.0);
        double labelHeight = this.label.prefHeight(labelWidth);
        double padding = 2.0;
        if (this.isPreventOcclusion()) {
            int i;
            YWatchValueIndicator[] indicators = (YWatchValueIndicator[])this.getChart().getPlugins().filtered(p -> p instanceof YWatchValueIndicator && ((YWatchValueIndicator)p).getAxis() == this.getAxis()).toArray((Object[])new YWatchValueIndicator[0]);
            Arrays.sort(indicators, Comparator.comparingDouble(AbstractSingleValueIndicator::getValue).reversed());
            double[] movedPosition = Arrays.stream(indicators).mapToDouble(ind -> ind.triangle.getTranslateY()).toArray();
            for (i = 0; i < movedPosition.length - 1; ++i) {
                double diff = movedPosition[i + 1] - movedPosition[i];
                if (!(labelHeight + 2.0 > diff)) continue;
                double offset = halfHeight - 0.5 * diff + 1.0;
                int n = i + 1;
                movedPosition[n] = movedPosition[n] + offset;
                int n2 = i;
                movedPosition[n2] = movedPosition[n2] - offset;
                for (int j = i - 1; j >= 0; --j) {
                    double diff2 = movedPosition[j + 1] - movedPosition[j];
                    if (!(labelHeight + 2.0 > diff2)) continue;
                    int n3 = j;
                    movedPosition[n3] = movedPosition[n3] - (2.0 * halfHeight - diff2 + 2.0);
                }
            }
            for (i = 0; i < movedPosition.length; ++i) {
                double offset = movedPosition[i] - indicators[i].triangle.getTranslateY();
                double halfHeightPos = offset + halfHeight;
                double halfHeightNeg = offset - halfHeight;
                if (isRightSide) {
                    indicators[i].triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, 10.0, halfHeightPos, width, halfHeightPos, width, halfHeightNeg, 10.0, halfHeightNeg});
                } else {
                    indicators[i].triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, -10.0, halfHeightPos, -width.doubleValue(), halfHeightPos, -width.doubleValue(), halfHeightNeg, -10.0, halfHeightNeg});
                }
                indicators[i].label.resizeRelocate(isRightSide ? x : x - labelWidth, indicators[i].triangle.getTranslateY() - 0.5 * labelHeight + offset, labelWidth, labelHeight);
            }
        } else {
            if (isRightSide) {
                this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, 10.0, halfHeight, width, halfHeight, width, -halfHeight.doubleValue(), 10.0, -halfHeight.doubleValue()});
            } else {
                this.triangle.getPoints().setAll((Object[])new Double[]{0.0, 0.0, -10.0, halfHeight, -width.doubleValue(), halfHeight, -width.doubleValue(), -halfHeight.doubleValue(), -10.0, -halfHeight.doubleValue()});
            }
            this.label.resizeRelocate(isRightSide ? x : x - labelWidth, y - 0.5 * labelHeight, labelWidth, labelHeight);
        }
        this.label.toFront();
        if (!this.getChart().getPlotForeground().getChildren().contains((Object)this.label)) {
            this.getChart().getPlotForeground().getChildren().add((Object)this.label);
        }
    }

    @Override
    public void updateStyleClass() {
        this.setStyleClasses((Node)this.label, this.getId() + "-", STYLE_CLASS_LABEL);
        this.setStyleClasses((Node)this.line, this.getId() + "-", STYLE_CLASS_LINE);
        this.setStyleClasses((Node)this.triangle, this.getId() + "-", STYLE_CLASS_MARKER);
    }

    public boolean isPreventOcclusion() {
        return this.getAxis() instanceof Node && ((Node)this.getAxis()).getProperties().get((Object)WATCH_INDICATOR_PREVENT_OCCLUSION) == Boolean.TRUE;
    }

    public void setPreventOcclusion(boolean state) {
        if (state) {
            ((Node)this.getAxis()).getProperties().put((Object)WATCH_INDICATOR_PREVENT_OCCLUSION, (Object)true);
        } else {
            ((Node)this.getAxis()).getProperties().remove((Object)WATCH_INDICATOR_PREVENT_OCCLUSION);
        }
    }
}

