/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.chart.plugins.measurements;

import de.gsi.chart.Chart;
import de.gsi.chart.axes.Axis;
import de.gsi.chart.axes.AxisLabelFormatter;
import de.gsi.chart.axes.AxisMode;
import de.gsi.chart.axes.spi.DefaultNumericAxis;
import de.gsi.chart.axes.spi.MetricPrefix;
import de.gsi.chart.plugins.AbstractSingleValueIndicator;
import de.gsi.chart.plugins.ParameterMeasurements;
import de.gsi.chart.plugins.measurements.AbstractChartMeasurement;
import de.gsi.chart.utils.DragResizerUtil;
import de.gsi.chart.utils.FXUtils;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.math.SimpleDataSetEstimators;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMeasurements
extends AbstractChartMeasurement {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMeasurements.class);
    private final MeasurementType measType;

    public SimpleMeasurements(ParameterMeasurements plugin, MeasurementType measType) {
        super(plugin, measType.toString(), measType.isVertical ? AxisMode.X : AxisMode.Y, measType.getRequiredSelectors(), 1);
        this.measType = measType;
        this.setTitle(measType.toString());
        this.getValueField().setMinRange(Double.NEGATIVE_INFINITY).setMaxRange(Double.POSITIVE_INFINITY);
        this.addMinMaxRangeFields();
    }

    public MeasurementType getMeasType() {
        return this.measType;
    }

    public void handle(UpdateEvent event) {
        DataSet ds = this.getDataSet();
        if (this.getValueIndicatorsUser().size() < this.measType.getRequiredSelectors() || ds == null) {
            return;
        }
        double newValueMarker1 = this.requiredNumberOfIndicators >= 1 && !this.getValueIndicatorsUser().isEmpty() ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(0)).getValue() : Double.NEGATIVE_INFINITY;
        double newValueMarker2 = this.requiredNumberOfIndicators >= 2 && this.getValueIndicatorsUser().size() >= 2 ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(1)).getValue() : Double.POSITIVE_INFINITY;
        ds.lock().readLockGuard(() -> {
            String valueLabel;
            String unit;
            if (!ds.getAxisDescription(0).isDefined()) {
                ds.recomputeLimits(0);
            }
            int index0 = ds.getIndex(0, new double[]{newValueMarker1});
            int index1 = ds.getIndex(0, new double[]{newValueMarker2});
            int indexMin = this.requiredNumberOfIndicators == 1 ? index0 : Math.min(index0, index1);
            int indexMax = Math.max(index0, index1);
            Chart chart = this.getMeasurementPlugin().getChart();
            Axis axis = SimpleMeasurements.getFirstAxisForDataSet(chart, ds, !this.measType.isVerticalMeasurement());
            double val = Double.NaN;
            switch (this.measType) {
                case MARKER_HOR: {
                    val = newValueMarker1;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, ds, true);
                    break;
                }
                case MARKER_DISTANCE_HOR: {
                    val = newValueMarker2 - newValueMarker1;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, ds, true);
                    break;
                }
                case MARKER_VER: {
                    val = newValueMarker1;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, ds, false);
                    break;
                }
                case MARKER_DISTANCE_VER: {
                    val = newValueMarker2 - newValueMarker1;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, ds, false);
                    break;
                }
                case VALUE_HOR: {
                    val = SimpleDataSetEstimators.getZeroCrossing((DataSet)ds, (double)newValueMarker1);
                    break;
                }
                case VALUE_VER: {
                    val = ds.get(1, indexMin);
                    break;
                }
                case DISTANCE_HOR: {
                    val = SimpleDataSetEstimators.getZeroCrossing((DataSet)ds, (double)newValueMarker2) - SimpleDataSetEstimators.getZeroCrossing((DataSet)ds, (double)newValueMarker1);
                    break;
                }
                case DISTANCE_VER: {
                    val = SimpleDataSetEstimators.getDistance((DataSet)ds, (int)indexMin, (int)indexMax, (boolean)false);
                    break;
                }
                case MINIMUM: {
                    val = SimpleDataSetEstimators.getMinimum((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case MAXIMUM: {
                    val = SimpleDataSetEstimators.getMaximum((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case RANGE: {
                    val = SimpleDataSetEstimators.getRange((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case MEAN: {
                    val = SimpleDataSetEstimators.getMean((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case RMS: {
                    val = SimpleDataSetEstimators.getRms((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case MEDIAN: {
                    val = SimpleDataSetEstimators.getMedian((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case INTEGRAL: {
                    val = SimpleDataSetEstimators.getIntegral((DataSet)ds, (int)index0, (int)index1);
                    break;
                }
                case INTEGRAL_FULL: {
                    val = SimpleDataSetEstimators.getIntegral((DataSet)ds, (int)0, (int)ds.getDataCount());
                    break;
                }
                case TRANSMISSION_ABS: {
                    val = SimpleDataSetEstimators.getTransmission((DataSet)ds, (int)index0, (int)index1, (boolean)true);
                    break;
                }
                case TRANSMISSION_REL: {
                    val = SimpleDataSetEstimators.getTransmission((DataSet)ds, (int)index0, (int)index1, (boolean)false);
                    break;
                }
                case EDGE_DETECT: {
                    val = SimpleDataSetEstimators.getEdgeDetect((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case RISETIME_10_90: {
                    val = SimpleDataSetEstimators.getSimpleRiseTime1090((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case RISETIME_20_80: {
                    val = SimpleDataSetEstimators.getSimpleRiseTime2080((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case FWHM: {
                    val = SimpleDataSetEstimators.getFullWidthHalfMaximum((DataSet)ds, (int)indexMin, (int)indexMax, (boolean)false);
                    break;
                }
                case FWHM_INTERPOLATED: {
                    val = SimpleDataSetEstimators.getFullWidthHalfMaximum((DataSet)ds, (int)indexMin, (int)indexMax, (boolean)true);
                    break;
                }
                case LOCATION_MAXIMUM: {
                    val = ds.get(0, SimpleDataSetEstimators.getLocationMaximum((DataSet)ds, (int)indexMin, (int)indexMax));
                    break;
                }
                case LOCATION_MAXIMUM_GAUSS: {
                    val = SimpleDataSetEstimators.getLocationMaximumGaussInterpolated((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case DUTY_CYCLE: {
                    val = SimpleDataSetEstimators.getDutyCycle((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case PERIOD: {
                    val = 1.0 / SimpleDataSetEstimators.getFrequencyEstimate((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
                case FREQUENCY: {
                    val = SimpleDataSetEstimators.getFrequencyEstimate((DataSet)ds, (int)indexMin, (int)indexMax);
                    break;
                }
            }
            String axisUnit = axis.getUnit();
            String string = unit = axisUnit == null ? "a.u." : axisUnit;
            if (axis instanceof DefaultNumericAxis && axisUnit != null) {
                double unitScale = axis.getUnitScaling();
                String axisPrefix = MetricPrefix.getShortPrefix(unitScale);
                double scaledValue = val / unitScale;
                FXUtils.runFX(() -> this.getValueField().setUnit(axisPrefix + unit));
                AxisLabelFormatter axisFormatter = ((DefaultNumericAxis)axis).getAxisLabelFormatter();
                valueLabel = axisFormatter.toString(scaledValue);
            } else {
                valueLabel = Math.abs(Math.log10(Math.abs(val))) < 3.0 ? this.formatterSmall.format(val) : this.formatterLarge.format(val);
                FXUtils.runFX(() -> this.getValueField().setUnit(unit));
            }
            double tempVal = val;
            FXUtils.runFX(() -> this.getValueField().setValue(tempVal, valueLabel));
            switch (this.measType) {
                case TRANSMISSION_ABS: 
                case TRANSMISSION_REL: {
                    FXUtils.runFX(() -> this.getValueField().setUnit("%"));
                    break;
                }
            }
        });
        if (event != null) {
            this.invokeListener(event);
        }
    }

    @Override
    public void initialize() {
        this.getDataViewWindow().setContent((Node)this.getValueField());
        DragResizerUtil.makeResizable((Node)this.getValueField());
        Optional<ButtonType> result = super.showConfigDialogue();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument(result).log("config dialogue finished with result {}");
            LOGGER.atTrace().addArgument(this.getValueIndicators()).log("detected getValueIndicators() = {}");
            LOGGER.atTrace().addArgument(this.getValueIndicatorsUser()).log("detected getValueIndicatorsUser() = {}");
        }
        this.handle(null);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().log("initialised and called initial handle(null)");
        }
    }

    @Override
    protected void removeAction() {
        super.removeAction();
        this.getMeasurementPlugin().getChart().requestLayout();
    }

    public static enum MeasurementType {
        MARKER_HOR(true, MeasurementCategory.INDICATOR, "Marker X", 1),
        MARKER_DISTANCE_HOR(true, MeasurementCategory.INDICATOR, "Marker \u2206X"),
        MARKER_VER(false, MeasurementCategory.INDICATOR, "Marker Y", 1),
        MARKER_DISTANCE_VER(false, MeasurementCategory.INDICATOR, "Marker \u2206Y"),
        VALUE_HOR(false, MeasurementCategory.INDICATOR, "hor. value", 1),
        DISTANCE_HOR(false, MeasurementCategory.INDICATOR, "hor. distance"),
        VALUE_VER(true, MeasurementCategory.INDICATOR, "ver. value", 1),
        DISTANCE_VER(true, MeasurementCategory.INDICATOR, "ver. distance"),
        MINIMUM(true, MeasurementCategory.VERTICAL, "Minimum"),
        MAXIMUM(true, MeasurementCategory.VERTICAL, "Maximum"),
        RANGE(true, MeasurementCategory.VERTICAL, "Range"),
        MEAN(true, MeasurementCategory.VERTICAL, "Mean"),
        RMS(true, MeasurementCategory.VERTICAL, "R.M.S."),
        MEDIAN(true, MeasurementCategory.VERTICAL, "Median"),
        INTEGRAL(true, MeasurementCategory.VERTICAL, "Integral"),
        INTEGRAL_FULL(true, MeasurementCategory.VERTICAL, "Integral - full range", 0),
        TRANSMISSION_ABS(true, MeasurementCategory.ACC, "Abs. Transmission"),
        TRANSMISSION_REL(true, MeasurementCategory.ACC, "Rel. Transmission"),
        EDGE_DETECT(true, MeasurementCategory.HORIZONTAL, "Edge-Detect"),
        RISETIME_10_90(true, MeasurementCategory.HORIZONTAL, "10%-90% Rise-/Fall-Time\n (simple)"),
        RISETIME_20_80(true, MeasurementCategory.HORIZONTAL, "20%-80% Rise-/Fall-Time\n (simple)"),
        FWHM(true, MeasurementCategory.HORIZONTAL, "FWHM"),
        FWHM_INTERPOLATED(true, MeasurementCategory.HORIZONTAL, "FWHM (interp.)"),
        LOCATION_MAXIMUM(true, MeasurementCategory.HORIZONTAL, "Loc. Maximum"),
        LOCATION_MAXIMUM_GAUSS(true, MeasurementCategory.HORIZONTAL, "Loc. Maximum\n(Gauss-interp.)"),
        DUTY_CYCLE(true, MeasurementCategory.HORIZONTAL, "Duty Cycle\n(10% hysteresis)"),
        PERIOD(true, MeasurementCategory.HORIZONTAL, "Period"),
        FREQUENCY(true, MeasurementCategory.HORIZONTAL, "Frequency");

        private final String name;
        private final MeasurementCategory category;
        private final boolean isVertical;
        private final int requiredSelectors;
        private final int requiredDataSets;

        private MeasurementType(boolean isVerticalMeasurement, MeasurementCategory measurementCategory, String description) {
            this(isVerticalMeasurement, measurementCategory, description, 2);
        }

        private MeasurementType(boolean isVerticalMeasurement, MeasurementCategory measurementCategory, String description, int requiredSelectors) {
            this.isVertical = isVerticalMeasurement;
            this.category = measurementCategory;
            this.name = description;
            this.requiredSelectors = requiredSelectors;
            this.requiredDataSets = 1;
        }

        public MeasurementCategory getCategory() {
            return this.category;
        }

        public boolean isVerticalMeasurement() {
            return this.isVertical;
        }

        public String getName() {
            return this.name;
        }

        public int getRequiredDataSets() {
            return this.requiredDataSets;
        }

        public int getRequiredSelectors() {
            return this.requiredSelectors;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MeasurementCategory {
        INDICATOR("Indicators"),
        VERTICAL("Vertical Measurements"),
        HORIZONTAL("Horizontal Measurements"),
        ACC("Accelerator Misc.");

        private final String name;

        private MeasurementCategory(String description) {
            this.name = description;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

